/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import org.zeromq.ZMQException;
import zmq.Ctx;
import zmq.DecoderBase;
import zmq.EncoderBase;
import zmq.Msg;
import zmq.SocketBase;
import zmq.ZError;
import zmq.ZMQ;

public class ZMQ {
    public static final int SNDMORE = 2;
    public static final int DONTWAIT = 1;
    public static final int NOBLOCK = 1;
    public static final int PAIR = 0;
    public static final int PUB = 1;
    public static final int SUB = 2;
    public static final int REQ = 3;
    public static final int REP = 4;
    public static final int DEALER = 5;
    public static final int XREQ = 5;
    public static final int ROUTER = 6;
    public static final int XREP = 6;
    public static final int PULL = 7;
    public static final int PUSH = 8;
    public static final int XPUB = 9;
    public static final int XSUB = 10;
    public static final int STREAMER = 1;
    public static final int FORWARDER = 2;
    public static final int QUEUE = 3;
    @Deprecated
    public static final int UPSTREAM = 7;
    @Deprecated
    public static final int DOWNSTREAM = 8;
    public static final int EVENT_CONNECTED = 1;
    public static final int EVENT_CONNECT_DELAYED = 2;
    @Deprecated
    public static final int EVENT_DELAYED = 2;
    public static final int EVENT_CONNECT_RETRIED = 4;
    @Deprecated
    public static final int EVENT_RETRIED = 4;
    public static final int EVENT_LISTENING = 8;
    public static final int EVENT_BIND_FAILED = 16;
    public static final int EVENT_ACCEPTED = 32;
    public static final int EVENT_ACCEPT_FAILED = 64;
    public static final int EVENT_CLOSED = 128;
    public static final int EVENT_CLOSE_FAILED = 256;
    public static final int EVENT_DISCONNECTED = 512;
    public static final int EVENT_MONITOR_STOPPED = 1024;
    public static final int EVENT_ALL = 2047;
    public static final byte[] MESSAGE_SEPARATOR = new byte[0];
    public static final byte[] SUBSCRIPTION_ALL = new byte[0];
    public static final Charset CHARSET = Charset.forName("UTF-8");

    private ZMQ() {
    }

    public static Context context(int ioThreads) {
        return new Context(ioThreads);
    }

    @Deprecated
    public static boolean device(int type, Socket frontend, Socket backend) {
        return zmq.ZMQ.proxy(frontend.base, backend.base, null);
    }

    public static boolean proxy(Socket frontend, Socket backend, Socket capture) {
        return zmq.ZMQ.proxy(frontend.base, backend.base, capture != null ? capture.base : null);
    }

    public static int poll(PollItem[] items, long timeout) {
        return ZMQ.poll(items, items.length, timeout);
    }

    public static int poll(PollItem[] items, int count2, long timeout) {
        zmq.PollItem[] pollItems = new zmq.PollItem[count2];
        for (int i = 0; i < count2; ++i) {
            pollItems[i] = items[i].base;
        }
        return zmq.ZMQ.poll(pollItems, count2, timeout);
    }

    public static int getMajorVersion() {
        return 3;
    }

    public static int getMinorVersion() {
        return 2;
    }

    public static int getPatchVersion() {
        return 5;
    }

    public static int getFullVersion() {
        return zmq.ZMQ.makeVersion(3, 2, 5);
    }

    public static int makeVersion(int major, int minor, int patch) {
        return zmq.ZMQ.makeVersion(major, minor, patch);
    }

    public static String getVersionString() {
        return "3.2.5";
    }

    public static class Event {
        private final int event;
        private final Object value;
        private final String address;

        public Event(int event, Object value2, String address) {
            this.event = event;
            this.value = value2;
            this.address = address;
        }

        public int getEvent() {
            return this.event;
        }

        public Object getValue() {
            return this.value;
        }

        public String getAddress() {
            return this.address;
        }

        public static Event recv(Socket socket, int flags) {
            ZMQ.Event e2 = ZMQ.Event.read(socket.base, flags);
            return e2 != null ? new Event(e2.event, e2.arg, e2.addr) : null;
        }

        public static Event recv(Socket socket) {
            return Event.recv(socket, 0);
        }
    }

    public static enum Error {
        ENOTSUP(45),
        EPROTONOSUPPORT(43),
        ENOBUFS(55),
        ENETDOWN(50),
        EADDRINUSE(48),
        EADDRNOTAVAIL(49),
        ECONNREFUSED(61),
        EINPROGRESS(36),
        EMTHREAD(156384766),
        EFSM(156384763),
        ENOCOMPATPROTO(156384764),
        ETERM(156384765),
        ENOTSOCK(156384717),
        EAGAIN(35);

        private final int code;

        private Error(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static Error findByCode(int code) {
            for (Error e2 : (Error[])Error.class.getEnumConstants()) {
                if (e2.getCode() != code) continue;
                return e2;
            }
            throw new IllegalArgumentException("Unknown " + Error.class.getName() + " enum code:" + code);
        }
    }

    public static class PollItem {
        private final zmq.PollItem base;
        private final Socket socket;

        public PollItem(Socket socket, int ops) {
            this.socket = socket;
            this.base = new zmq.PollItem(socket.base, ops);
        }

        public PollItem(SelectableChannel channel, int ops) {
            this.base = new zmq.PollItem(channel, ops);
            this.socket = null;
        }

        protected final zmq.PollItem base() {
            return this.base;
        }

        public final SelectableChannel getRawSocket() {
            return this.base.getRawSocket();
        }

        public final Socket getSocket() {
            return this.socket;
        }

        public final boolean isReadable() {
            return this.base.isReadable();
        }

        public final boolean isWritable() {
            return this.base.isWritable();
        }

        public final boolean isError() {
            return this.base.isError();
        }

        public final int readyOps() {
            return this.base.readyOps();
        }

        public int hashCode() {
            return this.base.hashCode();
        }

        public boolean equals(Object obj2) {
            if (!(obj2 instanceof PollItem)) {
                return false;
            }
            PollItem target = (PollItem)obj2;
            if (this.socket != null && this.socket == target.socket) {
                return true;
            }
            return this.getRawSocket() != null && this.getRawSocket() == target.getRawSocket();
        }
    }

    public static class Poller {
        public static final int POLLIN = 1;
        public static final int POLLOUT = 2;
        public static final int POLLERR = 4;
        private static final int SIZE_DEFAULT = 32;
        private static final int SIZE_INCREMENT = 16;
        private PollItem[] items;
        private long timeout;
        private int next;

        public Poller(int size2) {
            this(null, size2);
        }

        protected Poller(Context context, int size2) {
            this.items = new PollItem[size2];
            this.timeout = -1L;
            this.next = 0;
        }

        protected Poller(Context context) {
            this(context, 32);
        }

        public int register(Socket socket) {
            return this.register(socket, 7);
        }

        public int register(Socket socket, int events) {
            return this.insert(new PollItem(socket, events));
        }

        public int register(SelectableChannel channel, int events) {
            return this.insert(new PollItem(channel, events));
        }

        public int register(PollItem item) {
            return this.insert(item);
        }

        private int insert(PollItem item) {
            int pos;
            if ((pos = this.next++) == this.items.length) {
                PollItem[] nitems = new PollItem[this.items.length + 16];
                System.arraycopy(this.items, 0, nitems, 0, this.items.length);
                this.items = nitems;
            }
            this.items[pos] = item;
            return pos;
        }

        public void unregister(Socket socket) {
            for (int pos = 0; pos < this.items.length; ++pos) {
                PollItem item = this.items[pos];
                if (item.getSocket() != socket) continue;
                this.remove(pos);
                break;
            }
        }

        public void unregister(SelectableChannel channel) {
            for (int pos = 0; pos < this.items.length; ++pos) {
                PollItem item = this.items[pos];
                if (item.getRawSocket() != channel) continue;
                this.remove(pos);
                break;
            }
        }

        private void remove(int pos) {
            --this.next;
            if (pos != this.next) {
                this.items[pos] = this.items[this.next];
            }
            this.items[this.next] = null;
        }

        public PollItem getItem(int index2) {
            if (index2 < 0 || index2 >= this.next) {
                return null;
            }
            return this.items[index2];
        }

        public Socket getSocket(int index2) {
            if (index2 < 0 || index2 >= this.next) {
                return null;
            }
            return this.items[index2].getSocket();
        }

        public long getTimeout() {
            return this.timeout;
        }

        public void setTimeout(long timeout) {
            if (timeout < -1L) {
                return;
            }
            this.timeout = timeout;
        }

        public int getSize() {
            return this.items.length;
        }

        public int getNext() {
            return this.next;
        }

        public int poll() {
            long tout = -1L;
            if (this.timeout > -1L) {
                tout = this.timeout;
            }
            return this.poll(tout);
        }

        public int poll(long tout) {
            zmq.PollItem[] pollItems = new zmq.PollItem[this.next];
            for (int i = 0; i < this.next; ++i) {
                pollItems[i] = this.items[i].base();
            }
            return zmq.ZMQ.poll(pollItems, this.next, tout);
        }

        public boolean pollin(int index2) {
            if (index2 < 0 || index2 >= this.next) {
                return false;
            }
            return this.items[index2].isReadable();
        }

        public boolean pollout(int index2) {
            if (index2 < 0 || index2 >= this.next) {
                return false;
            }
            return this.items[index2].isWritable();
        }

        public boolean pollerr(int index2) {
            if (index2 < 0 || index2 >= this.next) {
                return false;
            }
            return this.items[index2].isError();
        }
    }

    public static class Socket
    implements Closeable {
        private static final int DYNFROM = 49152;
        private static final int DYNTO = 65535;
        private final Ctx ctx;
        private final SocketBase base;
        private final AtomicBoolean isClosed = new AtomicBoolean(false);

        protected Socket(Context context, int type) {
            this.ctx = context.ctx;
            this.base = this.ctx.createSocket(type);
        }

        protected Socket(SocketBase base) {
            this.ctx = null;
            this.base = base;
        }

        public SocketBase base() {
            return this.base;
        }

        @Override
        public void close() {
            if (this.isClosed.compareAndSet(false, true)) {
                this.base.close();
            }
        }

        public final int getType() {
            return this.base.getSocketOpt(16);
        }

        public final long getLinger() {
            return this.base.getSocketOpt(17);
        }

        private void setsockopt(int option2, Object value2) {
            try {
                this.base.setSocketOpt(option2, value2);
            }
            catch (ZError.CtxTerminatedException ctxTerminatedException) {
                // empty catch block
            }
        }

        public final void setLinger(long value2) {
            this.base.setSocketOpt(17, (int)value2);
        }

        public final long getReconnectIVL() {
            return this.base.getSocketOpt(18);
        }

        public final void setReconnectIVL(long value2) {
            this.base.setSocketOpt(18, (int)value2);
        }

        public final long getBacklog() {
            return this.base.getSocketOpt(19);
        }

        public final void setBacklog(long value2) {
            this.setsockopt(19, (int)value2);
        }

        public final long getReconnectIVLMax() {
            return this.base.getSocketOpt(21);
        }

        public final void setReconnectIVLMax(long value2) {
            this.setsockopt(21, (int)value2);
        }

        public final long getMaxMsgSize() {
            return (Long)this.base.getsockoptx(22);
        }

        public final void setMaxMsgSize(long value2) {
            this.setsockopt(22, value2);
        }

        public final long getSndHWM() {
            return this.base.getSocketOpt(23);
        }

        public final void setSndHWM(long value2) {
            this.setsockopt(23, (int)value2);
        }

        public final long getRcvHWM() {
            return this.base.getSocketOpt(24);
        }

        public final void setRcvHWM(long value2) {
            this.setsockopt(24, (int)value2);
        }

        @Deprecated
        public final long getHWM() {
            return -1L;
        }

        public final void setHWM(long hwm) {
            this.setSndHWM(hwm);
            this.setRcvHWM(hwm);
        }

        @Deprecated
        public final long getSwap() {
            return -1L;
        }

        @Deprecated
        public final void setSwap(long value2) {
            throw new UnsupportedOperationException();
        }

        public final long getAffinity() {
            return (Long)this.base.getsockoptx(4);
        }

        public final void setAffinity(long value2) {
            this.setsockopt(4, value2);
        }

        public final byte[] getIdentity() {
            return (byte[])this.base.getsockoptx(5);
        }

        public final void setIdentity(byte[] identity2) {
            this.setsockopt(5, identity2);
        }

        public final long getRate() {
            return this.base.getSocketOpt(8);
        }

        public final void setRate(long value2) {
            throw new UnsupportedOperationException();
        }

        public final long getRecoveryInterval() {
            return this.base.getSocketOpt(9);
        }

        public final void setRecoveryInterval(long value2) {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public final boolean hasMulticastLoop() {
            return false;
        }

        @Deprecated
        public final void setMulticastLoop(boolean multicastLoop) {
            throw new UnsupportedOperationException();
        }

        public final long getMulticastHops() {
            return this.base.getSocketOpt(25);
        }

        public final void setMulticastHops(long value2) {
            throw new UnsupportedOperationException();
        }

        public final int getReceiveTimeOut() {
            return this.base.getSocketOpt(27);
        }

        public final void setReceiveTimeOut(int value2) {
            this.setsockopt(27, value2);
        }

        public final int getSendTimeOut() {
            return this.base.getSocketOpt(28);
        }

        public final void setSendTimeOut(int value2) {
            this.setsockopt(28, value2);
        }

        public void setTCPKeepAlive(long value2) {
            this.setsockopt(34, value2);
        }

        public long getTCPKeepAliveSetting() {
            return this.base.getSocketOpt(34);
        }

        public void setTCPKeepAliveCount(long value2) {
            this.setsockopt(35, value2);
        }

        public long getTCPKeepAliveCount() {
            return this.base.getSocketOpt(35);
        }

        public void setTCPKeepAliveInterval(long value2) {
            this.setsockopt(37, value2);
        }

        public long getTCPKeepAliveInterval() {
            return this.base.getSocketOpt(37);
        }

        public void setTCPKeepAliveIdle(long value2) {
            this.setsockopt(36, value2);
        }

        public long getTCPKeepAliveIdle() {
            return this.base.getSocketOpt(36);
        }

        public final long getSendBufferSize() {
            return this.base.getSocketOpt(11);
        }

        public final void setSendBufferSize(long value2) {
            this.setsockopt(11, (int)value2);
        }

        public final long getReceiveBufferSize() {
            return this.base.getSocketOpt(12);
        }

        public final void setReceiveBufferSize(long value2) {
            this.setsockopt(12, (int)value2);
        }

        public final boolean hasReceiveMore() {
            return this.base.getSocketOpt(13) == 1;
        }

        public final SelectableChannel getFD() {
            return (SelectableChannel)this.base.getsockoptx(14);
        }

        public final int getEvents() {
            return this.base.getSocketOpt(15);
        }

        public final void subscribe(byte[] topic) {
            this.setsockopt(6, topic);
        }

        public final void unsubscribe(byte[] topic) {
            this.setsockopt(7, topic);
        }

        public final void setEncoder(Class<? extends EncoderBase> cls) {
            this.base.setSocketOpt(1001, cls);
        }

        public final void setDecoder(Class<? extends DecoderBase> cls) {
            this.base.setSocketOpt(1002, cls);
        }

        public final void setRouterMandatory(boolean mandatory) {
            this.setsockopt(33, mandatory ? 1 : 0);
        }

        public final void setRouterHandover(boolean handlover) {
            this.setsockopt(56, handlover ? 1 : 0);
        }

        public final void setXpubVerbose(boolean verbose) {
            this.setsockopt(40, verbose ? 1 : 0);
        }

        public final boolean getIPv4Only() {
            return this.base.getSocketOpt(31) == 1;
        }

        public void setIPv4Only(boolean v4only) {
            this.setsockopt(31, v4only ? 1 : 0);
        }

        public int getTCPKeepAlive() {
            return this.base.getSocketOpt(34);
        }

        public void setTCPKeepAlive(int optVal) {
            this.setsockopt(34, optVal);
        }

        public boolean getDelayAttachOnConnect() {
            return this.base.getSocketOpt(39) == 1;
        }

        public void setDelayAttachOnConnect(boolean value2) {
            this.setsockopt(39, value2 ? 1 : 0);
        }

        public final void bind(String addr) {
            this.bind(addr, 49152, 65535);
        }

        private int bind(String addr, int min2, int max2) {
            if (addr.endsWith(":*")) {
                String prefix = addr.substring(0, addr.lastIndexOf(58) + 1);
                for (int port = min2; port <= max2; ++port) {
                    addr = prefix + port;
                    if (!this.base.bind(addr)) continue;
                    return port;
                }
            } else if (this.base.bind(addr)) {
                int port = 0;
                try {
                    port = Integer.parseInt(addr.substring(addr.lastIndexOf(58) + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return port;
            }
            this.mayRaise();
            return -1;
        }

        public int bindToRandomPort(String addr) {
            return this.bind(addr + ":*", 49152, 65535);
        }

        public int bindToRandomPort(String addr, int min2, int max2) {
            return this.bind(addr + ":*", min2, max2);
        }

        public final void connect(String addr) {
            this.base.connect(addr);
            this.mayRaise();
        }

        public final boolean unbind(String addr) {
            return this.base.termEndpoint(addr);
        }

        public final boolean send(String data) {
            return this.send(data.getBytes(CHARSET), 0);
        }

        public final boolean sendMore(String data) {
            return this.send(data.getBytes(CHARSET), 2);
        }

        public final boolean send(String data, int flags) {
            return this.send(data.getBytes(CHARSET), flags);
        }

        public final boolean send(byte[] data) {
            return this.send(data, 0);
        }

        public final boolean sendMore(byte[] data) {
            return this.send(data, 2);
        }

        public final boolean send(byte[] data, int flags) {
            Msg msg = new Msg(data);
            if (this.base.send(msg, flags)) {
                return true;
            }
            this.mayRaise();
            return false;
        }

        public final boolean send(byte[] data, int off, int length2, int flags) {
            byte[] copy2 = new byte[length2];
            System.arraycopy(data, off, copy2, 0, length2);
            Msg msg = new Msg(copy2);
            if (this.base.send(msg, flags)) {
                return true;
            }
            this.mayRaise();
            return false;
        }

        public final int sendByteBuffer(ByteBuffer data, int flags) {
            Msg msg = new Msg(data);
            if (this.base.send(msg, flags)) {
                return msg.size();
            }
            this.mayRaise();
            return -1;
        }

        public final byte[] recv() {
            return this.recv(0);
        }

        public final byte[] recv(int flags) {
            Msg msg = this.base.recv(flags);
            if (msg != null) {
                return msg.data();
            }
            this.mayRaise();
            return null;
        }

        public final int recv(byte[] buffer2, int offset, int len2, int flags) {
            Msg msg = this.base.recv(flags);
            if (msg != null) {
                return msg.getBytes(0, buffer2, offset, len2);
            }
            return -1;
        }

        public final int recvByteBuffer(ByteBuffer buffer2, int flags) {
            Msg msg = this.base.recv(flags);
            if (msg != null) {
                buffer2.put(msg.buf());
                return msg.size();
            }
            this.mayRaise();
            return -1;
        }

        public final String recvStr() {
            return this.recvStr(0);
        }

        public final String recvStr(int flags) {
            byte[] msg = this.recv(flags);
            if (msg != null) {
                return new String(msg, CHARSET);
            }
            return null;
        }

        public boolean monitor(String addr, int events) {
            return this.base.monitor(addr, events);
        }

        private void mayRaise() {
            int errno = this.base.errno();
            if (errno != 0 && errno != 35) {
                throw new ZMQException(errno);
            }
        }
    }

    public static class Context
    implements Closeable {
        private final Ctx ctx;

        protected Context(int ioThreads) {
            this.ctx = zmq.ZMQ.init(ioThreads);
        }

        public int getIOThreads() {
            return this.ctx.get(1);
        }

        public boolean setIOThreads(int ioThreads) {
            return this.ctx.set(1, ioThreads);
        }

        public int getMaxSockets() {
            return this.ctx.get(2);
        }

        public boolean setMaxSockets(int maxSockets) {
            return this.ctx.set(2, maxSockets);
        }

        public boolean getBlocky() {
            return this.ctx.get(70) != 0;
        }

        public boolean setBlocky(boolean block) {
            return this.ctx.set(70, block ? 1 : 0);
        }

        public void term() {
            this.ctx.terminate();
        }

        public Socket socket(int type) {
            return new Socket(this, type);
        }

        public Poller poller() {
            return new Poller(this);
        }

        public Poller poller(int size2) {
            return new Poller(this, size2);
        }

        @Override
        public void close() {
            this.ctx.terminate();
        }
    }
}

