/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.objenesis.instantiator.jrockit;

import java.lang.reflect.Method;
import org.springframework.objenesis.ObjenesisException;
import org.springframework.objenesis.instantiator.ObjectInstantiator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRockitLegacyInstantiator<T>
implements ObjectInstantiator<T> {
    private static Method safeAllocObjectMethod = null;
    private final Class<T> type;

    private static void initialize() {
        if (safeAllocObjectMethod == null) {
            try {
                Class<?> memSystem = Class.forName("jrockit.vm.MemSystem");
                safeAllocObjectMethod = memSystem.getDeclaredMethod("safeAllocObject", Class.class);
                safeAllocObjectMethod.setAccessible(true);
            }
            catch (RuntimeException e2) {
                throw new ObjenesisException(e2);
            }
            catch (ClassNotFoundException e3) {
                throw new ObjenesisException(e3);
            }
            catch (NoSuchMethodException e4) {
                throw new ObjenesisException(e4);
            }
        }
    }

    public JRockitLegacyInstantiator(Class<T> type) {
        JRockitLegacyInstantiator.initialize();
        this.type = type;
    }

    @Override
    public T newInstance() {
        try {
            return this.type.cast(safeAllocObjectMethod.invoke(null, this.type));
        }
        catch (Exception e2) {
            throw new ObjenesisException(e2);
        }
    }
}

