/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import org.springframework.core.convert.ConversionException;
import org.springframework.core.env.AbstractPropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.util.ClassUtils;

public class PropertySourcesPropertyResolver
extends AbstractPropertyResolver {
    private final PropertySources propertySources;

    public PropertySourcesPropertyResolver(PropertySources propertySources) {
        this.propertySources = propertySources;
    }

    @Override
    public boolean containsProperty(String key) {
        if (this.propertySources != null) {
            for (PropertySource propertySource : this.propertySources) {
                if (!propertySource.containsProperty(key)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getProperty(String key) {
        return this.getProperty(key, String.class, true);
    }

    @Override
    public <T> T getProperty(String key, Class<T> targetValueType) {
        return this.getProperty(key, targetValueType, true);
    }

    @Override
    protected String getPropertyAsRawString(String key) {
        return this.getProperty(key, String.class, false);
    }

    protected <T> T getProperty(String key, Class<T> targetValueType, boolean resolveNestedPlaceholders) {
        boolean debugEnabled = this.logger.isDebugEnabled();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(String.format("getProperty(\"%s\", %s)", key, targetValueType.getSimpleName()));
        }
        if (this.propertySources != null) {
            for (PropertySource propertySource : this.propertySources) {
                Object value2;
                if (debugEnabled) {
                    this.logger.debug(String.format("Searching for key '%s' in [%s]", key, propertySource.getName()));
                }
                if ((value2 = propertySource.getProperty(key)) == null) continue;
                Class<?> valueType = value2.getClass();
                if (resolveNestedPlaceholders && value2 instanceof String) {
                    value2 = this.resolveNestedPlaceholders((String)value2);
                }
                if (debugEnabled) {
                    this.logger.debug(String.format("Found key '%s' in [%s] with type [%s] and value '%s'", key, propertySource.getName(), valueType.getSimpleName(), value2));
                }
                if (!this.conversionService.canConvert(valueType, targetValueType)) {
                    throw new IllegalArgumentException(String.format("Cannot convert value [%s] from source type [%s] to target type [%s]", value2, valueType.getSimpleName(), targetValueType.getSimpleName()));
                }
                return this.conversionService.convert(value2, targetValueType);
            }
        }
        if (debugEnabled) {
            this.logger.debug(String.format("Could not find key '%s' in any property source. Returning [null]", key));
        }
        return null;
    }

    @Override
    public <T> Class<T> getPropertyAsClass(String key, Class<T> targetValueType) {
        boolean debugEnabled = this.logger.isDebugEnabled();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(String.format("getPropertyAsClass(\"%s\", %s)", key, targetValueType.getSimpleName()));
        }
        if (this.propertySources != null) {
            for (PropertySource propertySource : this.propertySources) {
                Class<?> clazz;
                Object value2;
                if (debugEnabled) {
                    this.logger.debug(String.format("Searching for key '%s' in [%s]", key, propertySource.getName()));
                }
                if ((value2 = propertySource.getProperty(key)) == null) continue;
                if (debugEnabled) {
                    this.logger.debug(String.format("Found key '%s' in [%s] with value '%s'", key, propertySource.getName(), value2));
                }
                if (value2 instanceof String) {
                    try {
                        clazz = ClassUtils.forName((String)value2, null);
                    }
                    catch (Exception ex) {
                        throw new ClassConversionException((String)value2, targetValueType, ex);
                    }
                } else {
                    clazz = value2 instanceof Class ? (Class<?>)value2 : value2.getClass();
                }
                if (!targetValueType.isAssignableFrom(clazz)) {
                    throw new ClassConversionException(clazz, targetValueType);
                }
                Class<?> targetClass = clazz;
                return targetClass;
            }
        }
        if (debugEnabled) {
            this.logger.debug(String.format("Could not find key '%s' in any property source. Returning [null]", key));
        }
        return null;
    }

    private static class ClassConversionException
    extends ConversionException {
        public ClassConversionException(Class<?> actual, Class<?> expected) {
            super(String.format("Actual type %s is not assignable to expected type %s", actual.getName(), expected.getName()));
        }

        public ClassConversionException(String actual, Class<?> expected, Exception ex) {
            super(String.format("Could not find/load class %s during attempt to convert to %s", actual, expected.getName()), ex);
        }
    }
}

