/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import java.security.AccessControlException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.SpringProperties;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.ConfigurablePropertyResolver;
import org.springframework.core.env.MissingRequiredPropertiesException;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySourcesPropertyResolver;
import org.springframework.core.env.ReadOnlySystemAttributesMap;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractEnvironment
implements ConfigurableEnvironment {
    public static final String IGNORE_GETENV_PROPERTY_NAME = "spring.getenv.ignore";
    public static final String ACTIVE_PROFILES_PROPERTY_NAME = "spring.profiles.active";
    public static final String DEFAULT_PROFILES_PROPERTY_NAME = "spring.profiles.default";
    protected static final String RESERVED_DEFAULT_PROFILE_NAME = "default";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Set<String> activeProfiles = new LinkedHashSet<String>();
    private Set<String> defaultProfiles = new LinkedHashSet<String>(this.getReservedDefaultProfiles());
    private final MutablePropertySources propertySources = new MutablePropertySources(this.logger);
    private final ConfigurablePropertyResolver propertyResolver = new PropertySourcesPropertyResolver(this.propertySources);

    public AbstractEnvironment() {
        this.customizePropertySources(this.propertySources);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Initialized %s with PropertySources %s", this.getClass().getSimpleName(), this.propertySources));
        }
    }

    protected void customizePropertySources(MutablePropertySources propertySources) {
    }

    protected Set<String> getReservedDefaultProfiles() {
        return Collections.singleton(RESERVED_DEFAULT_PROFILE_NAME);
    }

    @Override
    public String[] getActiveProfiles() {
        return StringUtils.toStringArray(this.doGetActiveProfiles());
    }

    protected Set<String> doGetActiveProfiles() {
        String profiles;
        if (this.activeProfiles.isEmpty() && StringUtils.hasText(profiles = this.getProperty(ACTIVE_PROFILES_PROPERTY_NAME))) {
            this.setActiveProfiles(StringUtils.commaDelimitedListToStringArray(StringUtils.trimAllWhitespace(profiles)));
        }
        return this.activeProfiles;
    }

    @Override
    public void setActiveProfiles(String ... profiles) {
        Assert.notNull(profiles, "Profile array must not be null");
        this.activeProfiles.clear();
        for (String profile2 : profiles) {
            this.validateProfile(profile2);
            this.activeProfiles.add(profile2);
        }
    }

    @Override
    public void addActiveProfile(String profile2) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Activating profile '%s'", profile2));
        }
        this.validateProfile(profile2);
        this.doGetActiveProfiles();
        this.activeProfiles.add(profile2);
    }

    @Override
    public String[] getDefaultProfiles() {
        return StringUtils.toStringArray(this.doGetDefaultProfiles());
    }

    protected Set<String> doGetDefaultProfiles() {
        String profiles;
        if (this.defaultProfiles.equals(this.getReservedDefaultProfiles()) && StringUtils.hasText(profiles = this.getProperty(DEFAULT_PROFILES_PROPERTY_NAME))) {
            this.setDefaultProfiles(StringUtils.commaDelimitedListToStringArray(StringUtils.trimAllWhitespace(profiles)));
        }
        return this.defaultProfiles;
    }

    @Override
    public void setDefaultProfiles(String ... profiles) {
        Assert.notNull(profiles, "Profile array must not be null");
        this.defaultProfiles.clear();
        for (String profile2 : profiles) {
            this.validateProfile(profile2);
            this.defaultProfiles.add(profile2);
        }
    }

    @Override
    public boolean acceptsProfiles(String ... profiles) {
        Assert.notEmpty(profiles, "Must specify at least one profile");
        for (String profile2 : profiles) {
            if (!(profile2 != null && profile2.length() > 0 && profile2.charAt(0) == '!' ? !this.isProfileActive(profile2.substring(1)) : this.isProfileActive(profile2))) continue;
            return true;
        }
        return false;
    }

    protected boolean isProfileActive(String profile2) {
        this.validateProfile(profile2);
        return this.doGetActiveProfiles().contains(profile2) || this.doGetActiveProfiles().isEmpty() && this.doGetDefaultProfiles().contains(profile2);
    }

    protected void validateProfile(String profile2) {
        if (!StringUtils.hasText(profile2)) {
            throw new IllegalArgumentException("Invalid profile [" + profile2 + "]: must contain text");
        }
        if (profile2.charAt(0) == '!') {
            throw new IllegalArgumentException("Invalid profile [" + profile2 + "]: must not begin with ! operator");
        }
    }

    @Override
    public MutablePropertySources getPropertySources() {
        return this.propertySources;
    }

    @Override
    public Map<String, Object> getSystemEnvironment() {
        if (this.suppressGetenvAccess()) {
            return Collections.emptyMap();
        }
        try {
            return System.getenv();
        }
        catch (AccessControlException ex) {
            return new ReadOnlySystemAttributesMap(){

                @Override
                protected String getSystemAttribute(String attributeName) {
                    try {
                        return System.getenv(attributeName);
                    }
                    catch (AccessControlException ex) {
                        if (AbstractEnvironment.this.logger.isInfoEnabled()) {
                            AbstractEnvironment.this.logger.info(String.format("Caught AccessControlException when accessing system environment variable [%s]; its value will be returned [null]. Reason: %s", attributeName, ex.getMessage()));
                        }
                        return null;
                    }
                }
            };
        }
    }

    protected boolean suppressGetenvAccess() {
        return SpringProperties.getFlag(IGNORE_GETENV_PROPERTY_NAME);
    }

    @Override
    public Map<String, Object> getSystemProperties() {
        try {
            return System.getProperties();
        }
        catch (AccessControlException ex) {
            return new ReadOnlySystemAttributesMap(){

                @Override
                protected String getSystemAttribute(String attributeName) {
                    try {
                        return System.getProperty(attributeName);
                    }
                    catch (AccessControlException ex) {
                        if (AbstractEnvironment.this.logger.isInfoEnabled()) {
                            AbstractEnvironment.this.logger.info(String.format("Caught AccessControlException when accessing system property [%s]; its value will be returned [null]. Reason: %s", attributeName, ex.getMessage()));
                        }
                        return null;
                    }
                }
            };
        }
    }

    @Override
    public void merge(ConfigurableEnvironment parent2) {
        for (PropertySource<?> ps : parent2.getPropertySources()) {
            if (this.propertySources.contains(ps.getName())) continue;
            this.propertySources.addLast(ps);
        }
        for (String profile2 : parent2.getActiveProfiles()) {
            this.activeProfiles.add(profile2);
        }
        if (parent2.getDefaultProfiles().length > 0) {
            this.defaultProfiles.remove(RESERVED_DEFAULT_PROFILE_NAME);
            for (String profile2 : parent2.getDefaultProfiles()) {
                this.defaultProfiles.add(profile2);
            }
        }
    }

    @Override
    public ConfigurableConversionService getConversionService() {
        return this.propertyResolver.getConversionService();
    }

    @Override
    public void setConversionService(ConfigurableConversionService conversionService) {
        this.propertyResolver.setConversionService(conversionService);
    }

    @Override
    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.propertyResolver.setPlaceholderPrefix(placeholderPrefix);
    }

    @Override
    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.propertyResolver.setPlaceholderSuffix(placeholderSuffix);
    }

    @Override
    public void setValueSeparator(String valueSeparator) {
        this.propertyResolver.setValueSeparator(valueSeparator);
    }

    @Override
    public void setIgnoreUnresolvableNestedPlaceholders(boolean ignoreUnresolvableNestedPlaceholders) {
        this.propertyResolver.setIgnoreUnresolvableNestedPlaceholders(ignoreUnresolvableNestedPlaceholders);
    }

    @Override
    public void setRequiredProperties(String ... requiredProperties) {
        this.propertyResolver.setRequiredProperties(requiredProperties);
    }

    @Override
    public void validateRequiredProperties() throws MissingRequiredPropertiesException {
        this.propertyResolver.validateRequiredProperties();
    }

    @Override
    public boolean containsProperty(String key) {
        return this.propertyResolver.containsProperty(key);
    }

    @Override
    public String getProperty(String key) {
        return this.propertyResolver.getProperty(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.propertyResolver.getProperty(key, defaultValue);
    }

    @Override
    public <T> T getProperty(String key, Class<T> targetType) {
        return this.propertyResolver.getProperty(key, targetType);
    }

    @Override
    public <T> T getProperty(String key, Class<T> targetType, T defaultValue) {
        return this.propertyResolver.getProperty(key, targetType, defaultValue);
    }

    @Override
    public <T> Class<T> getPropertyAsClass(String key, Class<T> targetType) {
        return this.propertyResolver.getPropertyAsClass(key, targetType);
    }

    @Override
    public String getRequiredProperty(String key) throws IllegalStateException {
        return this.propertyResolver.getRequiredProperty(key);
    }

    @Override
    public <T> T getRequiredProperty(String key, Class<T> targetType) throws IllegalStateException {
        return this.propertyResolver.getRequiredProperty(key, targetType);
    }

    @Override
    public String resolvePlaceholders(String text2) {
        return this.propertyResolver.resolvePlaceholders(text2);
    }

    @Override
    public String resolveRequiredPlaceholders(String text2) throws IllegalArgumentException {
        return this.propertyResolver.resolveRequiredPlaceholders(text2);
    }

    public String toString() {
        return String.format("%s {activeProfiles=%s, defaultProfiles=%s, propertySources=%s}", this.getClass().getSimpleName(), this.activeProfiles, this.defaultProfiles, this.propertySources);
    }
}

