/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.core.OrderComparator;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.core.annotation.OrderUtils;

public class AnnotationAwareOrderComparator
extends OrderComparator {
    public static final AnnotationAwareOrderComparator INSTANCE = new AnnotationAwareOrderComparator();

    @Override
    protected Integer findOrder(Object obj2) {
        Integer order2 = super.findOrder(obj2);
        if (order2 != null) {
            return order2;
        }
        if (obj2 instanceof Class) {
            return OrderUtils.getOrder((Class)obj2);
        }
        if (obj2 instanceof Method) {
            Order ann = AnnotationUtils.findAnnotation((Method)obj2, Order.class);
            if (ann != null) {
                return ann.value();
            }
        } else if (obj2 instanceof AnnotatedElement) {
            Order ann = AnnotationUtils.getAnnotation((AnnotatedElement)obj2, Order.class);
            if (ann != null) {
                return ann.value();
            }
        } else if (obj2 != null) {
            return OrderUtils.getOrder(obj2.getClass());
        }
        return null;
    }

    @Override
    public Integer getPriority(Object obj2) {
        if (obj2 instanceof Class) {
            return OrderUtils.getPriority((Class)obj2);
        }
        if (obj2 != null) {
            return OrderUtils.getPriority(obj2.getClass());
        }
        return null;
    }

    public static void sort(List<?> list2) {
        if (list2.size() > 1) {
            Collections.sort(list2, INSTANCE);
        }
    }

    public static void sort(Object[] array) {
        if (array.length > 1) {
            Arrays.sort(array, INSTANCE);
        }
    }

    public static void sortIfNecessary(Object value2) {
        if (value2 instanceof Object[]) {
            AnnotationAwareOrderComparator.sort((Object[])value2);
        } else if (value2 instanceof List) {
            AnnotationAwareOrderComparator.sort((List)value2);
        }
    }
}

