/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.springframework.core.Ordered;
import org.springframework.core.PriorityOrdered;

public class OrderComparator
implements Comparator<Object> {
    public static final OrderComparator INSTANCE = new OrderComparator();

    public Comparator<Object> withSourceProvider(final OrderSourceProvider sourceProvider) {
        return new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return OrderComparator.this.doCompare(o1, o2, sourceProvider);
            }
        };
    }

    @Override
    public int compare(Object o1, Object o2) {
        return this.doCompare(o1, o2, null);
    }

    private int doCompare(Object o1, Object o2, OrderSourceProvider sourceProvider) {
        int i2;
        boolean p1 = o1 instanceof PriorityOrdered;
        boolean p2 = o2 instanceof PriorityOrdered;
        if (p1 && !p2) {
            return -1;
        }
        if (p2 && !p1) {
            return 1;
        }
        int i1 = this.getOrder(o1, sourceProvider);
        return i1 < (i2 = this.getOrder(o2, sourceProvider)) ? -1 : (i1 > i2 ? 1 : 0);
    }

    private int getOrder(Object obj2, OrderSourceProvider sourceProvider) {
        Integer order2 = null;
        if (sourceProvider != null) {
            order2 = this.findOrder(sourceProvider.getOrderSource(obj2));
        }
        return order2 != null ? order2.intValue() : this.getOrder(obj2);
    }

    protected int getOrder(Object obj2) {
        Integer order2 = this.findOrder(obj2);
        return order2 != null ? order2 : Integer.MAX_VALUE;
    }

    protected Integer findOrder(Object obj2) {
        return obj2 instanceof Ordered ? Integer.valueOf(((Ordered)obj2).getOrder()) : null;
    }

    public Integer getPriority(Object obj2) {
        return null;
    }

    public static void sort(List<?> list2) {
        if (list2.size() > 1) {
            Collections.sort(list2, INSTANCE);
        }
    }

    public static void sort(Object[] array) {
        if (array.length > 1) {
            Arrays.sort(array, INSTANCE);
        }
    }

    public static void sortIfNecessary(Object value2) {
        if (value2 instanceof Object[]) {
            OrderComparator.sort((Object[])value2);
        } else if (value2 instanceof List) {
            OrderComparator.sort((List)value2);
        }
    }

    public static interface OrderSourceProvider {
        public Object getOrderSource(Object var1);
    }
}

