/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.util.HashSet;
import java.util.Set;
import org.springframework.util.Assert;

public abstract class DecoratingClassLoader
extends ClassLoader {
    private final Set<String> excludedPackages = new HashSet<String>();
    private final Set<String> excludedClasses = new HashSet<String>();
    private final Object exclusionMonitor = new Object();

    public DecoratingClassLoader() {
    }

    public DecoratingClassLoader(ClassLoader parent2) {
        super(parent2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void excludePackage(String packageName) {
        Assert.notNull(packageName, "Package name must not be null");
        Object object = this.exclusionMonitor;
        synchronized (object) {
            this.excludedPackages.add(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void excludeClass(String className) {
        Assert.notNull(className, "Class name must not be null");
        Object object = this.exclusionMonitor;
        synchronized (object) {
            this.excludedClasses.add(className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isExcluded(String className) {
        Object object = this.exclusionMonitor;
        synchronized (object) {
            if (this.excludedClasses.contains(className)) {
                return true;
            }
            for (String packageName : this.excludedPackages) {
                if (!className.startsWith(packageName)) continue;
                return true;
            }
        }
        return false;
    }
}

