/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.util;

import org.springframework.asm.ClassVisitor;
import org.springframework.asm.Type;
import org.springframework.cglib.core.ClassEmitter;
import org.springframework.cglib.core.CodeEmitter;
import org.springframework.cglib.core.Constants;
import org.springframework.cglib.core.EmitUtils;
import org.springframework.cglib.core.Local;
import org.springframework.cglib.core.Signature;
import org.springframework.cglib.core.TypeUtils;

class ParallelSorterEmitter
extends ClassEmitter {
    private static final Type PARALLEL_SORTER = TypeUtils.parseType("org.springframework.cglib.util.ParallelSorter");
    private static final Signature CSTRUCT_OBJECT_ARRAY = TypeUtils.parseConstructor("Object[]");
    private static final Signature NEW_INSTANCE = new Signature("newInstance", PARALLEL_SORTER, new Type[]{Constants.TYPE_OBJECT_ARRAY});
    private static final Signature SWAP = TypeUtils.parseSignature("void swap(int, int)");

    public ParallelSorterEmitter(ClassVisitor v2, String className, Object[] arrays) {
        super(v2);
        this.begin_class(46, 1, className, PARALLEL_SORTER, null, "<generated>");
        EmitUtils.null_constructor(this);
        EmitUtils.factory_method(this, NEW_INSTANCE);
        this.generateConstructor(arrays);
        this.generateSwap(arrays);
        this.end_class();
    }

    private String getFieldName(int index2) {
        return "FIELD_" + index2;
    }

    private void generateConstructor(Object[] arrays) {
        CodeEmitter e2 = this.begin_method(1, CSTRUCT_OBJECT_ARRAY, null);
        e2.load_this();
        e2.super_invoke_constructor();
        e2.load_this();
        e2.load_arg(0);
        e2.super_putfield("a", Constants.TYPE_OBJECT_ARRAY);
        for (int i = 0; i < arrays.length; ++i) {
            Type type = Type.getType(arrays[i].getClass());
            this.declare_field(2, this.getFieldName(i), type, null);
            e2.load_this();
            e2.load_arg(0);
            e2.push(i);
            e2.aaload();
            e2.checkcast(type);
            e2.putfield(this.getFieldName(i));
        }
        e2.return_value();
        e2.end_method();
    }

    private void generateSwap(Object[] arrays) {
        CodeEmitter e2 = this.begin_method(1, SWAP, null);
        for (int i = 0; i < arrays.length; ++i) {
            Type type = Type.getType(arrays[i].getClass());
            Type component = TypeUtils.getComponentType(type);
            Local T = e2.make_local(type);
            e2.load_this();
            e2.getfield(this.getFieldName(i));
            e2.store_local(T);
            e2.load_local(T);
            e2.load_arg(0);
            e2.load_local(T);
            e2.load_arg(1);
            e2.array_load(component);
            e2.load_local(T);
            e2.load_arg(1);
            e2.load_local(T);
            e2.load_arg(0);
            e2.array_load(component);
            e2.array_store(component);
            e2.array_store(component);
        }
        e2.return_value();
        e2.end_method();
    }
}

