/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.transform.impl;

import org.springframework.asm.Type;
import org.springframework.cglib.core.CodeEmitter;
import org.springframework.cglib.core.Constants;
import org.springframework.cglib.core.Signature;
import org.springframework.cglib.core.TypeUtils;
import org.springframework.cglib.transform.ClassEmitterTransformer;

public class AccessFieldTransformer
extends ClassEmitterTransformer {
    private Callback callback;

    public AccessFieldTransformer(Callback callback) {
        this.callback = callback;
    }

    public void declare_field(int access, String name, Type type, Object value2) {
        super.declare_field(access, name, type, value2);
        String property = TypeUtils.upperFirst(this.callback.getPropertyName(this.getClassType(), name));
        if (property != null) {
            CodeEmitter e2 = this.begin_method(1, new Signature("get" + property, type, Constants.TYPES_EMPTY), null);
            e2.load_this();
            e2.getfield(name);
            e2.return_value();
            e2.end_method();
            e2 = this.begin_method(1, new Signature("set" + property, Type.VOID_TYPE, new Type[]{type}), null);
            e2.load_this();
            e2.load_arg(0);
            e2.putfield(name);
            e2.return_value();
            e2.end_method();
        }
    }

    public static interface Callback {
        public String getPropertyName(Type var1, String var2);
    }
}

