/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.proxy;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.springframework.asm.Label;
import org.springframework.asm.Type;
import org.springframework.cglib.core.ClassEmitter;
import org.springframework.cglib.core.CodeEmitter;
import org.springframework.cglib.core.Constants;
import org.springframework.cglib.core.MethodInfo;
import org.springframework.cglib.core.Signature;
import org.springframework.cglib.core.TypeUtils;
import org.springframework.cglib.proxy.CallbackGenerator;

class LazyLoaderGenerator
implements CallbackGenerator {
    public static final LazyLoaderGenerator INSTANCE = new LazyLoaderGenerator();
    private static final Signature LOAD_OBJECT = TypeUtils.parseSignature("Object loadObject()");
    private static final Type LAZY_LOADER = TypeUtils.parseType("org.springframework.cglib.proxy.LazyLoader");

    LazyLoaderGenerator() {
    }

    public void generate(ClassEmitter ce, CallbackGenerator.Context context, List methods) {
        CodeEmitter e2;
        HashSet<Integer> indexes = new HashSet<Integer>();
        Iterator it = methods.iterator();
        while (it.hasNext()) {
            MethodInfo method = (MethodInfo)it.next();
            if (TypeUtils.isProtected(method.getModifiers())) continue;
            int index2 = context.getIndex(method);
            indexes.add(new Integer(index2));
            e2 = context.beginMethod(ce, method);
            e2.load_this();
            e2.dup();
            e2.invoke_virtual_this(this.loadMethod(index2));
            e2.checkcast(method.getClassInfo().getType());
            e2.load_args();
            e2.invoke(method);
            e2.return_value();
            e2.end_method();
        }
        it = indexes.iterator();
        while (it.hasNext()) {
            int index3 = (Integer)it.next();
            String delegate = "CGLIB$LAZY_LOADER_" + index3;
            ce.declare_field(2, delegate, Constants.TYPE_OBJECT, null);
            e2 = ce.begin_method(50, this.loadMethod(index3), null);
            e2.load_this();
            e2.getfield(delegate);
            e2.dup();
            Label end2 = e2.make_label();
            e2.ifnonnull(end2);
            e2.pop();
            e2.load_this();
            context.emitCallback(e2, index3);
            e2.invoke_interface(LAZY_LOADER, LOAD_OBJECT);
            e2.dup_x1();
            e2.putfield(delegate);
            e2.mark(end2);
            e2.return_value();
            e2.end_method();
        }
    }

    private Signature loadMethod(int index2) {
        return new Signature("CGLIB$LOAD_PRIVATE_" + index2, Constants.TYPE_OBJECT, Constants.TYPES_EMPTY);
    }

    public void generateStatic(CodeEmitter e2, CallbackGenerator.Context context, List methods) {
    }
}

