/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons;

import java.util.Stack;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.signature.SignatureVisitor;

public class SignatureRemapper
extends SignatureVisitor {
    private final SignatureVisitor v;
    private final Remapper remapper;
    private Stack classNames = new Stack();

    public SignatureRemapper(SignatureVisitor signatureVisitor, Remapper remapper) {
        this(327680, signatureVisitor, remapper);
    }

    protected SignatureRemapper(int n, SignatureVisitor signatureVisitor, Remapper remapper) {
        super(n);
        this.v = signatureVisitor;
        this.remapper = remapper;
    }

    public void visitClassType(String string2) {
        this.classNames.push(string2);
        this.v.visitClassType(this.remapper.mapType(string2));
    }

    public void visitInnerClassType(String string2) {
        String string3 = (String)this.classNames.pop();
        String string4 = string3 + '$' + string2;
        this.classNames.push(string4);
        String string5 = this.remapper.mapType(string3) + '$';
        String string6 = this.remapper.mapType(string4);
        int n = string6.startsWith(string5) ? string5.length() : string6.lastIndexOf(36) + 1;
        this.v.visitInnerClassType(string6.substring(n));
    }

    public void visitFormalTypeParameter(String string2) {
        this.v.visitFormalTypeParameter(string2);
    }

    public void visitTypeVariable(String string2) {
        this.v.visitTypeVariable(string2);
    }

    public SignatureVisitor visitArrayType() {
        this.v.visitArrayType();
        return this;
    }

    public void visitBaseType(char c2) {
        this.v.visitBaseType(c2);
    }

    public SignatureVisitor visitClassBound() {
        this.v.visitClassBound();
        return this;
    }

    public SignatureVisitor visitExceptionType() {
        this.v.visitExceptionType();
        return this;
    }

    public SignatureVisitor visitInterface() {
        this.v.visitInterface();
        return this;
    }

    public SignatureVisitor visitInterfaceBound() {
        this.v.visitInterfaceBound();
        return this;
    }

    public SignatureVisitor visitParameterType() {
        this.v.visitParameterType();
        return this;
    }

    public SignatureVisitor visitReturnType() {
        this.v.visitReturnType();
        return this;
    }

    public SignatureVisitor visitSuperclass() {
        this.v.visitSuperclass();
        return this;
    }

    public void visitTypeArgument() {
        this.v.visitTypeArgument();
    }

    public SignatureVisitor visitTypeArgument(char c2) {
        this.v.visitTypeArgument(c2);
        return this;
    }

    public void visitEnd() {
        this.v.visitEnd();
        this.classNames.pop();
    }
}

