/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mesos.state;

import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.apache.mesos.state.State;
import org.apache.mesos.state.Variable;

public class InMemoryState
implements State {
    private final ConcurrentMap<String, Entry> entries = new ConcurrentHashMap<String, Entry>();

    @Override
    public Future<Variable> fetch(String name) {
        Entry entry = (Entry)this.entries.get(name);
        if (entry == null) {
            entry = new Entry();
            entry.name = name;
            entry.uuid = UUID.randomUUID();
            entry.value = new byte[0];
            if (this.entries.putIfAbsent(name, entry) != null) {
                return this.fetch(name);
            }
        }
        assert (entry != null);
        return InMemoryState.futureFrom(new InMemoryVariable(entry));
    }

    @Override
    public Future<Variable> store(Variable v2) {
        InMemoryVariable variable = (InMemoryVariable)v2;
        Entry entry = new Entry();
        entry.name = variable.entry.name;
        entry.uuid = UUID.randomUUID();
        entry.value = variable.value;
        if (this.entries.replace(entry.name, variable.entry, entry)) {
            return InMemoryState.futureFrom(new InMemoryVariable(entry));
        }
        return InMemoryState.futureFrom(null);
    }

    @Override
    public Future<Boolean> expunge(Variable v2) {
        InMemoryVariable variable = (InMemoryVariable)v2;
        return InMemoryState.futureFrom(this.entries.remove(variable.entry.name, variable.entry));
    }

    @Override
    public Future<Iterator<String>> names() {
        return InMemoryState.futureFrom(this.entries.keySet().iterator());
    }

    private static <T> Future<T> futureFrom(final T t) {
        FutureTask future2 = new FutureTask(new Callable<T>(){

            @Override
            public T call() {
                return t;
            }
        });
        future2.run();
        return future2;
    }

    private static class Entry {
        String name;
        UUID uuid;
        byte[] value;

        private Entry() {
        }

        public boolean equals(Object that) {
            if (that instanceof Entry) {
                return this.uuid.equals(((Entry)that).uuid);
            }
            return false;
        }

        public int hashCode() {
            return this.uuid.hashCode();
        }
    }

    private static class InMemoryVariable
    extends Variable {
        final Entry entry;
        final byte[] value;

        private InMemoryVariable(Entry entry) {
            this(entry, (byte[])null);
        }

        private InMemoryVariable(Entry entry, byte[] value2) {
            this.entry = entry;
            this.value = value2;
        }

        @Override
        public byte[] value() {
            if (this.value != null) {
                return this.value;
            }
            return this.entry.value;
        }

        @Override
        public Variable mutate(byte[] value2) {
            return new InMemoryVariable(this.entry, value2);
        }
    }
}

