/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mesos.protobuf;

final class Utf8 {
    public static final int COMPLETE = 0;
    public static final int MALFORMED = -1;

    private Utf8() {
    }

    public static boolean isValidUtf8(byte[] bytes) {
        return Utf8.isValidUtf8(bytes, 0, bytes.length);
    }

    public static boolean isValidUtf8(byte[] bytes, int index2, int limit2) {
        return Utf8.partialIsValidUtf8(bytes, index2, limit2) == 0;
    }

    public static int partialIsValidUtf8(int state2, byte[] bytes, int index2, int limit2) {
        if (state2 != 0) {
            if (index2 >= limit2) {
                return state2;
            }
            byte byte1 = (byte)state2;
            if (byte1 < -32) {
                if (byte1 < -62 || bytes[index2++] > -65) {
                    return -1;
                }
            } else if (byte1 < -16) {
                byte byte2 = (byte)(~(state2 >> 8));
                if (byte2 == 0) {
                    byte2 = bytes[index2++];
                    if (index2 >= limit2) {
                        return Utf8.incompleteStateFor(byte1, byte2);
                    }
                }
                if (byte2 > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96 || bytes[index2++] > -65) {
                    return -1;
                }
            } else {
                byte byte2 = (byte)(~(state2 >> 8));
                byte byte3 = 0;
                if (byte2 == 0) {
                    byte2 = bytes[index2++];
                    if (index2 >= limit2) {
                        return Utf8.incompleteStateFor(byte1, byte2);
                    }
                } else {
                    byte3 = (byte)(state2 >> 16);
                }
                if (byte3 == 0) {
                    byte3 = bytes[index2++];
                    if (index2 >= limit2) {
                        return Utf8.incompleteStateFor(byte1, (int)byte2, (int)byte3);
                    }
                }
                if (byte2 > -65 || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || byte3 > -65 || bytes[index2++] > -65) {
                    return -1;
                }
            }
        }
        return Utf8.partialIsValidUtf8(bytes, index2, limit2);
    }

    public static int partialIsValidUtf8(byte[] bytes, int index2, int limit2) {
        while (index2 < limit2 && bytes[index2] >= 0) {
            ++index2;
        }
        return index2 >= limit2 ? 0 : Utf8.partialIsValidUtf8NonAscii(bytes, index2, limit2);
    }

    private static int partialIsValidUtf8NonAscii(byte[] bytes, int index2, int limit2) {
        while (true) {
            byte byte2;
            byte byte1;
            if (index2 >= limit2) {
                return 0;
            }
            if ((byte1 = bytes[index2++]) >= 0) continue;
            if (byte1 < -32) {
                if (index2 >= limit2) {
                    return byte1;
                }
                if (byte1 >= -62 && bytes[index2++] <= -65) continue;
                return -1;
            }
            if (byte1 < -16) {
                if (index2 >= limit2 - 1) {
                    return Utf8.incompleteStateFor(bytes, index2, limit2);
                }
                if (!((byte2 = bytes[index2++]) > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96) && bytes[index2++] <= -65) continue;
                return -1;
            }
            if (index2 >= limit2 - 2) {
                return Utf8.incompleteStateFor(bytes, index2, limit2);
            }
            if ((byte2 = bytes[index2++]) > -65 || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || bytes[index2++] > -65 || bytes[index2++] > -65) break;
        }
        return -1;
    }

    private static int incompleteStateFor(int byte1) {
        return byte1 > -12 ? -1 : byte1;
    }

    private static int incompleteStateFor(int byte1, int byte2) {
        return byte1 > -12 || byte2 > -65 ? -1 : byte1 ^ byte2 << 8;
    }

    private static int incompleteStateFor(int byte1, int byte2, int byte3) {
        return byte1 > -12 || byte2 > -65 || byte3 > -65 ? -1 : byte1 ^ byte2 << 8 ^ byte3 << 16;
    }

    private static int incompleteStateFor(byte[] bytes, int index2, int limit2) {
        byte byte1 = bytes[index2 - 1];
        switch (limit2 - index2) {
            case 0: {
                return Utf8.incompleteStateFor(byte1);
            }
            case 1: {
                return Utf8.incompleteStateFor(byte1, bytes[index2]);
            }
            case 2: {
                return Utf8.incompleteStateFor(byte1, (int)bytes[index2], (int)bytes[index2 + 1]);
            }
        }
        throw new AssertionError();
    }
}

