/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mesos.protobuf;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.mesos.protobuf.ByteString;
import org.apache.mesos.protobuf.Descriptors;
import org.apache.mesos.protobuf.ExtensionRegistry;
import org.apache.mesos.protobuf.Message;
import org.apache.mesos.protobuf.MessageOrBuilder;
import org.apache.mesos.protobuf.UnknownFieldSet;
import org.apache.mesos.protobuf.WireFormat;

public final class TextFormat {
    private static final Printer DEFAULT_PRINTER = new Printer();
    private static final Printer SINGLE_LINE_PRINTER = Printer.access$100(new Printer(), true);
    private static final Printer UNICODE_PRINTER = Printer.access$200(new Printer(), false);
    private static final int BUFFER_SIZE = 4096;

    private TextFormat() {
    }

    public static void print(MessageOrBuilder message, Appendable output) throws IOException {
        TextFormat.DEFAULT_PRINTER.print(message, new TextGenerator(output));
    }

    public static void print(UnknownFieldSet fields, Appendable output) throws IOException {
        TextFormat.DEFAULT_PRINTER.printUnknownFields(fields, new TextGenerator(output));
    }

    public static String shortDebugString(MessageOrBuilder message) {
        try {
            StringBuilder sb = new StringBuilder();
            TextFormat.SINGLE_LINE_PRINTER.print(message, new TextGenerator(sb));
            return sb.toString().trim();
        }
        catch (IOException e2) {
            throw new IllegalStateException(e2);
        }
    }

    public static String shortDebugString(UnknownFieldSet fields) {
        try {
            StringBuilder sb = new StringBuilder();
            TextFormat.SINGLE_LINE_PRINTER.printUnknownFields(fields, new TextGenerator(sb));
            return sb.toString().trim();
        }
        catch (IOException e2) {
            throw new IllegalStateException(e2);
        }
    }

    public static String printToString(MessageOrBuilder message) {
        try {
            StringBuilder text2 = new StringBuilder();
            TextFormat.print(message, (Appendable)text2);
            return text2.toString();
        }
        catch (IOException e2) {
            throw new IllegalStateException(e2);
        }
    }

    public static String printToString(UnknownFieldSet fields) {
        try {
            StringBuilder text2 = new StringBuilder();
            TextFormat.print(fields, (Appendable)text2);
            return text2.toString();
        }
        catch (IOException e2) {
            throw new IllegalStateException(e2);
        }
    }

    public static String printToUnicodeString(MessageOrBuilder message) {
        try {
            StringBuilder text2 = new StringBuilder();
            TextFormat.UNICODE_PRINTER.print(message, new TextGenerator(text2));
            return text2.toString();
        }
        catch (IOException e2) {
            throw new IllegalStateException(e2);
        }
    }

    public static String printToUnicodeString(UnknownFieldSet fields) {
        try {
            StringBuilder text2 = new StringBuilder();
            TextFormat.UNICODE_PRINTER.printUnknownFields(fields, new TextGenerator(text2));
            return text2.toString();
        }
        catch (IOException e2) {
            throw new IllegalStateException(e2);
        }
    }

    public static void printField(Descriptors.FieldDescriptor field, Object value2, Appendable output) throws IOException {
        TextFormat.DEFAULT_PRINTER.printField(field, value2, new TextGenerator(output));
    }

    public static String printFieldToString(Descriptors.FieldDescriptor field, Object value2) {
        try {
            StringBuilder text2 = new StringBuilder();
            TextFormat.printField(field, value2, text2);
            return text2.toString();
        }
        catch (IOException e2) {
            throw new IllegalStateException(e2);
        }
    }

    public static void printFieldValue(Descriptors.FieldDescriptor field, Object value2, Appendable output) throws IOException {
        TextFormat.DEFAULT_PRINTER.printFieldValue(field, value2, new TextGenerator(output));
    }

    public static void printUnknownFieldValue(int tag, Object value2, Appendable output) throws IOException {
        TextFormat.printUnknownFieldValue(tag, value2, new TextGenerator(output));
    }

    private static void printUnknownFieldValue(int tag, Object value2, TextGenerator generator) throws IOException {
        switch (WireFormat.getTagWireType(tag)) {
            case 0: {
                generator.print(TextFormat.unsignedToString((Long)value2));
                break;
            }
            case 5: {
                generator.print(String.format((Locale)null, "0x%08x", (Integer)value2));
                break;
            }
            case 1: {
                generator.print(String.format((Locale)null, "0x%016x", (Long)value2));
                break;
            }
            case 2: {
                generator.print("\"");
                generator.print(TextFormat.escapeBytes((ByteString)value2));
                generator.print("\"");
                break;
            }
            case 3: {
                TextFormat.DEFAULT_PRINTER.printUnknownFields((UnknownFieldSet)value2, generator);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad tag: " + tag);
            }
        }
    }

    private static String unsignedToString(int value2) {
        if (value2 >= 0) {
            return Integer.toString(value2);
        }
        return Long.toString((long)value2 & 0xFFFFFFFFL);
    }

    private static String unsignedToString(long value2) {
        if (value2 >= 0L) {
            return Long.toString(value2);
        }
        return BigInteger.valueOf(value2 & Long.MAX_VALUE).setBit(63).toString();
    }

    public static void merge(Readable input, Message.Builder builder) throws IOException {
        TextFormat.merge(input, ExtensionRegistry.getEmptyRegistry(), builder);
    }

    public static void merge(CharSequence input, Message.Builder builder) throws ParseException {
        TextFormat.merge(input, ExtensionRegistry.getEmptyRegistry(), builder);
    }

    public static void merge(Readable input, ExtensionRegistry extensionRegistry, Message.Builder builder) throws IOException {
        TextFormat.merge(TextFormat.toStringBuilder(input), extensionRegistry, builder);
    }

    private static StringBuilder toStringBuilder(Readable input) throws IOException {
        int n;
        StringBuilder text2 = new StringBuilder();
        CharBuffer buffer2 = CharBuffer.allocate(4096);
        while ((n = input.read(buffer2)) != -1) {
            buffer2.flip();
            text2.append(buffer2, 0, n);
        }
        return text2;
    }

    public static void merge(CharSequence input, ExtensionRegistry extensionRegistry, Message.Builder builder) throws ParseException {
        Tokenizer tokenizer = new Tokenizer(input);
        while (!tokenizer.atEnd()) {
            TextFormat.mergeField(tokenizer, extensionRegistry, builder);
        }
    }

    private static void mergeField(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, Message.Builder builder) throws ParseException {
        Descriptors.FieldDescriptor field;
        CharSequence name;
        Descriptors.Descriptor type = builder.getDescriptorForType();
        ExtensionRegistry.ExtensionInfo extension2 = null;
        if (tokenizer.tryConsume("[")) {
            name = new StringBuilder(tokenizer.consumeIdentifier());
            while (tokenizer.tryConsume(".")) {
                ((StringBuilder)name).append('.');
                ((StringBuilder)name).append(tokenizer.consumeIdentifier());
            }
            extension2 = extensionRegistry.findExtensionByName(((StringBuilder)name).toString());
            if (extension2 == null) {
                throw tokenizer.parseExceptionPreviousToken("Extension \"" + name + "\" not found in the ExtensionRegistry.");
            }
            if (extension2.descriptor.getContainingType() != type) {
                throw tokenizer.parseExceptionPreviousToken("Extension \"" + name + "\" does not extend message type \"" + type.getFullName() + "\".");
            }
            tokenizer.consume("]");
            field = extension2.descriptor;
        } else {
            String lowerName;
            name = tokenizer.consumeIdentifier();
            field = type.findFieldByName((String)name);
            if (field == null && (field = type.findFieldByName(lowerName = ((String)name).toLowerCase(Locale.US))) != null && field.getType() != Descriptors.FieldDescriptor.Type.GROUP) {
                field = null;
            }
            if (field != null && field.getType() == Descriptors.FieldDescriptor.Type.GROUP && !field.getMessageType().getName().equals(name)) {
                field = null;
            }
            if (field == null) {
                throw tokenizer.parseExceptionPreviousToken("Message type \"" + type.getFullName() + "\" has no field named \"" + (String)name + "\".");
            }
        }
        Object value2 = null;
        if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            String endToken;
            tokenizer.tryConsume(":");
            if (tokenizer.tryConsume("<")) {
                endToken = ">";
            } else {
                tokenizer.consume("{");
                endToken = "}";
            }
            Message.Builder subBuilder = extension2 == null ? builder.newBuilderForField(field) : extension2.defaultInstance.newBuilderForType();
            while (!tokenizer.tryConsume(endToken)) {
                if (tokenizer.atEnd()) {
                    throw tokenizer.parseException("Expected \"" + endToken + "\".");
                }
                TextFormat.mergeField(tokenizer, extensionRegistry, subBuilder);
            }
            value2 = subBuilder.buildPartial();
        } else {
            tokenizer.consume(":");
            switch (field.getType()) {
                case INT32: 
                case SINT32: 
                case SFIXED32: {
                    value2 = tokenizer.consumeInt32();
                    break;
                }
                case INT64: 
                case SINT64: 
                case SFIXED64: {
                    value2 = tokenizer.consumeInt64();
                    break;
                }
                case UINT32: 
                case FIXED32: {
                    value2 = tokenizer.consumeUInt32();
                    break;
                }
                case UINT64: 
                case FIXED64: {
                    value2 = tokenizer.consumeUInt64();
                    break;
                }
                case FLOAT: {
                    value2 = Float.valueOf(tokenizer.consumeFloat());
                    break;
                }
                case DOUBLE: {
                    value2 = tokenizer.consumeDouble();
                    break;
                }
                case BOOL: {
                    value2 = tokenizer.consumeBoolean();
                    break;
                }
                case STRING: {
                    value2 = tokenizer.consumeString();
                    break;
                }
                case BYTES: {
                    value2 = tokenizer.consumeByteString();
                    break;
                }
                case ENUM: {
                    Descriptors.EnumDescriptor enumType = field.getEnumType();
                    if (tokenizer.lookingAtInteger()) {
                        int number = tokenizer.consumeInt32();
                        value2 = enumType.findValueByNumber(number);
                        if (value2 != null) break;
                        throw tokenizer.parseExceptionPreviousToken("Enum type \"" + enumType.getFullName() + "\" has no value with number " + number + '.');
                    }
                    String id2 = tokenizer.consumeIdentifier();
                    value2 = enumType.findValueByName(id2);
                    if (value2 != null) break;
                    throw tokenizer.parseExceptionPreviousToken("Enum type \"" + enumType.getFullName() + "\" has no value named \"" + id2 + "\".");
                }
                case MESSAGE: 
                case GROUP: {
                    throw new RuntimeException("Can't get here.");
                }
            }
        }
        if (field.isRepeated()) {
            builder.addRepeatedField(field, value2);
        } else {
            builder.setField(field, value2);
        }
    }

    static String escapeBytes(ByteString input) {
        StringBuilder builder = new StringBuilder(input.size());
        block12: for (int i = 0; i < input.size(); ++i) {
            byte b = input.byteAt(i);
            switch (b) {
                case 7: {
                    builder.append("\\a");
                    continue block12;
                }
                case 8: {
                    builder.append("\\b");
                    continue block12;
                }
                case 12: {
                    builder.append("\\f");
                    continue block12;
                }
                case 10: {
                    builder.append("\\n");
                    continue block12;
                }
                case 13: {
                    builder.append("\\r");
                    continue block12;
                }
                case 9: {
                    builder.append("\\t");
                    continue block12;
                }
                case 11: {
                    builder.append("\\v");
                    continue block12;
                }
                case 92: {
                    builder.append("\\\\");
                    continue block12;
                }
                case 39: {
                    builder.append("\\'");
                    continue block12;
                }
                case 34: {
                    builder.append("\\\"");
                    continue block12;
                }
                default: {
                    if (b >= 32) {
                        builder.append((char)b);
                        continue block12;
                    }
                    builder.append('\\');
                    builder.append((char)(48 + (b >>> 6 & 3)));
                    builder.append((char)(48 + (b >>> 3 & 7)));
                    builder.append((char)(48 + (b & 7)));
                }
            }
        }
        return builder.toString();
    }

    static ByteString unescapeBytes(CharSequence charString) throws InvalidEscapeSequenceException {
        ByteString input = ByteString.copyFromUtf8(charString.toString());
        byte[] result2 = new byte[input.size()];
        int pos = 0;
        for (int i = 0; i < input.size(); ++i) {
            byte c2 = input.byteAt(i);
            if (c2 == 92) {
                if (i + 1 < input.size()) {
                    int code;
                    if (TextFormat.isOctal(c2 = input.byteAt(++i))) {
                        code = TextFormat.digitValue(c2);
                        if (i + 1 < input.size() && TextFormat.isOctal(input.byteAt(i + 1))) {
                            code = code * 8 + TextFormat.digitValue(input.byteAt(++i));
                        }
                        if (i + 1 < input.size() && TextFormat.isOctal(input.byteAt(i + 1))) {
                            code = code * 8 + TextFormat.digitValue(input.byteAt(++i));
                        }
                        result2[pos++] = (byte)code;
                        continue;
                    }
                    switch (c2) {
                        case 97: {
                            result2[pos++] = 7;
                            break;
                        }
                        case 98: {
                            result2[pos++] = 8;
                            break;
                        }
                        case 102: {
                            result2[pos++] = 12;
                            break;
                        }
                        case 110: {
                            result2[pos++] = 10;
                            break;
                        }
                        case 114: {
                            result2[pos++] = 13;
                            break;
                        }
                        case 116: {
                            result2[pos++] = 9;
                            break;
                        }
                        case 118: {
                            result2[pos++] = 11;
                            break;
                        }
                        case 92: {
                            result2[pos++] = 92;
                            break;
                        }
                        case 39: {
                            result2[pos++] = 39;
                            break;
                        }
                        case 34: {
                            result2[pos++] = 34;
                            break;
                        }
                        case 120: {
                            code = 0;
                            if (i + 1 >= input.size() || !TextFormat.isHex(input.byteAt(i + 1))) {
                                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\x' with no digits");
                            }
                            code = TextFormat.digitValue(input.byteAt(++i));
                            if (i + 1 < input.size() && TextFormat.isHex(input.byteAt(i + 1))) {
                                code = code * 16 + TextFormat.digitValue(input.byteAt(++i));
                            }
                            result2[pos++] = (byte)code;
                            break;
                        }
                        default: {
                            throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\" + (char)c2 + '\'');
                        }
                    }
                    continue;
                }
                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\' at end of string.");
            }
            result2[pos++] = c2;
        }
        return ByteString.copyFrom(result2, 0, pos);
    }

    static String escapeText(String input) {
        return TextFormat.escapeBytes(ByteString.copyFromUtf8(input));
    }

    static String unescapeText(String input) throws InvalidEscapeSequenceException {
        return TextFormat.unescapeBytes(input).toStringUtf8();
    }

    private static boolean isOctal(byte c2) {
        return 48 <= c2 && c2 <= 55;
    }

    private static boolean isHex(byte c2) {
        return 48 <= c2 && c2 <= 57 || 97 <= c2 && c2 <= 102 || 65 <= c2 && c2 <= 70;
    }

    private static int digitValue(byte c2) {
        if (48 <= c2 && c2 <= 57) {
            return c2 - 48;
        }
        if (97 <= c2 && c2 <= 122) {
            return c2 - 97 + 10;
        }
        return c2 - 65 + 10;
    }

    static int parseInt32(String text2) throws NumberFormatException {
        return (int)TextFormat.parseInteger(text2, true, false);
    }

    static int parseUInt32(String text2) throws NumberFormatException {
        return (int)TextFormat.parseInteger(text2, false, false);
    }

    static long parseInt64(String text2) throws NumberFormatException {
        return TextFormat.parseInteger(text2, true, true);
    }

    static long parseUInt64(String text2) throws NumberFormatException {
        return TextFormat.parseInteger(text2, false, true);
    }

    private static long parseInteger(String text2, boolean isSigned, boolean isLong) throws NumberFormatException {
        int pos = 0;
        boolean negative = false;
        if (text2.startsWith("-", pos)) {
            if (!isSigned) {
                throw new NumberFormatException("Number must be positive: " + text2);
            }
            ++pos;
            negative = true;
        }
        int radix = 10;
        if (text2.startsWith("0x", pos)) {
            pos += 2;
            radix = 16;
        } else if (text2.startsWith("0", pos)) {
            radix = 8;
        }
        String numberText = text2.substring(pos);
        long result2 = 0L;
        if (numberText.length() < 16) {
            result2 = Long.parseLong(numberText, radix);
            if (negative) {
                result2 = -result2;
            }
            if (!isLong) {
                if (isSigned) {
                    if (result2 > Integer.MAX_VALUE || result2 < Integer.MIN_VALUE) {
                        throw new NumberFormatException("Number out of range for 32-bit signed integer: " + text2);
                    }
                } else if (result2 >= 0x100000000L || result2 < 0L) {
                    throw new NumberFormatException("Number out of range for 32-bit unsigned integer: " + text2);
                }
            }
        } else {
            BigInteger bigValue = new BigInteger(numberText, radix);
            if (negative) {
                bigValue = bigValue.negate();
            }
            if (!isLong) {
                if (isSigned) {
                    if (bigValue.bitLength() > 31) {
                        throw new NumberFormatException("Number out of range for 32-bit signed integer: " + text2);
                    }
                } else if (bigValue.bitLength() > 32) {
                    throw new NumberFormatException("Number out of range for 32-bit unsigned integer: " + text2);
                }
            } else if (isSigned) {
                if (bigValue.bitLength() > 63) {
                    throw new NumberFormatException("Number out of range for 64-bit signed integer: " + text2);
                }
            } else if (bigValue.bitLength() > 64) {
                throw new NumberFormatException("Number out of range for 64-bit unsigned integer: " + text2);
            }
            result2 = bigValue.longValue();
        }
        return result2;
    }

    static class InvalidEscapeSequenceException
    extends IOException {
        private static final long serialVersionUID = -8164033650142593304L;

        InvalidEscapeSequenceException(String description) {
            super(description);
        }
    }

    public static class ParseException
    extends IOException {
        private static final long serialVersionUID = 3196188060225107702L;
        private final int line;
        private final int column;

        public ParseException(String message) {
            this(-1, -1, message);
        }

        public ParseException(int line, int column, String message) {
            super(Integer.toString(line) + ":" + column + ": " + message);
            this.line = line;
            this.column = column;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Tokenizer {
        private final CharSequence text;
        private final Matcher matcher;
        private String currentToken;
        private int pos = 0;
        private int line = 0;
        private int column = 0;
        private int previousLine = 0;
        private int previousColumn = 0;
        private static final Pattern WHITESPACE = Pattern.compile("(\\s|(#.*$))++", 8);
        private static final Pattern TOKEN = Pattern.compile("[a-zA-Z_][0-9a-zA-Z_+-]*+|[.]?[0-9+-][0-9a-zA-Z_.+-]*+|\"([^\"\n\\\\]|\\\\.)*+(\"|\\\\?$)|'([^'\n\\\\]|\\\\.)*+('|\\\\?$)", 8);
        private static final Pattern DOUBLE_INFINITY = Pattern.compile("-?inf(inity)?", 2);
        private static final Pattern FLOAT_INFINITY = Pattern.compile("-?inf(inity)?f?", 2);
        private static final Pattern FLOAT_NAN = Pattern.compile("nanf?", 2);

        private Tokenizer(CharSequence text2) {
            this.text = text2;
            this.matcher = WHITESPACE.matcher(text2);
            this.skipWhitespace();
            this.nextToken();
        }

        public boolean atEnd() {
            return this.currentToken.length() == 0;
        }

        public void nextToken() {
            this.previousLine = this.line;
            this.previousColumn = this.column;
            while (this.pos < this.matcher.regionStart()) {
                if (this.text.charAt(this.pos) == '\n') {
                    ++this.line;
                    this.column = 0;
                } else {
                    ++this.column;
                }
                ++this.pos;
            }
            if (this.matcher.regionStart() == this.matcher.regionEnd()) {
                this.currentToken = "";
            } else {
                this.matcher.usePattern(TOKEN);
                if (this.matcher.lookingAt()) {
                    this.currentToken = this.matcher.group();
                    this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
                } else {
                    this.currentToken = String.valueOf(this.text.charAt(this.pos));
                    this.matcher.region(this.pos + 1, this.matcher.regionEnd());
                }
                this.skipWhitespace();
            }
        }

        private void skipWhitespace() {
            this.matcher.usePattern(WHITESPACE);
            if (this.matcher.lookingAt()) {
                this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
            }
        }

        public boolean tryConsume(String token) {
            if (this.currentToken.equals(token)) {
                this.nextToken();
                return true;
            }
            return false;
        }

        public void consume(String token) throws ParseException {
            if (!this.tryConsume(token)) {
                throw this.parseException("Expected \"" + token + "\".");
            }
        }

        public boolean lookingAtInteger() {
            if (this.currentToken.length() == 0) {
                return false;
            }
            char c2 = this.currentToken.charAt(0);
            return '0' <= c2 && c2 <= '9' || c2 == '-' || c2 == '+';
        }

        public String consumeIdentifier() throws ParseException {
            for (int i = 0; i < this.currentToken.length(); ++i) {
                char c2 = this.currentToken.charAt(i);
                if ('a' <= c2 && c2 <= 'z' || 'A' <= c2 && c2 <= 'Z' || '0' <= c2 && c2 <= '9' || c2 == '_' || c2 == '.') continue;
                throw this.parseException("Expected identifier.");
            }
            String result2 = this.currentToken;
            this.nextToken();
            return result2;
        }

        public int consumeInt32() throws ParseException {
            try {
                int result2 = TextFormat.parseInt32(this.currentToken);
                this.nextToken();
                return result2;
            }
            catch (NumberFormatException e2) {
                throw this.integerParseException(e2);
            }
        }

        public int consumeUInt32() throws ParseException {
            try {
                int result2 = TextFormat.parseUInt32(this.currentToken);
                this.nextToken();
                return result2;
            }
            catch (NumberFormatException e2) {
                throw this.integerParseException(e2);
            }
        }

        public long consumeInt64() throws ParseException {
            try {
                long result2 = TextFormat.parseInt64(this.currentToken);
                this.nextToken();
                return result2;
            }
            catch (NumberFormatException e2) {
                throw this.integerParseException(e2);
            }
        }

        public long consumeUInt64() throws ParseException {
            try {
                long result2 = TextFormat.parseUInt64(this.currentToken);
                this.nextToken();
                return result2;
            }
            catch (NumberFormatException e2) {
                throw this.integerParseException(e2);
            }
        }

        public double consumeDouble() throws ParseException {
            if (DOUBLE_INFINITY.matcher(this.currentToken).matches()) {
                boolean negative = this.currentToken.startsWith("-");
                this.nextToken();
                return negative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if (this.currentToken.equalsIgnoreCase("nan")) {
                this.nextToken();
                return Double.NaN;
            }
            try {
                double result2 = Double.parseDouble(this.currentToken);
                this.nextToken();
                return result2;
            }
            catch (NumberFormatException e2) {
                throw this.floatParseException(e2);
            }
        }

        public float consumeFloat() throws ParseException {
            if (FLOAT_INFINITY.matcher(this.currentToken).matches()) {
                boolean negative = this.currentToken.startsWith("-");
                this.nextToken();
                return negative ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
            }
            if (FLOAT_NAN.matcher(this.currentToken).matches()) {
                this.nextToken();
                return Float.NaN;
            }
            try {
                float result2 = Float.parseFloat(this.currentToken);
                this.nextToken();
                return result2;
            }
            catch (NumberFormatException e2) {
                throw this.floatParseException(e2);
            }
        }

        public boolean consumeBoolean() throws ParseException {
            if (this.currentToken.equals("true") || this.currentToken.equals("t") || this.currentToken.equals("1")) {
                this.nextToken();
                return true;
            }
            if (this.currentToken.equals("false") || this.currentToken.equals("f") || this.currentToken.equals("0")) {
                this.nextToken();
                return false;
            }
            throw this.parseException("Expected \"true\" or \"false\".");
        }

        public String consumeString() throws ParseException {
            return this.consumeByteString().toStringUtf8();
        }

        public ByteString consumeByteString() throws ParseException {
            ArrayList<ByteString> list2 = new ArrayList<ByteString>();
            this.consumeByteString(list2);
            while (this.currentToken.startsWith("'") || this.currentToken.startsWith("\"")) {
                this.consumeByteString(list2);
            }
            return ByteString.copyFrom(list2);
        }

        private void consumeByteString(List<ByteString> list2) throws ParseException {
            char quote;
            char c2 = quote = this.currentToken.length() > 0 ? this.currentToken.charAt(0) : (char)'\u0000';
            if (quote != '\"' && quote != '\'') {
                throw this.parseException("Expected string.");
            }
            if (this.currentToken.length() < 2 || this.currentToken.charAt(this.currentToken.length() - 1) != quote) {
                throw this.parseException("String missing ending quote.");
            }
            try {
                String escaped = this.currentToken.substring(1, this.currentToken.length() - 1);
                ByteString result2 = TextFormat.unescapeBytes(escaped);
                this.nextToken();
                list2.add(result2);
            }
            catch (InvalidEscapeSequenceException e2) {
                throw this.parseException(e2.getMessage());
            }
        }

        public ParseException parseException(String description) {
            return new ParseException(this.line + 1, this.column + 1, description);
        }

        public ParseException parseExceptionPreviousToken(String description) {
            return new ParseException(this.previousLine + 1, this.previousColumn + 1, description);
        }

        private ParseException integerParseException(NumberFormatException e2) {
            return this.parseException("Couldn't parse integer: " + e2.getMessage());
        }

        private ParseException floatParseException(NumberFormatException e2) {
            return this.parseException("Couldn't parse number: " + e2.getMessage());
        }
    }

    private static final class TextGenerator {
        private final Appendable output;
        private final StringBuilder indent = new StringBuilder();
        private boolean atStartOfLine = true;

        private TextGenerator(Appendable output) {
            this.output = output;
        }

        public void indent() {
            this.indent.append("  ");
        }

        public void outdent() {
            int length2 = this.indent.length();
            if (length2 == 0) {
                throw new IllegalArgumentException(" Outdent() without matching Indent().");
            }
            this.indent.delete(length2 - 2, length2);
        }

        public void print(CharSequence text2) throws IOException {
            int size2 = text2.length();
            int pos = 0;
            for (int i = 0; i < size2; ++i) {
                if (text2.charAt(i) != '\n') continue;
                this.write(text2.subSequence(pos, size2), i - pos + 1);
                pos = i + 1;
                this.atStartOfLine = true;
            }
            this.write(text2.subSequence(pos, size2), size2 - pos);
        }

        private void write(CharSequence data, int size2) throws IOException {
            if (size2 == 0) {
                return;
            }
            if (this.atStartOfLine) {
                this.atStartOfLine = false;
                this.output.append(this.indent);
            }
            this.output.append(data);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Printer {
        boolean singleLineMode = false;
        boolean escapeNonAscii = true;

        private Printer() {
        }

        private Printer setSingleLineMode(boolean singleLineMode) {
            this.singleLineMode = singleLineMode;
            return this;
        }

        private Printer setEscapeNonAscii(boolean escapeNonAscii) {
            this.escapeNonAscii = escapeNonAscii;
            return this;
        }

        private void print(MessageOrBuilder message, TextGenerator generator) throws IOException {
            for (Map.Entry<Descriptors.FieldDescriptor, Object> field : message.getAllFields().entrySet()) {
                this.printField(field.getKey(), field.getValue(), generator);
            }
            this.printUnknownFields(message.getUnknownFields(), generator);
        }

        private void printField(Descriptors.FieldDescriptor field, Object value2, TextGenerator generator) throws IOException {
            if (field.isRepeated()) {
                for (Object element2 : (List)value2) {
                    this.printSingleField(field, element2, generator);
                }
            } else {
                this.printSingleField(field, value2, generator);
            }
        }

        private void printSingleField(Descriptors.FieldDescriptor field, Object value2, TextGenerator generator) throws IOException {
            if (field.isExtension()) {
                generator.print("[");
                if (field.getContainingType().getOptions().getMessageSetWireFormat() && field.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && field.isOptional() && field.getExtensionScope() == field.getMessageType()) {
                    generator.print(field.getMessageType().getFullName());
                } else {
                    generator.print(field.getFullName());
                }
                generator.print("]");
            } else if (field.getType() == Descriptors.FieldDescriptor.Type.GROUP) {
                generator.print(field.getMessageType().getName());
            } else {
                generator.print(field.getName());
            }
            if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                if (this.singleLineMode) {
                    generator.print(" { ");
                } else {
                    generator.print(" {\n");
                    generator.indent();
                }
            } else {
                generator.print(": ");
            }
            this.printFieldValue(field, value2, generator);
            if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                if (this.singleLineMode) {
                    generator.print("} ");
                } else {
                    generator.outdent();
                    generator.print("}\n");
                }
            } else if (this.singleLineMode) {
                generator.print(" ");
            } else {
                generator.print("\n");
            }
        }

        private void printFieldValue(Descriptors.FieldDescriptor field, Object value2, TextGenerator generator) throws IOException {
            switch (field.getType()) {
                case INT32: 
                case SINT32: 
                case SFIXED32: {
                    generator.print(((Integer)value2).toString());
                    break;
                }
                case INT64: 
                case SINT64: 
                case SFIXED64: {
                    generator.print(((Long)value2).toString());
                    break;
                }
                case BOOL: {
                    generator.print(((Boolean)value2).toString());
                    break;
                }
                case FLOAT: {
                    generator.print(((Float)value2).toString());
                    break;
                }
                case DOUBLE: {
                    generator.print(((Double)value2).toString());
                    break;
                }
                case UINT32: 
                case FIXED32: {
                    generator.print(TextFormat.unsignedToString((Integer)value2));
                    break;
                }
                case UINT64: 
                case FIXED64: {
                    generator.print(TextFormat.unsignedToString((Long)value2));
                    break;
                }
                case STRING: {
                    generator.print("\"");
                    generator.print(this.escapeNonAscii ? TextFormat.escapeText((String)value2) : (String)value2);
                    generator.print("\"");
                    break;
                }
                case BYTES: {
                    generator.print("\"");
                    generator.print(TextFormat.escapeBytes((ByteString)value2));
                    generator.print("\"");
                    break;
                }
                case ENUM: {
                    generator.print(((Descriptors.EnumValueDescriptor)value2).getName());
                    break;
                }
                case MESSAGE: 
                case GROUP: {
                    this.print((Message)value2, generator);
                }
            }
        }

        private void printUnknownFields(UnknownFieldSet unknownFields, TextGenerator generator) throws IOException {
            for (Map.Entry<Integer, UnknownFieldSet.Field> entry : unknownFields.asMap().entrySet()) {
                int number = entry.getKey();
                UnknownFieldSet.Field field = entry.getValue();
                this.printUnknownField(number, 0, field.getVarintList(), generator);
                this.printUnknownField(number, 5, field.getFixed32List(), generator);
                this.printUnknownField(number, 1, field.getFixed64List(), generator);
                this.printUnknownField(number, 2, field.getLengthDelimitedList(), generator);
                for (UnknownFieldSet value2 : field.getGroupList()) {
                    generator.print(entry.getKey().toString());
                    if (this.singleLineMode) {
                        generator.print(" { ");
                    } else {
                        generator.print(" {\n");
                        generator.indent();
                    }
                    this.printUnknownFields(value2, generator);
                    if (this.singleLineMode) {
                        generator.print("} ");
                        continue;
                    }
                    generator.outdent();
                    generator.print("}\n");
                }
            }
        }

        private void printUnknownField(int number, int wireType, List<?> values2, TextGenerator generator) throws IOException {
            for (Object value2 : values2) {
                generator.print(String.valueOf(number));
                generator.print(": ");
                TextFormat.printUnknownFieldValue(wireType, value2, generator);
                generator.print(this.singleLineMode ? " " : "\n");
            }
        }

        static /* synthetic */ Printer access$100(Printer x0, boolean x1) {
            return x0.setSingleLineMode(x1);
        }

        static /* synthetic */ Printer access$200(Printer x0, boolean x1) {
            return x0.setEscapeNonAscii(x1);
        }
    }
}

