/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mesos.protobuf;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.mesos.protobuf.BoundedByteString;
import org.apache.mesos.protobuf.ByteString;
import org.apache.mesos.protobuf.CodedInputStream;
import org.apache.mesos.protobuf.RopeByteString;
import org.apache.mesos.protobuf.Utf8;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LiteralByteString
extends ByteString {
    protected final byte[] bytes;
    private int hash = 0;

    LiteralByteString(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public byte byteAt(int index2) {
        return this.bytes[index2];
    }

    @Override
    public int size() {
        return this.bytes.length;
    }

    @Override
    public ByteString substring(int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("Beginning index: " + beginIndex + " < 0");
        }
        if (endIndex > this.size()) {
            throw new IndexOutOfBoundsException("End index: " + endIndex + " > " + this.size());
        }
        int substringLength = endIndex - beginIndex;
        if (substringLength < 0) {
            throw new IndexOutOfBoundsException("Beginning index larger than ending index: " + beginIndex + ", " + endIndex);
        }
        ByteString result2 = substringLength == 0 ? ByteString.EMPTY : new BoundedByteString(this.bytes, this.getOffsetIntoBytes() + beginIndex, substringLength);
        return result2;
    }

    @Override
    protected void copyToInternal(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
        System.arraycopy(this.bytes, sourceOffset, target, targetOffset, numberToCopy);
    }

    @Override
    public void copyTo(ByteBuffer target) {
        target.put(this.bytes, this.getOffsetIntoBytes(), this.size());
    }

    @Override
    public ByteBuffer asReadOnlyByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.bytes, this.getOffsetIntoBytes(), this.size());
        return byteBuffer.asReadOnlyBuffer();
    }

    @Override
    public List<ByteBuffer> asReadOnlyByteBufferList() {
        ArrayList<ByteBuffer> result2 = new ArrayList<ByteBuffer>(1);
        result2.add(this.asReadOnlyByteBuffer());
        return result2;
    }

    @Override
    public void writeTo(OutputStream outputStream2) throws IOException {
        outputStream2.write(this.toByteArray());
    }

    @Override
    public String toString(String charsetName) throws UnsupportedEncodingException {
        return new String(this.bytes, this.getOffsetIntoBytes(), this.size(), charsetName);
    }

    @Override
    public boolean isValidUtf8() {
        int offset = this.getOffsetIntoBytes();
        return Utf8.isValidUtf8(this.bytes, offset, offset + this.size());
    }

    @Override
    protected int partialIsValidUtf8(int state2, int offset, int length2) {
        int index2 = this.getOffsetIntoBytes() + offset;
        return Utf8.partialIsValidUtf8(state2, this.bytes, index2, index2 + length2);
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ByteString)) {
            return false;
        }
        if (this.size() != ((ByteString)other).size()) {
            return false;
        }
        if (this.size() == 0) {
            return true;
        }
        if (other instanceof LiteralByteString) {
            return this.equalsRange((LiteralByteString)other, 0, this.size());
        }
        if (other instanceof RopeByteString) {
            return other.equals(this);
        }
        throw new IllegalArgumentException("Has a new type of ByteString been created? Found " + other.getClass());
    }

    boolean equalsRange(LiteralByteString other, int offset, int length2) {
        if (length2 > other.size()) {
            throw new IllegalArgumentException("Length too large: " + length2 + this.size());
        }
        if (offset + length2 > other.size()) {
            throw new IllegalArgumentException("Ran off end of other: " + offset + ", " + length2 + ", " + other.size());
        }
        byte[] thisBytes = this.bytes;
        byte[] otherBytes = other.bytes;
        int thisLimit = this.getOffsetIntoBytes() + length2;
        int thisIndex = this.getOffsetIntoBytes();
        int otherIndex = other.getOffsetIntoBytes() + offset;
        while (thisIndex < thisLimit) {
            if (thisBytes[thisIndex] != otherBytes[otherIndex]) {
                return false;
            }
            ++thisIndex;
            ++otherIndex;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h2 = this.hash;
        if (h2 == 0) {
            int size2 = this.size();
            h2 = this.partialHash(size2, 0, size2);
            if (h2 == 0) {
                h2 = 1;
            }
            this.hash = h2;
        }
        return h2;
    }

    @Override
    protected int peekCachedHashCode() {
        return this.hash;
    }

    @Override
    protected int partialHash(int h2, int offset, int length2) {
        int i;
        byte[] thisBytes = this.bytes;
        int limit2 = i + length2;
        for (i = this.getOffsetIntoBytes() + offset; i < limit2; ++i) {
            h2 = h2 * 31 + thisBytes[i];
        }
        return h2;
    }

    @Override
    public InputStream newInput() {
        return new ByteArrayInputStream(this.bytes, this.getOffsetIntoBytes(), this.size());
    }

    @Override
    public CodedInputStream newCodedInput() {
        return CodedInputStream.newInstance(this.bytes, this.getOffsetIntoBytes(), this.size());
    }

    @Override
    public ByteString.ByteIterator iterator() {
        return new LiteralByteIterator();
    }

    @Override
    protected int getTreeDepth() {
        return 0;
    }

    @Override
    protected boolean isBalanced() {
        return true;
    }

    protected int getOffsetIntoBytes() {
        return 0;
    }

    private class LiteralByteIterator
    implements ByteString.ByteIterator {
        private int position = 0;
        private final int limit;

        private LiteralByteIterator() {
            this.limit = LiteralByteString.this.size();
        }

        public boolean hasNext() {
            return this.position < this.limit;
        }

        public Byte next() {
            return this.nextByte();
        }

        public byte nextByte() {
            try {
                return LiteralByteString.this.bytes[this.position++];
            }
            catch (ArrayIndexOutOfBoundsException e2) {
                throw new NoSuchElementException(e2.getMessage());
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

