/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mesos.protobuf;

import java.util.NoSuchElementException;
import org.apache.mesos.protobuf.ByteString;
import org.apache.mesos.protobuf.LiteralByteString;

class BoundedByteString
extends LiteralByteString {
    private final int bytesOffset;
    private final int bytesLength;

    BoundedByteString(byte[] bytes, int offset, int length2) {
        super(bytes);
        if (offset < 0) {
            throw new IllegalArgumentException("Offset too small: " + offset);
        }
        if (length2 < 0) {
            throw new IllegalArgumentException("Length too small: " + offset);
        }
        if ((long)offset + (long)length2 > (long)bytes.length) {
            throw new IllegalArgumentException("Offset+Length too large: " + offset + "+" + length2);
        }
        this.bytesOffset = offset;
        this.bytesLength = length2;
    }

    public byte byteAt(int index2) {
        if (index2 < 0) {
            throw new ArrayIndexOutOfBoundsException("Index too small: " + index2);
        }
        if (index2 >= this.size()) {
            throw new ArrayIndexOutOfBoundsException("Index too large: " + index2 + ", " + this.size());
        }
        return this.bytes[this.bytesOffset + index2];
    }

    public int size() {
        return this.bytesLength;
    }

    protected int getOffsetIntoBytes() {
        return this.bytesOffset;
    }

    protected void copyToInternal(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
        System.arraycopy(this.bytes, this.getOffsetIntoBytes() + sourceOffset, target, targetOffset, numberToCopy);
    }

    public ByteString.ByteIterator iterator() {
        return new BoundedByteIterator();
    }

    private class BoundedByteIterator
    implements ByteString.ByteIterator {
        private int position;
        private final int limit;

        private BoundedByteIterator() {
            this.position = BoundedByteString.this.getOffsetIntoBytes();
            this.limit = this.position + BoundedByteString.this.size();
        }

        public boolean hasNext() {
            return this.position < this.limit;
        }

        public Byte next() {
            return this.nextByte();
        }

        public byte nextByte() {
            if (this.position >= this.limit) {
                throw new NoSuchElementException();
            }
            return BoundedByteString.this.bytes[this.position++];
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

