/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mesos;

import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.mesos.MesosNativeLibrary;

public class Log {
    private long __log;

    public Log(int quorum, String path2, Set<String> pids) {
        this.initialize(quorum, path2, pids);
    }

    public Log(int quorum, String path2, String servers, long timeout, TimeUnit unit2, String znode) {
        this.initialize(quorum, path2, servers, timeout, unit2, znode);
    }

    public Log(int quorum, String path2, String servers, long timeout, TimeUnit unit2, String znode, String scheme, byte[] credentials) {
        this.initialize(quorum, path2, servers, timeout, unit2, znode, scheme, credentials);
    }

    public Position position(byte[] identity2) {
        long value2 = (long)(identity2[0] & 0xFF) << 56 | (long)(identity2[1] & 0xFF) << 48 | (long)(identity2[2] & 0xFF) << 40 | (long)(identity2[3] & 0xFF) << 32 | (long)(identity2[4] & 0xFF) << 24 | (long)(identity2[5] & 0xFF) << 16 | (long)(identity2[6] & 0xFF) << 8 | (long)(identity2[7] & 0xFF);
        return new Position(value2);
    }

    protected native void initialize(int var1, String var2, Set<String> var3);

    protected native void initialize(int var1, String var2, String var3, long var4, TimeUnit var6, String var7);

    protected native void initialize(int var1, String var2, String var3, long var4, TimeUnit var6, String var7, String var8, byte[] var9);

    protected native void finalize();

    static {
        MesosNativeLibrary.load();
    }

    public static class Writer {
        private Log log;
        private long __log;
        private long __writer;

        public Writer(Log log, long timeout, TimeUnit unit2, int retries) {
            this.log = log;
            this.initialize(log, timeout, unit2, retries);
        }

        public native Position append(byte[] var1, long var2, TimeUnit var4) throws TimeoutException, WriterFailedException;

        public native Position truncate(Position var1, long var2, TimeUnit var4) throws TimeoutException, WriterFailedException;

        protected native void initialize(Log var1, long var2, TimeUnit var4, int var5);

        protected native void finalize();
    }

    public static class Reader {
        private Log log;
        private long __log;
        private long __reader;

        public Reader(Log log) {
            this.log = log;
            this.initialize(log);
        }

        public native List<Entry> read(Position var1, Position var2, long var3, TimeUnit var5) throws TimeoutException, OperationFailedException;

        public native Position beginning();

        public native Position ending();

        protected native void initialize(Log var1);

        protected native void finalize();
    }

    public static class WriterFailedException
    extends Exception {
        public WriterFailedException(String message) {
            super(message);
        }

        public WriterFailedException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class OperationFailedException
    extends Exception {
        public OperationFailedException(String message) {
            super(message);
        }

        public OperationFailedException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class Entry {
        public final Position position;
        public final byte[] data;

        private Entry(Position position, byte[] data) {
            this.position = position;
            this.data = data;
        }
    }

    public static class Position
    implements Comparable<Position> {
        private final long value;

        @Override
        public int compareTo(Position that) {
            return Long.signum(this.value - that.value);
        }

        public boolean equals(Object that) {
            return that instanceof Position && this.value == ((Position)that).value;
        }

        public String toString() {
            return "Position " + this.value;
        }

        public byte[] identity() {
            byte[] bytes = new byte[]{(byte)(0xFFL & this.value >> 56), (byte)(0xFFL & this.value >> 48), (byte)(0xFFL & this.value >> 40), (byte)(0xFFL & this.value >> 32), (byte)(0xFFL & this.value >> 24), (byte)(0xFFL & this.value >> 16), (byte)(0xFFL & this.value >> 8), (byte)(0xFFL & this.value)};
            return bytes;
        }

        private Position(long value2) {
            this.value = value2;
        }
    }
}

