/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.url;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import org.apache.ivy.util.Credentials;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.CredentialsStore;

public final class IvyAuthenticator
extends Authenticator {
    private Authenticator original;
    private static boolean securityWarningLogged = false;

    private IvyAuthenticator(Authenticator original) {
        this.original = original;
    }

    public static void install() {
        block5: {
            Authenticator original = null;
            try {
                Field f2 = Authenticator.class.getDeclaredField("theAuthenticator");
                f2.setAccessible(true);
                original = (Authenticator)f2.get(null);
            }
            catch (Throwable t) {
                Message.debug("Error occurred while getting the original authenticator: " + t.getMessage());
            }
            if (!(original instanceof IvyAuthenticator)) {
                try {
                    Authenticator.setDefault(new IvyAuthenticator(original));
                }
                catch (SecurityException e2) {
                    if (securityWarningLogged) break block5;
                    securityWarningLogged = true;
                    Message.warn("Not enough permissions to set the IvyAuthenticator. HTTP(S) authentication will be disabled!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PasswordAuthentication getPasswordAuthentication() {
        PasswordAuthentication result2 = null;
        if (this.isProxyAuthentication()) {
            String proxyUser = System.getProperty("http.proxyUser");
            if (proxyUser != null && proxyUser.trim().length() > 0) {
                String proxyPass = System.getProperty("http.proxyPassword", "");
                Message.debug("authenicating to proxy server with username [" + proxyUser + "]");
                result2 = new PasswordAuthentication(proxyUser, proxyPass.toCharArray());
            }
        } else {
            Credentials c2 = CredentialsStore.INSTANCE.getCredentials(this.getRequestingPrompt(), this.getRequestingHost());
            Message.debug("authentication: k='" + Credentials.buildKey(this.getRequestingPrompt(), this.getRequestingHost()) + "' c='" + c2 + "'");
            if (c2 != null) {
                String password = c2.getPasswd() == null ? "" : c2.getPasswd();
                result2 = new PasswordAuthentication(c2.getUserName(), password.toCharArray());
            }
        }
        if (result2 == null && this.original != null) {
            Authenticator.setDefault(this.original);
            try {
                result2 = Authenticator.requestPasswordAuthentication(this.getRequestingHost(), this.getRequestingSite(), this.getRequestingPort(), this.getRequestingProtocol(), this.getRequestingPrompt(), this.getRequestingScheme());
            }
            finally {
                Authenticator.setDefault(this);
            }
        }
        return result2;
    }

    private boolean isProxyAuthentication() {
        try {
            Method m = Authenticator.class.getDeclaredMethod("getRequestorType", null);
            Object result2 = m.invoke((Object)this, null);
            return "PROXY".equals(String.valueOf(result2));
        }
        catch (NoSuchMethodException e2) {
        }
        catch (Throwable t) {
            Message.debug("Error occurred while checking if the authentication request is for the proxy server: " + t.getMessage());
        }
        StackTraceElement[] stackTrace = new Exception().getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            if ("getHttpProxyAuthentication".equals(stackTrace[i].getMethodName())) {
                return true;
            }
            if (!"getServerAuthentication".equals(stackTrace[i].getMethodName())) continue;
            return false;
        }
        String proxyHost = System.getProperty("http.proxyHost");
        return this.getRequestingHost().equals(proxyHost);
    }
}

