/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.url;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.Credentials;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.HostUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.AbstractURLHandler;
import org.apache.ivy.util.url.CredentialsStore;
import org.apache.ivy.util.url.URLHandler;

public class HttpClientHandler
extends AbstractURLHandler {
    private static final SimpleDateFormat LAST_MODIFIED_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US);
    private int proxyPort;
    private String proxyHost = null;
    private String proxyUserName = null;
    private String proxyPasswd = null;
    private HttpClientHelper httpClientHelper;
    private static HttpClient httpClient;

    public HttpClientHandler() {
        this.configureProxy();
    }

    private void configureProxy() {
        this.proxyHost = System.getProperty("http.proxyHost");
        if (this.useProxy()) {
            this.proxyPort = Integer.parseInt(System.getProperty("http.proxyPort", "80"));
            this.proxyUserName = System.getProperty("http.proxyUser");
            this.proxyPasswd = System.getProperty("http.proxyPassword");
            Message.verbose("proxy configured: host=" + this.proxyHost + " port=" + this.proxyPort + " user=" + this.proxyUserName);
        } else {
            Message.verbose("no proxy configured");
        }
    }

    public InputStream openStream(URL url) throws IOException {
        GetMethod get2 = this.doGet(url, 0);
        if (!this.checkStatusCode(url, (HttpMethodBase)get2)) {
            get2.releaseConnection();
            throw new IOException("The HTTP response code for " + url + " did not indicate a success." + " See log for more detail.");
        }
        Header encoding = get2.getResponseHeader("Content-Encoding");
        return this.getDecodingInputStream(encoding == null ? null : encoding.getValue(), get2.getResponseBodyAsStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(URL src, File dest, CopyProgressListener l) throws IOException {
        GetMethod get2 = this.doGet(src, 0);
        try {
            if (!this.checkStatusCode(src, (HttpMethodBase)get2)) {
                throw new IOException("The HTTP response code for " + src + " did not indicate a success." + " See log for more detail.");
            }
            Header encoding = get2.getResponseHeader("Content-Encoding");
            InputStream is = this.getDecodingInputStream(encoding == null ? null : encoding.getValue(), get2.getResponseBodyAsStream());
            FileUtil.copy(is, dest, l);
            dest.setLastModified(this.getLastModified((HttpMethodBase)get2));
        }
        finally {
            get2.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(File src, URL dest, CopyProgressListener l) throws IOException {
        HttpClient client = this.getClient();
        PutMethod put2 = new PutMethod(this.normalizeToString(dest));
        put2.setDoAuthentication(this.useAuthentication(dest) || this.useProxyAuthentication());
        put2.getParams().setBooleanParameter("http.protocol.expect-continue", true);
        try {
            put2.setRequestEntity((RequestEntity)new FileRequestEntity(src));
            int statusCode = client.executeMethod((HttpMethod)put2);
            this.validatePutStatusCode(dest, statusCode, null);
        }
        finally {
            put2.releaseConnection();
        }
    }

    public URLHandler.URLInfo getURLInfo(URL url) {
        return this.getURLInfo(url, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLHandler.URLInfo getURLInfo(URL url, int timeout) {
        Object method = null;
        try {
            method = this.getRequestMethod() == 2 ? this.doHead(url, timeout) : this.doGet(url, timeout);
            if (this.checkStatusCode(url, (HttpMethodBase)method)) {
                URLHandler.URLInfo uRLInfo = new URLHandler.URLInfo(true, this.getResponseContentLength((HttpMethodBase)method), this.getLastModified((HttpMethodBase)method), method.getRequestCharSet());
                return uRLInfo;
            }
        }
        catch (HttpException e2) {
            Message.error("HttpClientHandler: " + e2.getMessage() + ":" + e2.getReasonCode() + "=" + e2.getReason() + " url=" + url);
        }
        catch (UnknownHostException e3) {
            Message.warn("Host " + e3.getMessage() + " not found. url=" + url);
            Message.info("You probably access the destination server through a proxy server that is not well configured.");
        }
        catch (IOException e4) {
            Message.error("HttpClientHandler: " + e4.getMessage() + " url=" + url);
        }
        catch (IllegalArgumentException e5) {
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return UNAVAILABLE;
    }

    private boolean checkStatusCode(URL url, HttpMethodBase method) throws IOException {
        int status = method.getStatusCode();
        if (status == 200) {
            return true;
        }
        if ("HEAD".equals(method.getName()) && status == 204) {
            return true;
        }
        Message.debug("HTTP response status: " + status + " url=" + url);
        if (status == 407) {
            Message.warn("Your proxy requires authentication.");
        } else if (String.valueOf(status).startsWith("4")) {
            Message.verbose("CLIENT ERROR: " + method.getStatusText() + " url=" + url);
        } else if (String.valueOf(status).startsWith("5")) {
            Message.error("SERVER ERROR: " + method.getStatusText() + " url=" + url);
        }
        return false;
    }

    private long getLastModified(HttpMethodBase method) {
        Header header = method.getResponseHeader("last-modified");
        if (header != null) {
            String lastModified = header.getValue();
            try {
                return LAST_MODIFIED_FORMAT.parse(lastModified).getTime();
            }
            catch (ParseException e2) {
                return System.currentTimeMillis();
            }
        }
        return System.currentTimeMillis();
    }

    private long getResponseContentLength(HttpMethodBase head2) {
        return this.getHttpClientHelper().getResponseContentLength(head2);
    }

    private HttpClientHelper getHttpClientHelper() {
        if (this.httpClientHelper == null) {
            try {
                HttpMethodBase.class.getMethod("getResponseContentLength", new Class[0]);
                this.httpClientHelper = new HttpClientHelper3x();
                Message.verbose("using commons httpclient 3.x helper");
            }
            catch (SecurityException e2) {
                Message.verbose("unable to get access to getResponseContentLength of commons-httpclient HeadMethod. Please use commons-httpclient 3.0 or use ivy with sufficient security permissions.");
                Message.verbose("exception: " + e2.getMessage());
                this.httpClientHelper = new HttpClientHelper2x();
                Message.verbose("using commons httpclient 2.x helper");
            }
            catch (NoSuchMethodException e3) {
                this.httpClientHelper = new HttpClientHelper2x();
                Message.verbose("using commons httpclient 2.x helper");
            }
        }
        return this.httpClientHelper;
    }

    public int getHttpClientMajorVersion() {
        HttpClientHelper helper2 = this.getHttpClientHelper();
        return helper2.getHttpClientMajorVersion();
    }

    private GetMethod doGet(URL url, int timeout) throws IOException {
        HttpClient client = this.getClient();
        client.setTimeout(timeout);
        GetMethod get2 = new GetMethod(this.normalizeToString(url));
        get2.setDoAuthentication(this.useAuthentication(url) || this.useProxyAuthentication());
        get2.setRequestHeader("Accept-Encoding", "gzip,deflate");
        client.executeMethod((HttpMethod)get2);
        return get2;
    }

    private HeadMethod doHead(URL url, int timeout) throws IOException {
        HttpClient client = this.getClient();
        client.setTimeout(timeout);
        HeadMethod head2 = new HeadMethod(this.normalizeToString(url));
        head2.setDoAuthentication(this.useAuthentication(url) || this.useProxyAuthentication());
        client.executeMethod((HttpMethod)head2);
        return head2;
    }

    private HttpClient getClient() {
        if (httpClient == null) {
            final MultiThreadedHttpConnectionManager connManager = new MultiThreadedHttpConnectionManager();
            httpClient = new HttpClient((HttpConnectionManager)connManager);
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                public void run() {
                    connManager.shutdown();
                }
            }));
            ArrayList<String> authPrefs = new ArrayList<String>(3);
            authPrefs.add("Digest");
            authPrefs.add("Basic");
            authPrefs.add("NTLM");
            httpClient.getParams().setParameter("http.auth.scheme-priority", authPrefs);
            if (this.useProxy()) {
                httpClient.getHostConfiguration().setProxy(this.proxyHost, this.proxyPort);
                if (this.useProxyAuthentication()) {
                    httpClient.getState().setProxyCredentials(new AuthScope(this.proxyHost, this.proxyPort, AuthScope.ANY_REALM), HttpClientHandler.createCredentials(this.proxyUserName, this.proxyPasswd));
                }
            }
            httpClient.getParams().setParameter("http.useragent", (Object)this.getUserAgent());
            httpClient.getParams().setParameter("http.authentication.credential-provider", (Object)new IvyCredentialsProvider());
        }
        return httpClient;
    }

    private boolean useProxy() {
        return this.proxyHost != null && this.proxyHost.trim().length() > 0;
    }

    private boolean useAuthentication(URL url) {
        return CredentialsStore.INSTANCE.hasCredentials(url.getHost());
    }

    private boolean useProxyAuthentication() {
        return this.proxyUserName != null && this.proxyUserName.trim().length() > 0;
    }

    private static org.apache.commons.httpclient.Credentials createCredentials(String username, String password) {
        String domain;
        String user;
        int backslashIndex = username.indexOf(92);
        if (backslashIndex >= 0) {
            user = username.substring(backslashIndex + 1);
            domain = username.substring(0, backslashIndex);
        } else {
            user = username;
            domain = System.getProperty("http.auth.ntlm.domain", "");
        }
        return new NTCredentials(user, password, HostUtil.getLocalHostName(), domain);
    }

    private static class FileRequestEntity
    implements RequestEntity {
        private File file;

        public FileRequestEntity(File file2) {
            this.file = file2;
        }

        public long getContentLength() {
            return this.file.length();
        }

        public String getContentType() {
            return null;
        }

        public boolean isRepeatable() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeRequest(OutputStream out2) throws IOException {
            FileInputStream instream = new FileInputStream(this.file);
            try {
                FileUtil.copy(instream, out2, null, false);
            }
            finally {
                ((InputStream)instream).close();
            }
        }
    }

    private static class IvyCredentialsProvider
    implements CredentialsProvider {
        private IvyCredentialsProvider() {
        }

        public org.apache.commons.httpclient.Credentials getCredentials(AuthScheme scheme, String host, int port, boolean proxy) throws CredentialsNotAvailableException {
            String realm2 = scheme.getRealm();
            Credentials c2 = CredentialsStore.INSTANCE.getCredentials(realm2, host);
            if (c2 != null) {
                return HttpClientHandler.createCredentials(c2.getUserName(), c2.getPasswd());
            }
            return null;
        }
    }

    public static interface HttpClientHelper {
        public long getResponseContentLength(HttpMethodBase var1);

        public int getHttpClientMajorVersion();
    }

    private static final class HttpClientHelper2x
    implements HttpClientHelper {
        private static final int VERSION = 2;

        private HttpClientHelper2x() {
        }

        public long getResponseContentLength(HttpMethodBase method) {
            Header header = method.getResponseHeader("Content-Length");
            if (header != null) {
                try {
                    return Integer.parseInt(header.getValue());
                }
                catch (NumberFormatException e2) {
                    Message.verbose("Invalid content-length value: " + e2.getMessage());
                }
            }
            return 0L;
        }

        public int getHttpClientMajorVersion() {
            return 2;
        }
    }

    private static final class HttpClientHelper3x
    implements HttpClientHelper {
        private static final int VERSION = 3;

        private HttpClientHelper3x() {
        }

        public long getResponseContentLength(HttpMethodBase method) {
            return method.getResponseContentLength();
        }

        public int getHttpClientMajorVersion() {
            return 3;
        }
    }
}

