/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.cli;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.ivy.util.StringUtils;
import org.apache.ivy.util.cli.CommandLine;
import org.apache.ivy.util.cli.Option;
import org.apache.ivy.util.cli.ParseException;

public class CommandLineParser {
    private static final int MIN_DESC_WIDTH = 40;
    private static final int MAX_SPEC_WIDTH = 30;
    private Map options = new LinkedHashMap();
    private Map categories = new LinkedHashMap();

    public CommandLineParser addCategory(String category) {
        this.categories.put(category, new ArrayList());
        return this;
    }

    public CommandLineParser addOption(Option option2) {
        this.options.put(option2.getName(), option2);
        if (!this.categories.isEmpty()) {
            ((List)this.categories.values().toArray()[this.categories.values().size() - 1]).add(option2);
        }
        return this;
    }

    public CommandLine parse(String[] args) throws ParseException {
        CommandLine line = new CommandLine();
        int index2 = args.length;
        ListIterator<String> iterator2 = Arrays.asList(args).listIterator();
        while (iterator2.hasNext()) {
            String arg = iterator2.next();
            if ("--".equals(arg)) {
                index2 = iterator2.nextIndex();
                break;
            }
            if (!arg.startsWith("-")) {
                index2 = iterator2.previousIndex();
                break;
            }
            Option option2 = (Option)this.options.get(arg.substring(1));
            if (option2 == null) {
                throw new ParseException("Unrecognized option: " + arg);
            }
            line.addOptionValues(arg.substring(1), option2.parse(iterator2));
        }
        String[] leftOverArgs = new String[args.length - index2];
        System.arraycopy(args, index2, leftOverArgs, 0, leftOverArgs.length);
        line.setLeftOverArgs(leftOverArgs);
        return line;
    }

    public void printHelp(PrintWriter pw, int width, String command, boolean showDeprecated) {
        pw.println("usage: " + command);
        int specWidth = 0;
        for (Option option2 : this.options.values()) {
            if (option2.isDeprecated() && !showDeprecated) continue;
            specWidth = Math.min(30, Math.max(specWidth, option2.getSpec().length()));
        }
        for (Map.Entry entry : this.categories.entrySet()) {
            String category = (String)entry.getKey();
            pw.println("==== " + category);
            List options2 = (List)entry.getValue();
            for (Option option3 : options2) {
                if (option3.isDeprecated() && !showDeprecated) continue;
                String spec2 = option3.getSpec();
                pw.print(" " + spec2);
                int specLength = spec2.length() + 1;
                pw.print(StringUtils.repeat(" ", specWidth - specLength));
                StringBuffer desc = new StringBuffer((option3.isDeprecated() ? "DEPRECATED: " : "") + option3.getDescription());
                int count2 = Math.min(desc.length(), width - Math.max(specLength, specWidth));
                if (count2 > 40 || desc.length() + specLength < width) {
                    pw.print(desc.substring(0, count2));
                    desc.delete(0, count2);
                }
                pw.println();
                while (desc.length() > 0) {
                    pw.print(StringUtils.repeat(" ", specWidth));
                    count2 = Math.min(desc.length(), width - specWidth);
                    pw.println(desc.substring(0, count2));
                    desc.delete(0, count2);
                }
            }
            pw.println();
        }
    }
}

