/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.ivy.util.CopyProgressEvent;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.URLHandlerRegistry;

public final class FileUtil {
    private static final int BUFFER_SIZE = 65536;
    private static final byte[] EMPTY_BUFFER = new byte[0];
    private static final Pattern ALLOWED_PATH_PATTERN = Pattern.compile("[\\w-./\\\\:~ %\\(\\)]+");

    private FileUtil() {
    }

    public static void symlinkInMass(Map destToSrcMap, boolean overwrite) throws IOException {
        try {
            StringBuffer sb = new StringBuffer();
            Iterator keyItr = destToSrcMap.entrySet().iterator();
            while (keyItr.hasNext()) {
                Map.Entry entry = keyItr.next();
                File destFile = (File)entry.getKey();
                File srcFile = (File)entry.getValue();
                if (!ALLOWED_PATH_PATTERN.matcher(srcFile.getAbsolutePath()).matches()) {
                    throw new IOException("Unsafe file to 'mass' symlink: '" + srcFile.getAbsolutePath() + "'");
                }
                if (!ALLOWED_PATH_PATTERN.matcher(destFile.getAbsolutePath()).matches()) {
                    throw new IOException("Unsafe file to 'mass' symlink to: '" + destFile.getAbsolutePath() + "'");
                }
                sb.append("ln -s -f \"" + srcFile.getAbsolutePath() + "\"  \"" + destFile.getAbsolutePath() + "\";");
                if (!keyItr.hasNext()) continue;
                sb.append("\n");
            }
            String commands = sb.toString();
            Runtime runtime = Runtime.getRuntime();
            Message.verbose("executing \"sh\" of:\n\t" + commands.replaceAll("\n", "\n\t"));
            Process process2 = runtime.exec("sh");
            OutputStream os = process2.getOutputStream();
            os.write(commands.getBytes("UTF-8"));
            os.flush();
            os.close();
            if (process2.waitFor() != 0) {
                String line;
                InputStream errorStream = process2.getErrorStream();
                InputStreamReader isr = new InputStreamReader(errorStream);
                BufferedReader br = new BufferedReader(isr);
                StringBuffer error = new StringBuffer();
                while ((line = br.readLine()) != null) {
                    error.append(line);
                    error.append('\n');
                }
                throw new IOException("error running ln commands with 'sh':\n" + error);
            }
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
        }
    }

    public static void symlink(File src, File dest, CopyProgressListener l, boolean overwrite) throws IOException {
        if (!FileUtil.prepareCopy(src, dest, overwrite)) {
            return;
        }
        try {
            Runtime runtime = Runtime.getRuntime();
            Message.verbose("executing 'ln -s -f " + src.getAbsolutePath() + " " + dest.getPath() + "'");
            Process process2 = runtime.exec(new String[]{"ln", "-s", "-f", src.getAbsolutePath(), dest.getPath()});
            if (process2.waitFor() != 0) {
                String line;
                InputStream errorStream = process2.getErrorStream();
                InputStreamReader isr = new InputStreamReader(errorStream);
                BufferedReader br = new BufferedReader(isr);
                StringBuffer error = new StringBuffer();
                while ((line = br.readLine()) != null) {
                    error.append(line);
                    error.append('\n');
                }
                throw new IOException("error symlinking " + src + " to " + dest + ":\n" + error);
            }
            if (!dest.exists()) {
                throw new IOException("error symlinking: " + dest + " doesn't exists");
            }
            if (dest.getAbsolutePath().equals(dest.getCanonicalPath())) {
                dest.delete();
                throw new IOException("error symlinking: " + dest + " isn't a symlink");
            }
        }
        catch (IOException e2) {
            Message.verbose("symlink failed; falling back to copy", e2);
            FileUtil.copy(src, dest, l, overwrite);
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
        }
    }

    public static boolean copy(File src, File dest, CopyProgressListener l) throws IOException {
        return FileUtil.copy(src, dest, l, false);
    }

    public static boolean prepareCopy(File src, File dest, boolean overwrite) throws IOException {
        if (src.isDirectory()) {
            if (dest.exists()) {
                if (!dest.isDirectory()) {
                    throw new IOException("impossible to copy: destination is not a directory: " + dest);
                }
            } else {
                dest.mkdirs();
            }
            return true;
        }
        if (dest.exists()) {
            if (!dest.isFile()) {
                throw new IOException("impossible to copy: destination is not a file: " + dest);
            }
            if (overwrite) {
                if (!dest.canWrite()) {
                    dest.delete();
                }
            } else {
                Message.verbose(dest + " already exists, nothing done");
                return false;
            }
        }
        if (dest.getParentFile() != null) {
            dest.getParentFile().mkdirs();
        }
        return true;
    }

    public static boolean copy(File src, File dest, CopyProgressListener l, boolean overwrite) throws IOException {
        if (!FileUtil.prepareCopy(src, dest, overwrite)) {
            return false;
        }
        if (src.isDirectory()) {
            return FileUtil.deepCopy(src, dest, l, overwrite);
        }
        FileUtil.copy((InputStream)new FileInputStream(src), dest, l);
        long srcLen = src.length();
        long destLen = dest.length();
        if (srcLen != destLen) {
            dest.delete();
            throw new IOException("size of source file " + src.toString() + "(" + srcLen + ") differs from size of dest file " + dest.toString() + "(" + destLen + ") - please retry");
        }
        dest.setLastModified(src.lastModified());
        return true;
    }

    public static boolean deepCopy(File src, File dest, CopyProgressListener l, boolean overwrite) throws IOException {
        int i;
        List<File> existingChild = Collections.EMPTY_LIST;
        if (dest.exists()) {
            if (!dest.isDirectory()) {
                dest.delete();
                dest.mkdirs();
                dest.setLastModified(src.lastModified());
            } else {
                File[] children2 = dest.listFiles();
                if (children2 != null) {
                    existingChild = Arrays.asList(children2);
                }
            }
        } else {
            dest.mkdirs();
            dest.setLastModified(src.lastModified());
        }
        File[] toCopy = src.listFiles();
        if (toCopy != null) {
            for (i = 0; i < toCopy.length; ++i) {
                File childDest = new File(dest, toCopy[i].getName());
                existingChild.remove(childDest);
                if (toCopy[i].isDirectory()) {
                    FileUtil.deepCopy(toCopy[i], childDest, l, overwrite);
                    continue;
                }
                FileUtil.copy(toCopy[i], childDest, l, overwrite);
            }
        }
        for (i = 0; i < existingChild.size(); ++i) {
            FileUtil.forceDelete(existingChild.get(i));
        }
        return true;
    }

    public static void copy(URL src, File dest, CopyProgressListener l) throws IOException {
        URLHandlerRegistry.getDefault().download(src, dest, l);
    }

    public static void copy(File src, URL dest, CopyProgressListener l) throws IOException {
        URLHandlerRegistry.getDefault().upload(src, dest, l);
    }

    public static void copy(InputStream src, File dest, CopyProgressListener l) throws IOException {
        if (dest.getParentFile() != null) {
            dest.getParentFile().mkdirs();
        }
        FileUtil.copy(src, new FileOutputStream(dest), l);
    }

    public static void copy(InputStream src, OutputStream dest, CopyProgressListener l) throws IOException {
        FileUtil.copy(src, dest, l, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream src, OutputStream dest, CopyProgressListener l, boolean autoClose) throws IOException {
        CopyProgressEvent evt = null;
        if (l != null) {
            evt = new CopyProgressEvent();
        }
        try {
            int c2;
            byte[] buffer2 = new byte[65536];
            long total = 0L;
            if (l != null) {
                l.start(evt);
            }
            while ((c2 = src.read(buffer2)) != -1) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new IOException("transfer interrupted");
                }
                dest.write(buffer2, 0, c2);
                total += (long)c2;
                if (l == null) continue;
                l.progress(evt.update(buffer2, c2, total));
            }
            if (l != null) {
                evt.update(EMPTY_BUFFER, 0, total);
            }
            try {
                dest.flush();
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (autoClose) {
                src.close();
                dest.close();
            }
        }
        finally {
            if (autoClose) {
                try {
                    src.close();
                }
                catch (IOException ex) {}
                try {
                    dest.close();
                }
                catch (IOException ex) {}
            }
        }
        if (l != null) {
            l.end(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readEntirely(BufferedReader in2) throws IOException {
        try {
            StringBuffer buf = new StringBuffer();
            String line = in2.readLine();
            while (line != null) {
                buf.append(line + "\n");
                line = in2.readLine();
            }
            String string2 = buf.toString();
            return string2;
        }
        finally {
            in2.close();
        }
    }

    public static String readEntirely(File f2) throws IOException {
        return FileUtil.readEntirely(new FileInputStream(f2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readEntirely(InputStream is) throws IOException {
        try {
            int c2;
            StringBuffer sb = new StringBuffer();
            byte[] buffer2 = new byte[65536];
            while ((c2 = is.read(buffer2)) != -1) {
                sb.append(new String(buffer2, 0, c2));
            }
            String string2 = sb.toString();
            return string2;
        }
        finally {
            is.close();
        }
    }

    public static String concat(String dir, String file2) {
        return dir + "/" + file2;
    }

    public static boolean forceDelete(File file2) {
        File[] files;
        if (!file2.exists()) {
            return true;
        }
        if (file2.isDirectory() && (files = file2.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                if (FileUtil.forceDelete(files[i])) continue;
                return false;
            }
        }
        return file2.delete();
    }

    public static List getPathFiles(File root, File file2) {
        ArrayList<File> ret = new ArrayList<File>();
        while (file2 != null && !file2.getAbsolutePath().equals(root.getAbsolutePath())) {
            ret.add(file2);
            file2 = file2.getParentFile();
        }
        if (root != null) {
            ret.add(root);
        }
        Collections.reverse(ret);
        return ret;
    }

    public static Collection listAll(File dir, Collection ignore2) {
        return FileUtil.listAll(dir, new ArrayList(), ignore2);
    }

    private static Collection listAll(File file2, Collection list2, Collection ignore2) {
        if (ignore2.contains(file2.getName())) {
            return list2;
        }
        if (file2.exists()) {
            list2.add(file2);
        }
        if (file2.isDirectory()) {
            File[] files = file2.listFiles();
            for (int i = 0; i < files.length; ++i) {
                FileUtil.listAll(files[i], list2, ignore2);
            }
        }
        return list2;
    }

    public static File resolveFile(File file2, String filename) {
        File result2 = new File(filename);
        if (!result2.isAbsolute()) {
            result2 = new File(file2, filename);
        }
        return FileUtil.normalize(result2.getPath());
    }

    public static File normalize(String path2) {
        Stack<String> s = new Stack<String>();
        String[] dissect = FileUtil.dissect(path2);
        s.push(dissect[0]);
        StringTokenizer tok = new StringTokenizer(dissect[1], File.separator);
        while (tok.hasMoreTokens()) {
            String thisToken = tok.nextToken();
            if (".".equals(thisToken)) continue;
            if ("..".equals(thisToken)) {
                if (s.size() < 2) {
                    return new File(path2);
                }
                s.pop();
                continue;
            }
            s.push(thisToken);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.size(); ++i) {
            if (i > 1) {
                sb.append(File.separatorChar);
            }
            sb.append(s.elementAt(i));
        }
        return new File(sb.toString());
    }

    private static String[] dissect(String path2) {
        char sep = File.separatorChar;
        path2 = path2.replace('/', sep).replace('\\', sep);
        String root = null;
        int colon2 = path2.indexOf(58);
        if (colon2 > 0) {
            int next2 = colon2 + 1;
            root = path2.substring(0, next2);
            char[] ca = path2.toCharArray();
            root = root + sep;
            next2 = ca[next2] == sep ? next2 + 1 : next2;
            StringBuffer sbPath = new StringBuffer();
            for (int i = next2; i < ca.length; ++i) {
                if (ca[i] == sep && ca[i - 1] == sep) continue;
                sbPath.append(ca[i]);
            }
            path2 = sbPath.toString();
        } else if (path2.length() > 1 && path2.charAt(1) == sep) {
            int nextsep = path2.indexOf(sep, 2);
            root = (nextsep = path2.indexOf(sep, nextsep + 1)) > 2 ? path2.substring(0, nextsep + 1) : path2;
            path2 = path2.substring(root.length());
        } else {
            root = File.separator;
            path2 = path2.substring(1);
        }
        return new String[]{root, path2};
    }

    public static long getFileLength(File file2) {
        long l = 0L;
        if (file2.isDirectory()) {
            File[] files = file2.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    l += FileUtil.getFileLength(files[i]);
                }
            }
        } else {
            l = file2.length();
        }
        return l;
    }
}

