/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

public class Credentials {
    private String realm;
    private String host;
    private String userName;
    private String passwd;

    public Credentials(String realm2, String host, String userName, String passwd) {
        this.realm = realm2;
        this.host = host;
        this.userName = userName;
        this.passwd = passwd;
    }

    public String getHost() {
        return this.host;
    }

    public String getPasswd() {
        return this.passwd;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getUserName() {
        return this.userName;
    }

    public static String buildKey(String realm2, String host) {
        if (realm2 == null || "".equals(realm2.trim())) {
            return host;
        }
        return realm2 + "@" + host;
    }

    public String toString() {
        return this.getKey() + " " + this.getUserName() + "/" + this.getPasswdAsStars();
    }

    private String getPasswdAsStars() {
        if (this.passwd == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = this.passwd.length(); i > 0; --i) {
            sb.append('*');
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Credentials) {
            Credentials c2 = (Credentials)o;
            return this.getKey().equals(c2.getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String getKey() {
        return Credentials.buildKey(this.realm, this.host);
    }
}

