/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.tools.analyser;

import java.io.File;
import java.io.IOException;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorWriter;
import org.apache.ivy.tools.analyser.DependencyAnalyser;
import org.apache.ivy.tools.analyser.JarJarDependencyAnalyser;
import org.apache.ivy.tools.analyser.JarModuleFinder;
import org.apache.ivy.util.Message;

public class RepositoryAnalyser {
    public void analyse(String pattern2, DependencyAnalyser depAnalyser) {
        JarModuleFinder finder = new JarModuleFinder(pattern2);
        ModuleDescriptor[] mds = depAnalyser.analyze(finder.findJarModules());
        Message.info("found " + mds.length + " modules");
        for (int i = 0; i < mds.length; ++i) {
            File ivyFile = new File(IvyPatternHelper.substitute(pattern2, DefaultArtifact.newIvyArtifact(mds[i].getModuleRevisionId(), mds[i].getPublicationDate())));
            try {
                Message.info("generating " + ivyFile);
                XmlModuleDescriptorWriter.write(mds[i], ivyFile);
                continue;
            }
            catch (IOException e2) {
                Message.debug(e2);
            }
        }
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("usage: ivyanalyser path/to/jarjar.jar absolute-ivy-repository-pattern");
            return;
        }
        String jarjarLocation = args[0];
        String pattern2 = args[1];
        JarJarDependencyAnalyser a2 = new JarJarDependencyAnalyser(new File(jarjarLocation));
        new RepositoryAnalyser().analyse(pattern2, a2);
    }
}

