/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.tools.analyser;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.HashMap;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.tools.analyser.DependencyAnalyser;
import org.apache.ivy.tools.analyser.JarModule;
import org.apache.ivy.tools.analyser.JarModuleFinder;
import org.apache.ivy.util.Message;

public class JarJarDependencyAnalyser
implements DependencyAnalyser {
    private File jarjarjarLocation;

    public JarJarDependencyAnalyser(File jarjarjarLocation) {
        this.jarjarjarLocation = jarjarjarLocation;
    }

    public ModuleDescriptor[] analyze(JarModule[] modules2) {
        StringBuffer jarjarCmd = new StringBuffer("java -jar \"").append(this.jarjarjarLocation.getAbsolutePath()).append("\" --find --level=jar ");
        HashMap<String, JarModule> jarModulesMap = new HashMap<String, JarModule>();
        HashMap<ModuleRevisionId, DefaultModuleDescriptor> mds = new HashMap<ModuleRevisionId, DefaultModuleDescriptor>();
        for (int i = 0; i < modules2.length; ++i) {
            jarModulesMap.put(modules2[i].getJar().getAbsolutePath(), modules2[i]);
            DefaultModuleDescriptor md = DefaultModuleDescriptor.newBasicInstance(modules2[i].getMrid(), new Date(modules2[i].getJar().lastModified()));
            mds.put(modules2[i].getMrid(), md);
            jarjarCmd.append("\"").append(modules2[i].getJar().getAbsolutePath()).append("\"");
            if (i + 1 >= modules2.length) continue;
            jarjarCmd.append(File.pathSeparator);
        }
        Message.verbose("jarjar command: " + jarjarCmd);
        try {
            String line;
            Process p = Runtime.getRuntime().exec(jarjarCmd.toString());
            BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = r.readLine()) != null) {
                String[] deps = line.split(" -> ");
                JarModule module2 = (JarModule)jarModulesMap.get(deps[0]);
                JarModule dependency2 = (JarModule)jarModulesMap.get(deps[1]);
                if (module2.getMrid().getModuleId().equals(dependency2.getMrid().getModuleId())) continue;
                Message.verbose(module2.getMrid() + " depends on " + dependency2.getMrid());
                DefaultModuleDescriptor md = (DefaultModuleDescriptor)mds.get(module2.getMrid());
                DefaultDependencyDescriptor dd = new DefaultDependencyDescriptor(md, dependency2.getMrid(), false, false, true);
                dd.addDependencyConfiguration("default", "default");
                md.addDependency(dd);
            }
        }
        catch (IOException e2) {
            Message.debug(e2);
        }
        return mds.values().toArray(new ModuleDescriptor[mds.values().size()]);
    }

    public static void main(String[] args) {
        JarJarDependencyAnalyser a2 = new JarJarDependencyAnalyser(new File("D:/temp/test2/jarjar-0.7.jar"));
        a2.analyze(new JarModuleFinder("D:/temp/test2/ivyrep/[organisation]/[module]/[revision]/[artifact].[ext]").findJarModules());
    }
}

