/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.version;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.matcher.Matcher;
import org.apache.ivy.plugins.matcher.PatternMatcher;

public class Match {
    private String revision;
    private String pattern;
    private String args;
    private String matcher;

    public String getArgs() {
        return this.args;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    public String getMatcher() {
        return this.matcher;
    }

    public void setMatcher(String matcher) {
        this.matcher = matcher;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern2) {
        this.pattern = pattern2;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public Matcher getPatternMatcher(ModuleRevisionId askedMrid) {
        String[] argValues;
        String revision = askedMrid.getRevision();
        String[] args = Match.split(this.getArgs());
        if (args.length != (argValues = this.getRevisionArgs(revision)).length) {
            return new NoMatchMatcher();
        }
        HashMap<String, String> variables2 = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            variables2.put(args[i], argValues[i]);
        }
        String pattern2 = this.getPattern();
        pattern2 = IvyPatternHelper.substituteVariables(pattern2, variables2);
        PatternMatcher pMatcher = IvyContext.getContext().getSettings().getMatcher(this.matcher);
        return pMatcher.getMatcher(pattern2);
    }

    private String[] getRevisionArgs(String revision) {
        int bracketStartIndex = revision.indexOf(40);
        if (bracketStartIndex == -1) {
            return new String[0];
        }
        int bracketEndIndex = revision.indexOf(41);
        if (bracketEndIndex <= bracketStartIndex + 1) {
            return new String[0];
        }
        String args = revision.substring(bracketStartIndex + 1, bracketEndIndex);
        return Match.split(args);
    }

    private static String[] split(String string2) {
        if (string2 == null) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(string2, ", ");
        ArrayList<String> tokens = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    private static class NoMatchMatcher
    implements Matcher {
        private NoMatchMatcher() {
        }

        public boolean isExact() {
            return false;
        }

        public boolean matches(String str) {
            return false;
        }
    }
}

