/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.trigger;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.event.IvyEvent;
import org.apache.ivy.core.resolve.ResolveProcessException;
import org.apache.ivy.plugins.trigger.AbstractTrigger;
import org.apache.ivy.util.Message;

public class LogTrigger
extends AbstractTrigger {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private String message = "";
    private File file = null;
    private boolean append = true;
    private String encoding = "";

    public void progress(IvyEvent event) {
        this.log(IvyPatternHelper.substituteVariables(this.message, event.getAttributes()));
    }

    protected void log(String message) {
        if (this.file == null) {
            Message.info(message);
        } else {
            Writer out2 = null;
            try {
                message = message + LINE_SEPARATOR;
                String filename = this.file.getAbsolutePath();
                out2 = this.encoding == null || this.encoding.length() == 0 ? new FileWriter(filename, this.append) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename, this.append), this.encoding));
                out2.write(message, 0, message.length());
            }
            catch (IOException e2) {
                throw new ResolveProcessException(e2);
            }
            finally {
                if (out2 != null) {
                    try {
                        out2.close();
                    }
                    catch (IOException e3) {
                        throw new ResolveProcessException(e3);
                    }
                }
            }
        }
    }

    public void setMessage(String msg) {
        this.message = msg;
    }

    public void setFile(File file2) {
        this.file = file2;
    }

    public void setAppend(boolean append2) {
        this.append = append2;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

