/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.plugins.resolver.util.URLLister;
import org.apache.ivy.util.Message;

public final class ResolverHelper {
    private ResolverHelper() {
    }

    public static String[] listTokenValues(Repository rep2, String pattern2, String token) {
        String tokenString;
        String fileSep = rep2.getFileSeparator();
        int index2 = (pattern2 = rep2.standardize(pattern2)).indexOf(tokenString = IvyPatternHelper.getTokenString(token));
        if (index2 == -1) {
            Message.verbose("unable to list " + token + " in " + pattern2 + ": token not found in pattern");
            return null;
        }
        if ((pattern2.length() <= index2 + tokenString.length() || fileSep.equals(pattern2.substring(index2 + tokenString.length(), index2 + tokenString.length() + 1))) && (index2 == 0 || fileSep.equals(pattern2.substring(index2 - 1, index2)))) {
            String root = pattern2.substring(0, index2);
            return ResolverHelper.listAll(rep2, root);
        }
        int slashIndex = pattern2.substring(0, index2).lastIndexOf(fileSep);
        String root = slashIndex == -1 ? "" : pattern2.substring(0, slashIndex);
        try {
            Message.debug("\tusing " + rep2 + " to list all in " + root);
            List all2 = rep2.list(root);
            if (all2 != null) {
                Message.debug("\t\tfound " + all2.size() + " urls");
                ArrayList<String> ret = new ArrayList<String>(all2.size());
                int endNameIndex = pattern2.indexOf(fileSep, slashIndex + 1);
                String namePattern = endNameIndex != -1 ? pattern2.substring(slashIndex + 1, endNameIndex) : pattern2.substring(slashIndex + 1);
                namePattern = namePattern.replaceAll("\\.", "\\\\.");
                namePattern = IvyPatternHelper.substituteToken(namePattern, token, "(.+)");
                Pattern p = Pattern.compile(namePattern);
                for (String path2 : all2) {
                    Matcher m = p.matcher(path2.substring(root.length() + 1));
                    if (!m.matches()) continue;
                    String value2 = m.group(1);
                    ret.add(value2);
                }
                Message.debug("\t\t" + ret.size() + " matched " + pattern2);
                return ret.toArray(new String[ret.size()]);
            }
            return null;
        }
        catch (IOException e2) {
            Message.verbose("problem while listing resources in " + root + " with " + rep2, e2);
            return null;
        }
        catch (Exception e3) {
            Message.warn("problem while listing resources in " + root + " with " + rep2, e3);
            return null;
        }
    }

    public static String[] listAll(Repository rep2, String parent2) {
        try {
            String fileSep = rep2.getFileSeparator();
            Message.debug("\tusing " + rep2 + " to list all in " + parent2);
            List all2 = rep2.list(parent2);
            if (all2 != null) {
                Message.debug("\t\tfound " + all2.size() + " resources");
                ArrayList<String> names = new ArrayList<String>(all2.size());
                for (String path2 : all2) {
                    if (path2.endsWith(fileSep)) {
                        path2 = path2.substring(0, path2.length() - 1);
                    }
                    int slashIndex = path2.lastIndexOf(fileSep);
                    names.add(path2.substring(slashIndex + 1));
                }
                return names.toArray(new String[names.size()]);
            }
            Message.debug("\t\tno resources found");
            return null;
        }
        catch (IOException e2) {
            Message.verbose("problem while listing resources in " + parent2 + " with " + rep2, e2);
            return null;
        }
        catch (Exception e3) {
            Message.warn("problem while listing resources in " + parent2 + " with " + rep2, e3);
            return null;
        }
    }

    public static ResolvedResource[] findAll(Repository rep2, ModuleRevisionId mrid, String pattern2, Artifact artifact) {
        String partiallyResolvedPattern = IvyPatternHelper.substitute(pattern2, ModuleRevisionId.newInstance(mrid, IvyPatternHelper.getTokenString("revision")), artifact);
        Message.debug("\tlisting all in " + partiallyResolvedPattern);
        String[] revs = ResolverHelper.listTokenValues(rep2, partiallyResolvedPattern, "revision");
        if (revs != null) {
            Message.debug("\tfound revs: " + Arrays.asList(revs));
            ArrayList<ResolvedResource> ret = new ArrayList<ResolvedResource>(revs.length);
            for (int i = 0; i < revs.length; ++i) {
                String rres = IvyPatternHelper.substituteToken(partiallyResolvedPattern, "revision", revs[i]);
                try {
                    Resource res = rep2.getResource(rres);
                    if (res == null) continue;
                    ret.add(new ResolvedResource(res, revs[i]));
                    continue;
                }
                catch (IOException e2) {
                    Message.warn("impossible to get resource from name listed by repository: " + rres, e2);
                }
            }
            if (revs.length != ret.size()) {
                Message.debug("\tfound resolved res: " + ret);
            }
            return ret.toArray(new ResolvedResource[ret.size()]);
        }
        if (partiallyResolvedPattern.indexOf("[revision]") == -1) {
            try {
                Resource res = rep2.getResource(partiallyResolvedPattern);
                if (res.exists()) {
                    Message.debug("\tonly one resource found without real listing: using and defining it as working@" + rep2.getName() + " revision: " + res.getName());
                    return new ResolvedResource[]{new ResolvedResource(res, "working@" + rep2.getName())};
                }
            }
            catch (IOException e3) {
                Message.debug("\timpossible to get resource from name listed by repository: " + partiallyResolvedPattern, e3);
            }
            Message.debug("\tno revision found");
        }
        return null;
    }

    public static String[] listTokenValues(URLLister lister, String pattern2, String token) {
        if (lister.accept(pattern2 = ResolverHelper.standardize(pattern2))) {
            String tokenString = IvyPatternHelper.getTokenString(token);
            int index2 = pattern2.indexOf(tokenString);
            if (index2 == -1) {
                Message.verbose("unable to list " + token + " in " + pattern2 + ": token not found in pattern");
                return null;
            }
            if ((pattern2.length() <= index2 + tokenString.length() || "/".equals(pattern2.substring(index2 + tokenString.length(), index2 + tokenString.length() + 1))) && (index2 == 0 || "/".equals(pattern2.substring(index2 - 1, index2)))) {
                String root = pattern2.substring(0, index2);
                try {
                    return ResolverHelper.listAll(lister, new URL(root));
                }
                catch (MalformedURLException e2) {
                    Message.warn("malformed url from pattern root: " + root + ": " + e2.getMessage());
                    return null;
                }
            }
            int slashIndex = pattern2.substring(0, index2).lastIndexOf(47);
            String root = slashIndex == -1 ? "" : pattern2.substring(0, slashIndex);
            try {
                Message.debug("\tusing " + lister + " to list all in " + root);
                List all2 = lister.listAll(new URL(root));
                Message.debug("\t\tfound " + all2.size() + " urls");
                ArrayList<String> ret = new ArrayList<String>(all2.size());
                int endNameIndex = pattern2.indexOf(47, slashIndex + 1);
                String namePattern = endNameIndex != -1 ? pattern2.substring(slashIndex + 1, endNameIndex) : pattern2.substring(slashIndex + 1);
                String acceptNamePattern = ".*" + IvyPatternHelper.substituteToken(namePattern, token, "([^/]+)") + ".*";
                Pattern p = Pattern.compile(acceptNamePattern.toString());
                for (URL url : all2) {
                    String path2 = ResolverHelper.standardize(url.getPath());
                    Matcher m = p.matcher(path2);
                    if (!m.matches()) continue;
                    String value2 = m.group(1);
                    ret.add(value2);
                }
                Message.debug("\t\t" + ret.size() + " matched " + pattern2);
                return ret.toArray(new String[ret.size()]);
            }
            catch (Exception e3) {
                Message.warn("problem while listing files in " + root, e3);
                return null;
            }
        }
        return null;
    }

    private static String standardize(String path2) {
        return path2.replace('\\', '/');
    }

    public static String[] listAll(URLLister lister, URL root) {
        try {
            if (lister.accept(root.toExternalForm())) {
                Message.debug("\tusing " + lister + " to list all in " + root);
                List all2 = lister.listAll(root);
                Message.debug("\t\tfound " + all2.size() + " urls");
                ArrayList<String> names = new ArrayList<String>(all2.size());
                for (URL dir : all2) {
                    String path2 = dir.getPath();
                    if (path2.endsWith("/")) {
                        path2 = path2.substring(0, path2.length() - 1);
                    }
                    int slashIndex = path2.lastIndexOf(47);
                    names.add(path2.substring(slashIndex + 1));
                }
                return names.toArray(new String[names.size()]);
            }
            return null;
        }
        catch (Exception e2) {
            Message.warn("problem while listing directories in " + root, e2);
            return null;
        }
    }
}

