/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ivy.plugins.resolver.util.URLLister;

public class FileURLLister
implements URLLister {
    private File basedir;

    public FileURLLister() {
        this(null);
    }

    public FileURLLister(File baseDir) {
        this.basedir = baseDir;
    }

    public boolean accept(String pattern2) {
        return pattern2.startsWith("file");
    }

    public List listAll(URL url) throws IOException {
        File file2;
        String path2;
        try {
            path2 = new File(new URI(url.toExternalForm())).getPath();
        }
        catch (URISyntaxException e2) {
            path2 = url.getPath();
        }
        File file3 = file2 = this.basedir == null ? new File(path2) : new File(this.basedir, path2);
        if (file2.exists() && file2.isDirectory()) {
            String[] files = file2.list();
            ArrayList<URL> ret = new ArrayList<URL>(files.length);
            URL context = url.getPath().endsWith("/") ? url : new URL(url.toExternalForm() + "/");
            for (int i = 0; i < files.length; ++i) {
                ret.add(new URL(context, files[i]));
            }
            return ret;
        }
        return Collections.EMPTY_LIST;
    }

    public String toString() {
        return "file lister";
    }
}

