/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver.packager;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.plugins.repository.Resource;

public class BuiltFileResource
implements Resource {
    public static final String BUILT_ARTIFACT_PATTERN = "artifacts/[type]s/[artifact].[ext]";
    private final File file;

    public BuiltFileResource(File file2) {
        this.file = file2;
    }

    public BuiltFileResource(File dir, Artifact artifact) {
        this(new File(dir, IvyPatternHelper.substitute(BUILT_ARTIFACT_PATTERN, artifact)));
    }

    public String getName() {
        return this.file.toURI().toString();
    }

    public Resource clone(String name) {
        return new BuiltFileResource(new File(name));
    }

    public long getLastModified() {
        return this.file.lastModified();
    }

    public long getContentLength() {
        return this.file.length();
    }

    public boolean exists() {
        return this.file.exists();
    }

    public String toString() {
        return this.getName();
    }

    public File getFile() {
        return this.file;
    }

    public boolean isLocal() {
        return false;
    }

    public InputStream openStream() throws IOException {
        return new FileInputStream(this.file);
    }
}

