/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.core.search.ModuleEntry;
import org.apache.ivy.core.search.OrganisationEntry;
import org.apache.ivy.core.search.RevisionEntry;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.resolver.ResolverSettings;
import org.apache.ivy.plugins.resolver.URLResolver;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.util.ContextualSAXHandler;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.XMLHelper;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IBiblioResolver
extends URLResolver {
    private static final String M2_PER_MODULE_PATTERN = "[revision]/[artifact]-[revision](-[classifier]).[ext]";
    private static final String M2_PATTERN = "[organisation]/[module]/[revision]/[artifact]-[revision](-[classifier]).[ext]";
    public static final String DEFAULT_PATTERN = "[module]/[type]s/[artifact]-[revision].[ext]";
    public static final String DEFAULT_ROOT = "http://www.ibiblio.org/maven/";
    public static final String DEFAULT_M2_ROOT = "http://repo1.maven.org/maven2/";
    private String root = null;
    private String pattern = null;
    private boolean usepoms = true;
    private boolean useMavenMetadata = true;

    public IBiblioResolver() {
        this.setChangingMatcher("regexp");
        this.setChangingPattern(".*-SNAPSHOT");
    }

    public ResolvedResource findIvyFileRef(DependencyDescriptor dd, ResolveData data) {
        if (this.isM2compatible() && this.isUsepoms()) {
            ModuleRevisionId mrid = dd.getDependencyRevisionId();
            mrid = this.convertM2IdForResourceSearch(mrid);
            ResolvedResource rres = null;
            if (dd.getDependencyRevisionId().getRevision().endsWith("SNAPSHOT") && (rres = this.findSnapshotDescriptor(dd, data, mrid)) != null) {
                return rres;
            }
            rres = this.findResourceUsingPatterns(mrid, this.getIvyPatterns(), DefaultArtifact.newPomArtifact(mrid, data.getDate()), this.getRMDParser(dd, data), data.getDate());
            return rres;
        }
        return null;
    }

    public ResolvedResource findArtifactRef(Artifact artifact, Date date) {
        this.ensureConfigured(this.getSettings());
        ModuleRevisionId mrid = artifact.getModuleRevisionId();
        if (this.isM2compatible()) {
            mrid = this.convertM2IdForResourceSearch(mrid);
        }
        ResolvedResource rres = null;
        if (artifact.getId().getRevision().endsWith("SNAPSHOT") && this.isM2compatible() && (rres = this.findSnapshotArtifact(artifact, date, mrid)) != null) {
            return rres;
        }
        return this.findResourceUsingPatterns(mrid, this.getArtifactPatterns(), artifact, this.getDefaultRMDParser(artifact.getModuleRevisionId().getModuleId()), date);
    }

    private ResolvedResource findSnapshotArtifact(Artifact artifact, Date date, ModuleRevisionId mrid) {
        String rev = this.findSnapshotVersion(mrid);
        if (rev != null) {
            String pattern2 = this.getWholePattern().replaceFirst("\\-\\[revision\\]", "-" + rev);
            return this.findResourceUsingPattern(mrid, pattern2, artifact, this.getDefaultRMDParser(artifact.getModuleRevisionId().getModuleId()), date);
        }
        return null;
    }

    private ResolvedResource findSnapshotDescriptor(DependencyDescriptor dd, ResolveData data, ModuleRevisionId mrid) {
        String rev = this.findSnapshotVersion(mrid);
        if (rev != null) {
            Message.verbose("[" + rev + "] " + mrid);
            String pattern2 = this.getWholePattern().replaceFirst("\\-\\[revision\\]", "-" + rev);
            return this.findResourceUsingPattern(mrid, pattern2, DefaultArtifact.newPomArtifact(mrid, data.getDate()), this.getRMDParser(dd, data), data.getDate());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findSnapshotVersion(ModuleRevisionId mrid) {
        if (!this.isM2compatible()) {
            return null;
        }
        if (this.shouldUseMavenMetadata(this.getWholePattern())) {
            InputStream metadataStream = null;
            try {
                String metadataLocation = IvyPatternHelper.substitute(this.root + "[organisation]/[module]/[revision]/maven-metadata.xml", mrid);
                Resource metadata = this.getRepository().getResource(metadataLocation);
                if (metadata.exists()) {
                    metadataStream = metadata.openStream();
                    final StringBuffer timestamp = new StringBuffer();
                    final StringBuffer buildNumer = new StringBuffer();
                    XMLHelper.parse(metadataStream, null, (DefaultHandler)new ContextualSAXHandler(){

                        public void endElement(String uri, String localName, String qName) throws SAXException {
                            if ("metadata/versioning/snapshot/timestamp".equals(this.getContext())) {
                                timestamp.append(this.getText());
                            }
                            if ("metadata/versioning/snapshot/buildNumber".equals(this.getContext())) {
                                buildNumer.append(this.getText());
                            }
                            super.endElement(uri, localName, qName);
                        }
                    }, null);
                    if (timestamp.length() > 0) {
                        String rev = mrid.getRevision();
                        rev = rev.substring(0, rev.length() - "SNAPSHOT".length());
                        String string2 = rev = rev + timestamp.toString() + "-" + buildNumer.toString();
                        return string2;
                    }
                } else {
                    Message.verbose("\tmaven-metadata not available: " + metadata);
                }
            }
            catch (IOException e2) {
                Message.verbose("impossible to access maven metadata file, ignored", e2);
            }
            catch (SAXException e3) {
                Message.verbose("impossible to parse maven metadata file, ignored", e3);
            }
            catch (ParserConfigurationException e4) {
                Message.verbose("impossible to parse maven metadata file, ignored", e4);
            }
            finally {
                if (metadataStream != null) {
                    try {
                        metadataStream.close();
                    }
                    catch (IOException e5) {}
                }
            }
        }
        return null;
    }

    public void setM2compatible(boolean m2compatible) {
        super.setM2compatible(m2compatible);
        if (m2compatible) {
            if (this.root == null) {
                this.root = DEFAULT_M2_ROOT;
            }
            if (this.pattern == null) {
                this.pattern = M2_PATTERN;
            }
            this.updateWholePattern();
        }
    }

    public void ensureConfigured(ResolverSettings settings) {
        if (settings != null && (this.root == null || this.pattern == null)) {
            if (this.root == null) {
                String root = settings.getVariable("ivy.ibiblio.default.artifact.root");
                if (root != null) {
                    this.root = root;
                } else {
                    settings.configureRepositories(true);
                    this.root = settings.getVariable("ivy.ibiblio.default.artifact.root");
                }
            }
            if (this.pattern == null) {
                String pattern2 = settings.getVariable("ivy.ibiblio.default.artifact.pattern");
                if (pattern2 != null) {
                    this.pattern = pattern2;
                } else {
                    settings.configureRepositories(false);
                    this.pattern = settings.getVariable("ivy.ibiblio.default.artifact.pattern");
                }
            }
            this.updateWholePattern();
        }
    }

    protected String getModuleDescriptorExtension() {
        return "pom";
    }

    private String getWholePattern() {
        return this.root + this.pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern2) {
        if (pattern2 == null) {
            throw new NullPointerException("pattern must not be null");
        }
        this.pattern = pattern2;
        this.ensureConfigured(this.getSettings());
        this.updateWholePattern();
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String root) {
        if (root == null) {
            throw new NullPointerException("root must not be null");
        }
        this.root = !root.endsWith("/") ? root + "/" : root;
        this.ensureConfigured(this.getSettings());
        this.updateWholePattern();
    }

    private void updateWholePattern() {
        if (this.isM2compatible() && this.isUsepoms()) {
            this.setIvyPatterns(Collections.singletonList(this.getWholePattern()));
        } else {
            this.setIvyPatterns(Collections.EMPTY_LIST);
        }
        this.setArtifactPatterns(Collections.singletonList(this.getWholePattern()));
    }

    public void publish(Artifact artifact, File src) {
        throw new UnsupportedOperationException("publish not supported by IBiblioResolver");
    }

    public String[] listTokenValues(String token, Map otherTokenValues) {
        if ("organisation".equals(token)) {
            return new String[0];
        }
        if ("module".equals(token) && !this.isM2compatible()) {
            return new String[0];
        }
        this.ensureConfigured(this.getSettings());
        return super.listTokenValues(token, otherTokenValues);
    }

    protected String[] listTokenValues(String pattern2, String token) {
        if ("organisation".equals(token)) {
            return new String[0];
        }
        if ("module".equals(token) && !this.isM2compatible()) {
            return new String[0];
        }
        this.ensureConfigured(this.getSettings());
        if ("revision".equals(token) && this.shouldUseMavenMetadata(this.getWholePattern())) {
            String partiallyResolvedM2PerModulePattern = IvyPatternHelper.substituteTokens(M2_PER_MODULE_PATTERN, Collections.singletonMap("ext", "pom"));
            if (pattern2.endsWith(partiallyResolvedM2PerModulePattern)) {
                String metadataLocation = pattern2.substring(0, pattern2.lastIndexOf(partiallyResolvedM2PerModulePattern)) + "maven-metadata.xml";
                List revs = this.listRevisionsWithMavenMetadata(this.getRepository(), metadataLocation);
                if (revs != null) {
                    return revs.toArray(new String[revs.size()]);
                }
            } else {
                return new String[0];
            }
        }
        return super.listTokenValues(pattern2, token);
    }

    public OrganisationEntry[] listOrganisations() {
        return new OrganisationEntry[0];
    }

    public ModuleEntry[] listModules(OrganisationEntry org) {
        if (this.isM2compatible()) {
            this.ensureConfigured(this.getSettings());
            return super.listModules(org);
        }
        return new ModuleEntry[0];
    }

    public RevisionEntry[] listRevisions(ModuleEntry mod2) {
        this.ensureConfigured(this.getSettings());
        return super.listRevisions(mod2);
    }

    protected ResolvedResource[] listResources(Repository repository2, ModuleRevisionId mrid, String pattern2, Artifact artifact) {
        if (this.shouldUseMavenMetadata(pattern2)) {
            List revs = this.listRevisionsWithMavenMetadata(repository2, mrid.getModuleId().getAttributes());
            if (revs != null) {
                Message.debug("\tfound revs: " + revs);
                ArrayList<ResolvedResource> rres = new ArrayList<ResolvedResource>();
                for (String rev : revs) {
                    String snapshotVersion;
                    ModuleRevisionId historicalMrid = ModuleRevisionId.newInstance(mrid, rev);
                    String patternForRev = pattern2;
                    if (rev.endsWith("SNAPSHOT") && (snapshotVersion = this.findSnapshotVersion(historicalMrid)) != null) {
                        patternForRev = pattern2.replaceFirst("\\-\\[revision\\]", "-" + snapshotVersion);
                    }
                    String resolvedPattern = IvyPatternHelper.substitute(patternForRev, historicalMrid, artifact);
                    try {
                        Resource res = repository2.getResource(resolvedPattern);
                        if (res == null) continue;
                        rres.add(new ResolvedResource(res, rev));
                    }
                    catch (IOException e2) {
                        Message.warn("impossible to get resource from name listed by maven-metadata.xml:" + rres, e2);
                    }
                }
                return rres.toArray(new ResolvedResource[rres.size()]);
            }
            return super.listResources(repository2, mrid, pattern2, artifact);
        }
        return super.listResources(repository2, mrid, pattern2, artifact);
    }

    private List listRevisionsWithMavenMetadata(Repository repository2, Map tokenValues) {
        String metadataLocation = IvyPatternHelper.substituteTokens(this.root + "[organisation]/[module]/maven-metadata.xml", tokenValues);
        return this.listRevisionsWithMavenMetadata(repository2, metadataLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List listRevisionsWithMavenMetadata(Repository repository2, String metadataLocation) {
        ArrayList revs = null;
        InputStream metadataStream = null;
        try {
            Resource metadata = repository2.getResource(metadataLocation);
            if (metadata.exists()) {
                Message.verbose("\tlisting revisions from maven-metadata: " + metadata);
                final ArrayList metadataRevs = new ArrayList();
                metadataStream = metadata.openStream();
                XMLHelper.parse(metadataStream, null, (DefaultHandler)new ContextualSAXHandler(){

                    public void endElement(String uri, String localName, String qName) throws SAXException {
                        if ("metadata/versioning/versions/version".equals(this.getContext())) {
                            metadataRevs.add(this.getText().trim());
                        }
                        super.endElement(uri, localName, qName);
                    }
                }, null);
                revs = metadataRevs;
            } else {
                Message.verbose("\tmaven-metadata not available: " + metadata);
            }
        }
        catch (IOException e2) {
            Message.verbose("impossible to access maven metadata file, ignored", e2);
        }
        catch (SAXException e3) {
            Message.verbose("impossible to parse maven metadata file, ignored", e3);
        }
        catch (ParserConfigurationException e4) {
            Message.verbose("impossible to parse maven metadata file, ignored", e4);
        }
        finally {
            if (metadataStream != null) {
                try {
                    metadataStream.close();
                }
                catch (IOException e5) {}
            }
        }
        return revs;
    }

    protected void findTokenValues(Collection names, List patterns, Map tokenValues, String token) {
        List revs;
        if ("revision".equals(token) && this.shouldUseMavenMetadata(this.getWholePattern()) && (revs = this.listRevisionsWithMavenMetadata(this.getRepository(), tokenValues)) != null) {
            names.addAll(this.filterNames(revs));
            return;
        }
        super.findTokenValues(names, patterns, tokenValues, token);
    }

    private boolean shouldUseMavenMetadata(String pattern2) {
        return this.isUseMavenMetadata() && this.isM2compatible() && pattern2.endsWith(M2_PATTERN);
    }

    public String getTypeName() {
        return "ibiblio";
    }

    public ResolvedModuleRevision getDependency(DependencyDescriptor dd, ResolveData data) throws ParseException {
        this.ensureConfigured(data.getSettings());
        return super.getDependency(dd, data);
    }

    public DownloadReport download(Artifact[] artifacts2, DownloadOptions options2) {
        this.ensureConfigured(this.getSettings());
        return super.download(artifacts2, options2);
    }

    public boolean exists(Artifact artifact) {
        this.ensureConfigured(this.getSettings());
        return super.exists(artifact);
    }

    public ArtifactOrigin locate(Artifact artifact) {
        this.ensureConfigured(this.getSettings());
        return super.locate(artifact);
    }

    public List getArtifactPatterns() {
        this.ensureConfigured(this.getSettings());
        return super.getArtifactPatterns();
    }

    public boolean isUsepoms() {
        return this.usepoms;
    }

    public void setUsepoms(boolean usepoms) {
        this.usepoms = usepoms;
        this.updateWholePattern();
    }

    public boolean isUseMavenMetadata() {
        return this.useMavenMetadata;
    }

    public void setUseMavenMetadata(boolean useMavenMetadata) {
        this.useMavenMetadata = useMavenMetadata;
    }

    public void dumpSettings() {
        this.ensureConfigured(this.getSettings());
        super.dumpSettings();
        Message.debug("\t\troot: " + this.getRoot());
        Message.debug("\t\tpattern: " + this.getPattern());
        Message.debug("\t\tusepoms: " + this.usepoms);
        Message.debug("\t\tuseMavenMetadata: " + this.useMavenMetadata);
    }
}

