/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.settings.IvyPattern;
import org.apache.ivy.plugins.matcher.Matcher;
import org.apache.ivy.plugins.resolver.BasicResolver;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.plugins.resolver.util.ResourceMDParser;
import org.apache.ivy.util.Message;

public abstract class AbstractPatternsBasedResolver
extends BasicResolver {
    private List ivyPatterns = new ArrayList();
    private List artifactPatterns = new ArrayList();
    private boolean m2compatible = false;

    public ResolvedResource findIvyFileRef(DependencyDescriptor dd, ResolveData data) {
        ModuleRevisionId mrid = dd.getDependencyRevisionId();
        if (this.isM2compatible()) {
            mrid = this.convertM2IdForResourceSearch(mrid);
        }
        return this.findResourceUsingPatterns(mrid, this.ivyPatterns, DefaultArtifact.newIvyArtifact(mrid, data.getDate()), this.getRMDParser(dd, data), data.getDate());
    }

    public ResolvedResource findArtifactRef(Artifact artifact, Date date) {
        ModuleRevisionId mrid = artifact.getModuleRevisionId();
        if (this.isM2compatible()) {
            mrid = this.convertM2IdForResourceSearch(mrid);
        }
        return this.findResourceUsingPatterns(mrid, this.artifactPatterns, artifact, this.getDefaultRMDParser(artifact.getModuleRevisionId().getModuleId()), date);
    }

    public ResolvedResource findResource(ResolvedResource[] rress, ResourceMDParser rmdparser, ModuleRevisionId mrid, Date date) {
        if (this.isM2compatible()) {
            mrid = this.convertM2ResourceSearchIdToNormal(mrid);
        }
        return super.findResource(rress, rmdparser, mrid, date);
    }

    protected ResolvedResource findResourceUsingPatterns(ModuleRevisionId moduleRevision, List patternList, Artifact artifact, ResourceMDParser rmdparser, Date date) {
        ArrayList<ResolvedResource> resolvedResources = new ArrayList<ResolvedResource>();
        HashSet<String> foundRevisions = new HashSet<String>();
        boolean dynamic = this.getSettings().getVersionMatcher().isDynamic(moduleRevision);
        boolean stop2 = false;
        Iterator iter = patternList.iterator();
        while (iter.hasNext() && !stop2) {
            String pattern2 = (String)iter.next();
            ResolvedResource rres = this.findResourceUsingPattern(moduleRevision, pattern2, artifact, rmdparser, date);
            if (rres == null || foundRevisions.contains(rres.getRevision())) continue;
            foundRevisions.add(rres.getRevision());
            resolvedResources.add(rres);
            stop2 = !dynamic;
        }
        if (resolvedResources.size() > 1) {
            ResolvedResource[] rress = resolvedResources.toArray(new ResolvedResource[resolvedResources.size()]);
            return this.findResource(rress, rmdparser, moduleRevision, date);
        }
        if (resolvedResources.size() == 1) {
            return (ResolvedResource)resolvedResources.get(0);
        }
        return null;
    }

    protected abstract ResolvedResource findResourceUsingPattern(ModuleRevisionId var1, String var2, Artifact var3, ResourceMDParser var4, Date var5);

    protected Collection findNames(Map tokenValues, String token) {
        HashSet names = new HashSet();
        names.addAll(this.findIvyNames(tokenValues, token));
        if (this.isAllownomd()) {
            names.addAll(this.findArtifactNames(tokenValues, token));
        }
        return names;
    }

    protected Collection findIvyNames(Map tokenValues, String token) {
        HashSet names = new HashSet();
        tokenValues = new HashMap<String, String>(tokenValues);
        tokenValues.put("artifact", "ivy");
        tokenValues.put("type", "ivy");
        tokenValues.put("ext", "xml");
        if (this.isM2compatible()) {
            this.convertM2TokenValuesForResourceSearch(tokenValues);
        }
        this.findTokenValues(names, this.getIvyPatterns(), tokenValues, token);
        this.filterNames(names);
        return names;
    }

    protected Collection findArtifactNames(Map tokenValues, String token) {
        HashSet names = new HashSet();
        tokenValues = new HashMap(tokenValues);
        tokenValues.put("artifact", tokenValues.get("module"));
        tokenValues.put("type", "jar");
        tokenValues.put("ext", "jar");
        if (this.isM2compatible()) {
            this.convertM2TokenValuesForResourceSearch(tokenValues);
        }
        this.findTokenValues(names, this.getArtifactPatterns(), tokenValues, token);
        this.filterNames(names);
        return names;
    }

    public Map[] listTokenValues(String[] tokens, Map criteria) {
        LinkedHashSet result2 = new LinkedHashSet();
        List ivyPatterns = this.getIvyPatterns();
        HashMap<String, String> tokenValues = new HashMap<String, String>(criteria);
        tokenValues.put("type", "ivy");
        tokenValues.put("ext", this.getModuleDescriptorExtension());
        if (this.isM2compatible()) {
            this.convertM2TokenValuesForResourceSearch(tokenValues);
        }
        for (String ivyPattern : ivyPatterns) {
            result2.addAll(this.resolveTokenValues(tokens, ivyPattern, tokenValues, false));
        }
        if (this.isAllownomd()) {
            List artifactPatterns = this.getArtifactPatterns();
            tokenValues = new HashMap(criteria);
            tokenValues.put("type", "jar");
            tokenValues.put("ext", "jar");
            if (this.isM2compatible()) {
                this.convertM2TokenValuesForResourceSearch(tokenValues);
            }
            for (String artifactPattern : artifactPatterns) {
                result2.addAll(this.resolveTokenValues(tokens, artifactPattern, tokenValues, true));
            }
        }
        return result2.toArray(new Map[result2.size()]);
    }

    protected String getModuleDescriptorExtension() {
        return "xml";
    }

    private Set resolveTokenValues(String[] tokens, String pattern2, Map criteria, boolean noMd) {
        String[] values2;
        LinkedHashSet result2 = new LinkedHashSet();
        HashSet<String> tokenSet = new HashSet<String>(Arrays.asList(tokens));
        HashMap tokenValues = new HashMap();
        for (Map.Entry entry : criteria.entrySet()) {
            Object key = entry.getKey();
            Object value2 = entry.getValue();
            if (!(value2 instanceof String)) continue;
            tokenValues.put(key, value2);
        }
        if (tokenSet.isEmpty()) {
            result2.add(tokenValues);
            return result2;
        }
        String partiallyResolvedPattern = IvyPatternHelper.substituteTokens(pattern2, tokenValues);
        String token = IvyPatternHelper.getFirstToken(partiallyResolvedPattern);
        if (token == null && this.exist(partiallyResolvedPattern)) {
            result2.add(tokenValues);
            return result2;
        }
        tokenSet.remove(token);
        Matcher matcher = null;
        Object criteriaForToken = criteria.get(token);
        if (criteriaForToken instanceof Matcher) {
            matcher = (Matcher)criteriaForToken;
        }
        if ((values2 = this.listTokenValues(partiallyResolvedPattern, token)) == null) {
            return result2;
        }
        ArrayList<String> vals = new ArrayList<String>(Arrays.asList(values2));
        this.filterNames(vals);
        for (String value3 : vals) {
            if (matcher != null && !matcher.matches(value3)) continue;
            tokenValues.put(token, value3);
            String moreResolvedPattern = IvyPatternHelper.substituteTokens(partiallyResolvedPattern, tokenValues);
            HashMap<String, String> newCriteria = new HashMap<String, String>(criteria);
            newCriteria.put(token, value3);
            if (noMd && "artifact".equals(token)) {
                newCriteria.put("module", value3);
            } else if (noMd && "module".equals(token)) {
                newCriteria.put("artifact", value3);
            }
            result2.addAll(this.resolveTokenValues(tokenSet.toArray(new String[tokenSet.size()]), moreResolvedPattern, newCriteria, noMd));
        }
        return result2;
    }

    protected abstract String[] listTokenValues(String var1, String var2);

    protected abstract boolean exist(String var1);

    protected void findTokenValues(Collection names, List patterns, Map tokenValues, String token) {
    }

    public void addIvyPattern(String pattern2) {
        this.ivyPatterns.add(pattern2);
    }

    public void addArtifactPattern(String pattern2) {
        this.artifactPatterns.add(pattern2);
    }

    public List getIvyPatterns() {
        return Collections.unmodifiableList(this.ivyPatterns);
    }

    public List getArtifactPatterns() {
        return Collections.unmodifiableList(this.artifactPatterns);
    }

    protected void setIvyPatterns(List patterns) {
        this.ivyPatterns = patterns;
    }

    protected void setArtifactPatterns(List patterns) {
        this.artifactPatterns = patterns;
    }

    public void addConfiguredIvy(IvyPattern p) {
        this.ivyPatterns.add(p.getPattern());
    }

    public void addConfiguredArtifact(IvyPattern p) {
        this.artifactPatterns.add(p.getPattern());
    }

    public void dumpSettings() {
        String p;
        super.dumpSettings();
        Message.debug("\t\tm2compatible: " + this.isM2compatible());
        Message.debug("\t\tivy patterns:");
        ListIterator iter = this.getIvyPatterns().listIterator();
        while (iter.hasNext()) {
            p = (String)iter.next();
            Message.debug("\t\t\t" + p);
        }
        Message.debug("\t\tartifact patterns:");
        iter = this.getArtifactPatterns().listIterator();
        while (iter.hasNext()) {
            p = (String)iter.next();
            Message.debug("\t\t\t" + p);
        }
    }

    public boolean isM2compatible() {
        return this.m2compatible;
    }

    public void setM2compatible(boolean compatible) {
        this.m2compatible = compatible;
    }

    protected ModuleRevisionId convertM2ResourceSearchIdToNormal(ModuleRevisionId mrid) {
        if (mrid.getOrganisation() == null || mrid.getOrganisation().indexOf(47) == -1) {
            return mrid;
        }
        return ModuleRevisionId.newInstance(mrid.getOrganisation().replace('/', '.'), mrid.getName(), mrid.getBranch(), mrid.getRevision(), mrid.getQualifiedExtraAttributes());
    }

    protected ModuleRevisionId convertM2IdForResourceSearch(ModuleRevisionId mrid) {
        if (mrid.getOrganisation() == null || mrid.getOrganisation().indexOf(46) == -1) {
            return mrid;
        }
        return ModuleRevisionId.newInstance(mrid.getOrganisation().replace('.', '/'), mrid.getName(), mrid.getBranch(), mrid.getRevision(), mrid.getQualifiedExtraAttributes());
    }

    protected String convertM2OrganizationForResourceSearch(String org) {
        return org.replace('.', '/');
    }

    protected void convertM2TokenValuesForResourceSearch(Map tokenValues) {
        if (tokenValues.get("organisation") instanceof String) {
            tokenValues.put("organisation", this.convertM2OrganizationForResourceSearch((String)tokenValues.get("organisation")));
        }
    }
}

