/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository.vfs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.impl.StandardFileSystemManager;
import org.apache.ivy.plugins.repository.AbstractRepository;
import org.apache.ivy.plugins.repository.RepositoryCopyProgressListener;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.vfs.VfsResource;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;

public class VfsRepository
extends AbstractRepository {
    private static final String IVY_VFS_CONFIG = "ivy_vfs.xml";
    private StandardFileSystemManager manager = null;
    private final CopyProgressListener progress = new RepositoryCopyProgressListener(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileSystemManager getVFSManager() throws IOException {
        VfsRepository vfsRepository = this;
        synchronized (vfsRepository) {
            if (this.manager == null) {
                this.manager = this.createVFSManager();
            }
        }
        return this.manager;
    }

    private StandardFileSystemManager createVFSManager() throws IOException {
        StandardFileSystemManager result2 = null;
        try {
            result2 = new StandardFileSystemManager(){

                protected void configurePlugins() throws FileSystemException {
                }
            };
            result2.setConfiguration(this.getClass().getResource(IVY_VFS_CONFIG));
            result2.init();
            Message.verbose("Available VFS schemes...");
            Object[] schemes = result2.getSchemes();
            Arrays.sort(schemes);
            for (int i = 0; i < schemes.length; ++i) {
                Message.verbose("VFS Supported Scheme: " + (String)schemes[i]);
            }
        }
        catch (FileSystemException e2) {
            Message.error("Unable to initialize VFS repository manager!");
            Message.error(e2.getLocalizedMessage());
            IOException error = new IOException(e2.getLocalizedMessage());
            error.initCause(e2);
            throw error;
        }
        return result2;
    }

    protected void finalize() {
        if (this.manager != null) {
            this.manager.close();
            this.manager = null;
        }
    }

    public Resource getResource(String vfsURI) throws IOException {
        return new VfsResource(vfsURI, this.getVFSManager());
    }

    public void get(String srcVfsURI, File destination) throws IOException {
        VfsResource src = new VfsResource(srcVfsURI, this.getVFSManager());
        this.fireTransferInitiated(src, 5);
        try {
            FileContent content = src.getContent();
            if (content == null) {
                throw new IllegalArgumentException("invalid vfs uri " + srcVfsURI + ": no content found");
            }
            FileUtil.copy(content.getInputStream(), destination, this.progress);
        }
        catch (IOException ex) {
            this.fireTransferError(ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            this.fireTransferError(ex);
            throw ex;
        }
    }

    public List list(String vfsURI) throws IOException {
        ArrayList<String> list2 = new ArrayList<String>();
        Message.debug("list called for URI" + vfsURI);
        FileObject resourceImpl = this.getVFSManager().resolveFile(vfsURI);
        Message.debug("resourceImpl=" + resourceImpl.toString());
        Message.debug("resourceImpl.exists()" + resourceImpl.exists());
        Message.debug("resourceImpl.getType()" + resourceImpl.getType());
        Message.debug("FileType.FOLDER" + FileType.FOLDER);
        if (resourceImpl != null && resourceImpl.exists() && resourceImpl.getType() == FileType.FOLDER) {
            FileObject[] children2 = resourceImpl.getChildren();
            for (int i = 0; i < children2.length; ++i) {
                FileObject child = children2[i];
                Message.debug("child " + i + child.getName().getURI());
                list2.add(VfsResource.normalize(child.getName().getURI()));
            }
        }
        return list2;
    }

    public void put(File source, String vfsURI, boolean overwrite) throws IOException {
        VfsResource dest = new VfsResource(vfsURI, this.getVFSManager());
        this.fireTransferInitiated(dest, 6);
        if (dest.physicallyExists() && !overwrite) {
            throw new IOException("Cannot copy. Destination file: " + dest.getName() + " exists and overwrite not set.");
        }
        if (dest.getContent() == null) {
            throw new IllegalArgumentException("invalid vfs uri " + vfsURI + " to put data to: resource has no content");
        }
        FileUtil.copy((InputStream)new FileInputStream(source), dest.getContent().getOutputStream(), this.progress);
    }
}

