/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository.url;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.ivy.plugins.repository.AbstractRepository;
import org.apache.ivy.plugins.repository.BasicResource;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.util.Message;

public class ChainedRepository
extends AbstractRepository {
    private List repositories;

    public void setRepositories(List repositories2) {
        this.repositories = repositories2;
    }

    public Resource getResource(String source) throws IOException {
        for (Repository repository2 : this.repositories) {
            this.logTry(repository2);
            try {
                Resource r = repository2.getResource(source);
                if (r == null || !r.exists()) continue;
                this.logSuccess(repository2);
                return r;
            }
            catch (Exception e2) {
                this.logFailed(repository2, e2);
            }
        }
        return new BasicResource(source, false, 0L, 0L, true);
    }

    public void get(String source, File destination) throws IOException {
        for (Repository repository2 : this.repositories) {
            this.logTry(repository2);
            boolean ok = false;
            try {
                repository2.get(source, destination);
                ok = true;
            }
            catch (Exception e2) {
                this.logFailed(repository2, e2);
            }
            if (!ok) continue;
            this.logSuccess(repository2);
            return;
        }
        throw this.newIOEFail("copy " + source + " into " + destination);
    }

    public List list(String parent2) throws IOException {
        for (Repository repository2 : this.repositories) {
            this.logTry(repository2);
            try {
                List list2 = repository2.list(parent2);
                if (list2 == null) continue;
                this.logSuccess(repository2);
                return list2;
            }
            catch (Exception e2) {
                this.logFailed(repository2, e2);
            }
        }
        throw this.newIOEFail("list contents in " + parent2);
    }

    private void logTry(Repository repository2) {
        Message.debug("Mirrored repository " + this.getName() + ": trying " + repository2.getName());
    }

    private void logFailed(Repository repository2, Exception e2) {
        Message.warn("Mirrored repository " + this.getName() + ": " + repository2.getName() + " is not available", e2);
        Message.warn("Trying the next one in the mirror list...");
    }

    private void logSuccess(Repository repository2) {
        Message.debug("Mirrored repository " + this.getName() + ": success with " + repository2.getName());
    }

    private IOException newIOEFail(String action) {
        return new IOException("Mirrored repository " + this.getName() + ": fail to " + action + " with every listed mirror");
    }
}

