/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.ivy.plugins.repository.ssh.RemoteScpException;

public class Scp {
    private static final int MODE_LENGTH = 4;
    private static final int SEND_FILE_BUFFER_LENGTH = 40000;
    private static final int SEND_BYTES_BUFFER_LENGTH = 512;
    private static final int MIN_TLINE_LENGTH = 8;
    private static final int CLINE_SPACE_INDEX2 = 5;
    private static final int CLINE_SPACE_INDEX1 = 4;
    private static final int MIN_C_LINE_LENGTH = 8;
    private static final int DEFAULT_LINE_BUFFER_LENGTH = 30;
    private static final int BUFFER_SIZE = 65536;
    private static final int MAX_SCP_LINE_LENGTH = 8192;
    private Session session;

    public Scp(Session session) {
        if (session == null) {
            throw new IllegalArgumentException("Cannot accept null argument!");
        }
        this.session = session;
    }

    private void readResponse(InputStream is) throws IOException, RemoteScpException {
        int c2 = is.read();
        if (c2 == 0) {
            return;
        }
        if (c2 == -1) {
            throw new RemoteScpException("Remote scp terminated unexpectedly.");
        }
        if (c2 != 1 && c2 != 2) {
            throw new RemoteScpException("Remote scp sent illegal error code.");
        }
        if (c2 == 2) {
            throw new RemoteScpException("Remote scp terminated with error.");
        }
        String err2 = this.receiveLine(is);
        throw new RemoteScpException("Remote scp terminated with error (" + err2 + ").");
    }

    private String receiveLine(InputStream is) throws IOException, RemoteScpException {
        StringBuffer sb = new StringBuffer(30);
        while (true) {
            if (sb.length() > 8192) {
                throw new RemoteScpException("Remote scp sent a too long line");
            }
            int c2 = is.read();
            if (c2 < 0) {
                throw new RemoteScpException("Remote scp terminated unexpectedly.");
            }
            if (c2 == 10) break;
            sb.append((char)c2);
        }
        return sb.toString();
    }

    private void parseCLine(String line, FileInfo fileInfo) throws RemoteScpException {
        long len2;
        if (line.length() < 8) {
            throw new RemoteScpException("Malformed C line sent by remote SCP binary, line too short.");
        }
        if (line.charAt(4) != ' ' || line.charAt(5) == ' ') {
            throw new RemoteScpException("Malformed C line sent by remote SCP binary.");
        }
        int lengthNameSep = line.indexOf(32, 5);
        if (lengthNameSep == -1) {
            throw new RemoteScpException("Malformed C line sent by remote SCP binary.");
        }
        String lengthSubstring = line.substring(5, lengthNameSep);
        String nameSubstring = line.substring(lengthNameSep + 1);
        if (lengthSubstring.length() <= 0 || nameSubstring.length() <= 0) {
            throw new RemoteScpException("Malformed C line sent by remote SCP binary.");
        }
        if (6 + lengthSubstring.length() + nameSubstring.length() != line.length()) {
            throw new RemoteScpException("Malformed C line sent by remote SCP binary.");
        }
        try {
            len2 = Long.parseLong(lengthSubstring);
        }
        catch (NumberFormatException e2) {
            throw new RemoteScpException("Malformed C line sent by remote SCP binary, cannot parse file length.");
        }
        if (len2 < 0L) {
            throw new RemoteScpException("Malformed C line sent by remote SCP binary, illegal file length.");
        }
        fileInfo.setLength(len2);
        fileInfo.setFilename(nameSubstring);
    }

    private void parseTLine(String line, FileInfo fileInfo) throws RemoteScpException {
        long secondMsec;
        long atime;
        long firstMsec;
        long modtime;
        if (line.length() < 8) {
            throw new RemoteScpException("Malformed T line sent by remote SCP binary, line too short.");
        }
        int firstMsecBegin = line.indexOf(" ") + 1;
        if (firstMsecBegin == 0 || firstMsecBegin >= line.length()) {
            throw new RemoteScpException("Malformed T line sent by remote SCP binary, line not enough data.");
        }
        int atimeBegin = line.indexOf(" ", firstMsecBegin + 1) + 1;
        if (atimeBegin == 0 || atimeBegin >= line.length()) {
            throw new RemoteScpException("Malformed T line sent by remote SCP binary, line not enough data.");
        }
        int secondMsecBegin = line.indexOf(" ", atimeBegin + 1) + 1;
        if (secondMsecBegin == 0 || secondMsecBegin >= line.length()) {
            throw new RemoteScpException("Malformed T line sent by remote SCP binary, line not enough data.");
        }
        try {
            modtime = Long.parseLong(line.substring(0, firstMsecBegin - 1));
            firstMsec = Long.parseLong(line.substring(firstMsecBegin, atimeBegin - 1));
            atime = Long.parseLong(line.substring(atimeBegin, secondMsecBegin - 1));
            secondMsec = Long.parseLong(line.substring(secondMsecBegin));
        }
        catch (NumberFormatException e2) {
            throw new RemoteScpException("Malformed C line sent by remote SCP binary, cannot parse file length.");
        }
        if (modtime < 0L || firstMsec < 0L || atime < 0L || secondMsec < 0L) {
            throw new RemoteScpException("Malformed C line sent by remote SCP binary, illegal file length.");
        }
        fileInfo.setLastModified(modtime);
    }

    private void sendFile(Channel channel, String localFile, String remoteName, String mode2) throws IOException, RemoteScpException {
        byte[] buffer2 = new byte[65536];
        BufferedOutputStream os = new BufferedOutputStream(channel.getOutputStream(), 40000);
        BufferedInputStream is = new BufferedInputStream(channel.getInputStream(), 512);
        try {
            if (channel.isConnected()) {
                channel.start();
            } else {
                channel.connect();
            }
        }
        catch (JSchException e1) {
            throw (IOException)new IOException("Channel connection problems").initCause(e1);
        }
        this.readResponse(is);
        File f2 = new File(localFile);
        long remain = f2.length();
        String cMode = mode2;
        if (cMode == null) {
            cMode = "0600";
        }
        String cline = "C" + cMode + " " + remain + " " + remoteName + "\n";
        ((OutputStream)os).write(cline.getBytes());
        ((OutputStream)os).flush();
        this.readResponse(is);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f2);
            while (remain > 0L) {
                int trans = remain > (long)buffer2.length ? buffer2.length : (int)remain;
                if (fis.read(buffer2, 0, trans) != trans) {
                    throw new IOException("Cannot read enough from local file " + localFile);
                }
                ((OutputStream)os).write(buffer2, 0, trans);
                remain -= (long)trans;
            }
            fis.close();
        }
        catch (IOException e2) {
            if (fis != null) {
                fis.close();
            }
            throw e2;
        }
        ((OutputStream)os).write(0);
        ((OutputStream)os).flush();
        this.readResponse(is);
        ((OutputStream)os).write("E\n".getBytes());
        ((OutputStream)os).flush();
    }

    private FileInfo receiveStream(Channel channel, String file2, OutputStream targetStream) throws IOException, RemoteScpException {
        String line;
        int c2;
        byte[] buffer2 = new byte[65536];
        OutputStream os = channel.getOutputStream();
        InputStream is = channel.getInputStream();
        try {
            if (channel.isConnected()) {
                channel.start();
            } else {
                channel.connect();
            }
        }
        catch (JSchException e1) {
            throw (IOException)new IOException("Channel connection problems").initCause(e1);
        }
        os.write(0);
        os.flush();
        FileInfo fileInfo = new FileInfo();
        while (true) {
            if ((c2 = is.read()) < 0) {
                throw new RemoteScpException("Remote scp terminated unexpectedly.");
            }
            line = this.receiveLine(is);
            if (c2 != 84) break;
            this.parseTLine(line, fileInfo);
            os.write(0);
            os.flush();
        }
        if (c2 == 1 || c2 == 2) {
            throw new RemoteScpException("Remote SCP error: " + line);
        }
        if (c2 != 67) {
            throw new RemoteScpException("Remote SCP error: " + (char)c2 + line);
        }
        this.parseCLine(line, fileInfo);
        if (targetStream != null) {
            os.write(0);
            os.flush();
            try {
                int thisTimeReceived;
                for (long remain = fileInfo.getLength(); remain > 0L; remain -= (long)thisTimeReceived) {
                    int trans = remain > (long)buffer2.length ? buffer2.length : (int)remain;
                    thisTimeReceived = is.read(buffer2, 0, trans);
                    if (thisTimeReceived < 0) {
                        throw new IOException("Remote scp terminated connection unexpectedly");
                    }
                    targetStream.write(buffer2, 0, thisTimeReceived);
                }
                targetStream.close();
            }
            catch (IOException e2) {
                if (targetStream != null) {
                    targetStream.close();
                }
                throw e2;
            }
            this.readResponse(is);
            os.write(0);
            os.flush();
        }
        return fileInfo;
    }

    private ChannelExec getExecChannel() throws JSchException {
        ChannelExec channel = (ChannelExec)this.session.openChannel("exec");
        return channel;
    }

    public void put(String localFile, String remoteTargetDir, String remoteTargetName, String mode2) throws IOException, RemoteScpException {
        ChannelExec channel = null;
        if (localFile == null || remoteTargetName == null) {
            throw new IllegalArgumentException("Null argument.");
        }
        if (mode2 != null) {
            if (mode2.length() != 4) {
                throw new IllegalArgumentException("Invalid mode.");
            }
            for (int i = 0; i < mode2.length(); ++i) {
                if (Character.isDigit(mode2.charAt(i))) continue;
                throw new IllegalArgumentException("Invalid mode.");
            }
        }
        String cmd = "scp -t ";
        if (mode2 != null) {
            cmd = cmd + "-p ";
        }
        if (remoteTargetDir != null && remoteTargetDir.length() > 0) {
            cmd = cmd + "-d " + remoteTargetDir;
        }
        try {
            channel = this.getExecChannel();
            channel.setCommand(cmd);
            this.sendFile((Channel)channel, localFile, remoteTargetName, mode2);
            channel.disconnect();
        }
        catch (JSchException e2) {
            if (channel != null) {
                channel.disconnect();
            }
            throw (IOException)new IOException("Error during SCP transfer." + e2.getMessage()).initCause(e2);
        }
    }

    public void get(String remoteFile, String localTarget) throws IOException, RemoteScpException {
        File f2 = new File(localTarget);
        FileOutputStream fop = new FileOutputStream(f2);
        this.get(remoteFile, fop);
    }

    public void get(String remoteFile, OutputStream localTarget) throws IOException, RemoteScpException {
        ChannelExec channel = null;
        if (remoteFile == null || localTarget == null) {
            throw new IllegalArgumentException("Null argument.");
        }
        String cmd = "scp -p -f " + remoteFile;
        try {
            channel = this.getExecChannel();
            channel.setCommand(cmd);
            this.receiveStream((Channel)channel, remoteFile, localTarget);
            channel.disconnect();
        }
        catch (JSchException e2) {
            if (channel != null) {
                channel.disconnect();
            }
            throw (IOException)new IOException("Error during SCP transfer." + e2.getMessage()).initCause(e2);
        }
    }

    public FileInfo getFileinfo(String remoteFile) throws IOException, RemoteScpException {
        ChannelExec channel = null;
        FileInfo fileInfo = null;
        if (remoteFile == null) {
            throw new IllegalArgumentException("Null argument.");
        }
        String cmd = "scp -p -f \"" + remoteFile + "\"";
        try {
            channel = this.getExecChannel();
            channel.setCommand(cmd);
            fileInfo = this.receiveStream((Channel)channel, remoteFile, null);
            channel.disconnect();
        }
        catch (JSchException e2) {
            throw (IOException)new IOException("Error during SCP transfer." + e2.getMessage()).initCause(e2);
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
        return fileInfo;
    }

    public class FileInfo {
        private String filename;
        private long length;
        private long lastModified;

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public String getFilename() {
            return this.filename;
        }

        public void setLength(long length2) {
            this.length = length2;
        }

        public long getLength() {
            return this.length;
        }

        public void setLastModified(long lastModified) {
            this.lastModified = lastModified;
        }

        public long getLastModified() {
            return this.lastModified;
        }
    }
}

