/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.ivy.plugins.repository.BasicResource;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.sftp.SFTPResource;
import org.apache.ivy.plugins.repository.ssh.AbstractSshBasedRepository;
import org.apache.ivy.plugins.repository.ssh.SshCache;
import org.apache.ivy.util.Message;

public class SFTPRepository
extends AbstractSshBasedRepository {
    private static final long MILLIS_PER_SECOND = 1000L;

    public Resource getResource(String source) {
        return new SFTPResource(this, source);
    }

    public Resource resolveResource(String path2) {
        try {
            ChannelSftp c2 = this.getSftpChannel(path2);
            Vector r = c2.ls(this.getPath(path2));
            if (r != null) {
                for (Object obj2 : r) {
                    if (!(obj2 instanceof ChannelSftp.LsEntry)) continue;
                    ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)obj2;
                    SftpATTRS attrs = entry.getAttrs();
                    return new BasicResource(path2, true, attrs.getSize(), (long)attrs.getMTime() * 1000L, false);
                }
            }
        }
        catch (Exception e2) {
            Message.debug("Error while resolving resource " + path2, e2);
        }
        return new BasicResource(path2, false, 0L, 0L, false);
    }

    public InputStream openStream(SFTPResource resource) throws IOException {
        ChannelSftp c2 = this.getSftpChannel(resource.getName());
        try {
            String path2 = this.getPath(resource.getName());
            return c2.get(path2);
        }
        catch (SftpException e2) {
            IOException ex = new IOException("impossible to open stream for " + resource + " on " + this.getHost() + (e2.getMessage() != null ? ": " + e2.getMessage() : ""));
            ex.initCause(e2);
            throw ex;
        }
        catch (URISyntaxException e3) {
            IOException ex = new IOException("impossible to open stream for " + resource + " on " + this.getHost() + (e3.getMessage() != null ? ": " + e3.getMessage() : ""));
            ex.initCause(e3);
            throw ex;
        }
    }

    public void get(String source, File destination) throws IOException {
        this.fireTransferInitiated(this.getResource(source), 5);
        ChannelSftp c2 = this.getSftpChannel(source);
        try {
            String path2 = this.getPath(source);
            c2.get(path2, destination.getAbsolutePath(), (SftpProgressMonitor)new MyProgressMonitor());
        }
        catch (SftpException e2) {
            IOException ex = new IOException("impossible to get " + source + " on " + this.getHost() + (e2.getMessage() != null ? ": " + e2.getMessage() : ""));
            ex.initCause(e2);
            throw ex;
        }
        catch (URISyntaxException e3) {
            IOException ex = new IOException("impossible to get " + source + " on " + this.getHost() + (e3.getMessage() != null ? ": " + e3.getMessage() : ""));
            ex.initCause(e3);
            throw ex;
        }
    }

    public void put(File source, String destination, boolean overwrite) throws IOException {
        this.fireTransferInitiated(this.getResource(destination), 6);
        ChannelSftp c2 = this.getSftpChannel(destination);
        try {
            String path2 = this.getPath(destination);
            if (!overwrite && this.checkExistence(path2, c2)) {
                throw new IOException("destination file exists and overwrite == false");
            }
            if (path2.indexOf(47) != -1) {
                this.mkdirs(path2.substring(0, path2.lastIndexOf(47)), c2);
            }
            c2.put(source.getAbsolutePath(), path2, (SftpProgressMonitor)new MyProgressMonitor());
        }
        catch (SftpException e2) {
            IOException ex = new IOException(e2.getMessage());
            ex.initCause(e2);
            throw ex;
        }
        catch (URISyntaxException e3) {
            IOException ex = new IOException(e3.getMessage());
            ex.initCause(e3);
            throw ex;
        }
    }

    private void mkdirs(String directory, ChannelSftp c2) throws IOException, SftpException {
        try {
            SftpATTRS att = c2.stat(directory);
            if (att != null && att.isDir()) {
                return;
            }
        }
        catch (SftpException ex) {
            if (directory.indexOf(47) != -1) {
                this.mkdirs(directory.substring(0, directory.lastIndexOf(47)), c2);
            }
            c2.mkdir(directory);
        }
    }

    private String getPath(String sftpURI) throws URISyntaxException {
        String result2 = null;
        URI uri = new URI(sftpURI);
        result2 = uri.getPath();
        if (result2 == null) {
            throw new URISyntaxException(sftpURI, "Missing path in URI.");
        }
        return result2;
    }

    public List list(String parent2) throws IOException {
        try {
            ChannelSftp c2 = this.getSftpChannel(parent2);
            String path2 = this.getPath(parent2);
            Vector r = c2.ls(path2);
            if (r != null) {
                if (!path2.endsWith("/")) {
                    path2 = parent2 + "/";
                }
                ArrayList<String> result2 = new ArrayList<String>();
                for (Object obj2 : r) {
                    ChannelSftp.LsEntry entry;
                    if (!(obj2 instanceof ChannelSftp.LsEntry) || ".".equals((entry = (ChannelSftp.LsEntry)obj2).getFilename()) || "..".equals(entry.getFilename())) continue;
                    result2.add(path2 + entry.getFilename());
                }
                return result2;
            }
        }
        catch (SftpException e2) {
            IOException ex = new IOException("Failed to return a listing for '" + parent2 + "'");
            ex.initCause(e2);
            throw ex;
        }
        catch (URISyntaxException usex) {
            IOException ex = new IOException("Failed to return a listing for '" + parent2 + "'");
            ex.initCause(usex);
            throw ex;
        }
        return null;
    }

    private boolean checkExistence(String file2, ChannelSftp channel) throws IOException, SftpException {
        try {
            return channel.stat(file2) != null;
        }
        catch (SftpException ex) {
            return false;
        }
    }

    private ChannelSftp getSftpChannel(String pathOrUri) throws IOException {
        Session session = this.getSession(pathOrUri);
        String host = session.getHost();
        ChannelSftp channel = SshCache.getInstance().getChannelSftp(session);
        if (channel == null) {
            try {
                channel = (ChannelSftp)session.openChannel("sftp");
                channel.connect();
                Message.verbose(":: SFTP :: connected to " + host + "!");
                SshCache.getInstance().attachChannelSftp(session, channel);
            }
            catch (JSchException e2) {
                IOException ex = new IOException(e2.getMessage());
                ex.initCause(e2);
                throw ex;
            }
        }
        return channel;
    }

    protected String getRepositoryScheme() {
        return "sftp";
    }

    private final class MyProgressMonitor
    implements SftpProgressMonitor {
        private long totalLength;

        private MyProgressMonitor() {
        }

        public void init(int op, String src, String dest, long max2) {
            this.totalLength = max2;
            SFTPRepository.this.fireTransferStarted(max2);
        }

        public void end() {
            SFTPRepository.this.fireTransferCompleted(this.totalLength);
        }

        public boolean count(long count2) {
            SFTPRepository.this.fireTransferProgress(count2);
            return true;
        }
    }
}

