/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository.jar;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.ivy.plugins.repository.AbstractRepository;
import org.apache.ivy.plugins.repository.RepositoryCopyProgressListener;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.jar.JarResource;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.FileUtil;

public class JarRepository
extends AbstractRepository {
    private RepositoryCopyProgressListener progress = new RepositoryCopyProgressListener(this);
    private JarFile jarFile;

    public void setJarFile(JarFile jarFile) {
        this.jarFile = jarFile;
    }

    public Resource getResource(String source) throws IOException {
        return new JarResource(this.jarFile, source);
    }

    protected RepositoryCopyProgressListener getProgressListener() {
        return this.progress;
    }

    public void get(String source, File destination) throws IOException {
        this.fireTransferInitiated(this.getResource(source), 5);
        try {
            ZipEntry entry = this.jarFile.getEntry(source);
            if (entry == null) {
                throw new FileNotFoundException();
            }
            this.getProgressListener().setTotalLength(new Long(entry.getSize()));
            FileUtil.copy(this.jarFile.getInputStream(entry), destination, (CopyProgressListener)this.getProgressListener());
        }
        catch (IOException ex) {
            this.fireTransferError(ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            this.fireTransferError(ex);
            throw ex;
        }
        finally {
            this.getProgressListener().setTotalLength(null);
        }
    }

    public List list(String parent2) throws IOException {
        ZipEntry parentEntry = this.jarFile.getEntry(parent2);
        if (parentEntry == null || !parentEntry.isDirectory()) {
            return null;
        }
        ArrayList<String> children2 = new ArrayList<String>();
        Enumeration<JarEntry> entries = this.jarFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.getName().startsWith(parent2) || !entry.getName().equals(parentEntry.getName())) continue;
            children2.add(entry.getName());
        }
        return children2;
    }
}

