/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.report;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.module.descriptor.License;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.ConfigurationResolveReport;
import org.apache.ivy.core.report.MetadataArtifactDownloadReport;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.IvyNodeCallers;
import org.apache.ivy.core.resolve.IvyNodeEviction;
import org.apache.ivy.util.DateUtil;
import org.apache.ivy.util.StringUtils;
import org.apache.ivy.util.XMLHelper;

public class XmlReportWriter {
    static final String REPORT_ENCODING = "UTF-8";

    public void output(ConfigurationResolveReport report, OutputStream stream2) {
        this.output(report, new String[]{report.getConfiguration()}, stream2);
    }

    public void output(ConfigurationResolveReport report, String[] confs, OutputStream stream2) {
        OutputStreamWriter encodedOutStream;
        try {
            encodedOutStream = new OutputStreamWriter(stream2, REPORT_ENCODING);
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException("UTF-8 is not known on your jvm", e2);
        }
        PrintWriter out2 = new PrintWriter(new BufferedWriter(encodedOutStream));
        ModuleRevisionId mrid = report.getModuleDescriptor().getModuleRevisionId();
        out2.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out2.println("<?xml-stylesheet type=\"text/xsl\" href=\"ivy-report.xsl\"?>");
        out2.println("<ivy-report version=\"1.0\">");
        out2.println("\t<info");
        out2.println("\t\torganisation=\"" + XMLHelper.escape(mrid.getOrganisation()) + "\"");
        out2.println("\t\tmodule=\"" + XMLHelper.escape(mrid.getName()) + "\"");
        out2.println("\t\trevision=\"" + XMLHelper.escape(mrid.getRevision()) + "\"");
        if (mrid.getBranch() != null) {
            out2.println("\t\tbranch=\"" + XMLHelper.escape(mrid.getBranch()) + "\"");
        }
        Map extraAttributes2 = mrid.getExtraAttributes();
        for (Map.Entry entry : extraAttributes2.entrySet()) {
            out2.println("\t\textra-" + entry.getKey() + "=\"" + XMLHelper.escape(entry.getValue().toString()) + "\"");
        }
        out2.println("\t\tconf=\"" + XMLHelper.escape(report.getConfiguration()) + "\"");
        out2.println("\t\tconfs=\"" + XMLHelper.escape(StringUtils.join(confs, ", ")) + "\"");
        out2.println("\t\tdate=\"" + DateUtil.format(report.getDate()) + "\"/>");
        out2.println("\t<dependencies>");
        ArrayList<ModuleRevisionId> dependencies2 = new ArrayList<ModuleRevisionId>(report.getModuleRevisionIds());
        for (ModuleId mid : report.getModuleIds()) {
            out2.println("\t\t<module organisation=\"" + XMLHelper.escape(mid.getOrganisation()) + "\"" + " name=\"" + XMLHelper.escape(mid.getName()) + "\">");
            for (IvyNode dep : report.getNodes(mid)) {
                this.ouputRevision(report, out2, dependencies2, dep);
            }
            out2.println("\t\t</module>");
        }
        out2.println("\t</dependencies>");
        out2.println("</ivy-report>");
        out2.flush();
    }

    private void ouputRevision(ConfigurationResolveReport report, PrintWriter out2, List dependencies2, IvyNode dep) {
        ModuleDescriptor md = null;
        if (dep.getModuleRevision() != null) {
            md = dep.getModuleRevision().getDescriptor();
        }
        StringBuffer details = new StringBuffer();
        if (dep.isLoaded()) {
            details.append(" status=\"");
            details.append(XMLHelper.escape(dep.getDescriptor().getStatus()));
            details.append("\" pubdate=\"");
            details.append(DateUtil.format(new Date(dep.getPublication())));
            details.append("\" resolver=\"");
            details.append(XMLHelper.escape(dep.getModuleRevision().getResolver().getName()));
            details.append("\" artresolver=\"");
            details.append(XMLHelper.escape(dep.getModuleRevision().getArtifactResolver().getName()));
            details.append("\"");
        }
        if (dep.isEvicted(report.getConfiguration())) {
            IvyNodeEviction.EvictionData ed = dep.getEvictedData(report.getConfiguration());
            if (ed.getConflictManager() != null) {
                details.append(" evicted=\"").append(XMLHelper.escape(ed.getConflictManager().toString())).append("\"");
            } else {
                details.append(" evicted=\"transitive\"");
            }
            details.append(" evicted-reason=\"").append(XMLHelper.escape(ed.getDetail() == null ? "" : ed.getDetail())).append("\"");
        }
        if (dep.hasProblem()) {
            details.append(" error=\"").append(XMLHelper.escape(dep.getProblem().getMessage())).append("\"");
        }
        if (md != null && md.getHomePage() != null) {
            details.append(" homepage=\"").append(XMLHelper.escape(md.getHomePage())).append("\"");
        }
        Map extraAttributes2 = md != null ? md.getExtraAttributes() : dep.getResolvedId().getExtraAttributes();
        for (String attName : extraAttributes2.keySet()) {
            details.append(" extra-").append(attName).append("=\"").append(XMLHelper.escape(extraAttributes2.get(attName).toString())).append("\"");
        }
        String defaultValue = dep.getDescriptor() != null ? " default=\"" + dep.getDescriptor().isDefault() + "\"" : "";
        int position = dependencies2.indexOf(dep.getResolvedId());
        out2.println("\t\t\t<revision name=\"" + XMLHelper.escape(dep.getResolvedId().getRevision()) + "\"" + (dep.getResolvedId().getBranch() == null ? "" : " branch=\"" + XMLHelper.escape(dep.getResolvedId().getBranch()) + "\"") + details + " downloaded=\"" + dep.isDownloaded() + "\"" + " searched=\"" + dep.isSearched() + "\"" + defaultValue + " conf=\"" + this.toString(dep.getConfigurations(report.getConfiguration())) + "\"" + " position=\"" + position + "\">");
        if (md != null) {
            License[] licenses = md.getLicenses();
            for (int i = 0; i < licenses.length; ++i) {
                String lurl = licenses[i].getUrl() != null ? " url=\"" + XMLHelper.escape(licenses[i].getUrl()) + "\"" : "";
                out2.println("\t\t\t\t<license name=\"" + XMLHelper.escape(licenses[i].getName()) + "\"" + lurl + "/>");
            }
        }
        this.outputMetadataArtifact(out2, dep);
        this.outputEvictionInformation(report, out2, dep);
        this.outputCallers(report, out2, dep);
        this.outputArtifacts(report, out2, dep);
        out2.println("\t\t\t</revision>");
    }

    private void outputEvictionInformation(ConfigurationResolveReport report, PrintWriter out2, IvyNode dep) {
        IvyNodeEviction.EvictionData ed;
        Collection selected;
        if (dep.isEvicted(report.getConfiguration()) && (selected = (ed = dep.getEvictedData(report.getConfiguration())).getSelected()) != null) {
            for (IvyNode sel : selected) {
                out2.println("\t\t\t\t<evicted-by rev=\"" + XMLHelper.escape(sel.getResolvedId().getRevision()) + "\"/>");
            }
        }
    }

    private void outputMetadataArtifact(PrintWriter out2, IvyNode dep) {
        if (dep.getModuleRevision() != null) {
            ArtifactOrigin origin;
            MetadataArtifactDownloadReport madr = dep.getModuleRevision().getReport();
            out2.print("\t\t\t\t<metadata-artifact");
            out2.print(" status=\"" + XMLHelper.escape(madr.getDownloadStatus().toString()) + "\"");
            out2.print(" details=\"" + XMLHelper.escape(madr.getDownloadDetails()) + "\"");
            out2.print(" size=\"" + madr.getSize() + "\"");
            out2.print(" time=\"" + madr.getDownloadTimeMillis() + "\"");
            if (madr.getLocalFile() != null) {
                out2.print(" location=\"" + XMLHelper.escape(madr.getLocalFile().getAbsolutePath()) + "\"");
            }
            out2.print(" searched=\"" + madr.isSearched() + "\"");
            if (madr.getOriginalLocalFile() != null) {
                out2.print(" original-local-location=\"" + XMLHelper.escape(madr.getOriginalLocalFile().getAbsolutePath()) + "\"");
            }
            if ((origin = madr.getArtifactOrigin()) != null) {
                out2.print(" origin-is-local=\"" + String.valueOf(origin.isLocal()) + "\"");
                out2.print(" origin-location=\"" + XMLHelper.escape(origin.getLocation()) + "\"");
            }
            out2.println("/>");
        }
    }

    private void outputCallers(ConfigurationResolveReport report, PrintWriter out2, IvyNode dep) {
        IvyNodeCallers.Caller[] callers = dep.getCallers(report.getConfiguration());
        for (int i = 0; i < callers.length; ++i) {
            StringBuffer callerDetails = new StringBuffer();
            Map callerExtraAttributes = callers[i].getDependencyDescriptor().getExtraAttributes();
            for (String attName : callerExtraAttributes.keySet()) {
                callerDetails.append(" extra-").append(attName).append("=\"").append(XMLHelper.escape(callerExtraAttributes.get(attName).toString())).append("\"");
            }
            out2.println("\t\t\t\t<caller organisation=\"" + XMLHelper.escape(callers[i].getModuleRevisionId().getOrganisation()) + "\"" + " name=\"" + XMLHelper.escape(callers[i].getModuleRevisionId().getName()) + "\"" + " conf=\"" + XMLHelper.escape(this.toString(callers[i].getCallerConfigurations())) + "\"" + " rev=\"" + XMLHelper.escape(callers[i].getAskedDependencyId(dep.getData()).getRevision()) + "\"" + " rev-constraint-default=\"" + XMLHelper.escape(callers[i].getDependencyDescriptor().getDependencyRevisionId().getRevision()) + "\"" + " rev-constraint-dynamic=\"" + XMLHelper.escape(callers[i].getDependencyDescriptor().getDynamicConstraintDependencyRevisionId().getRevision()) + "\"" + " callerrev=\"" + XMLHelper.escape(callers[i].getModuleRevisionId().getRevision()) + "\"" + callerDetails + "/>");
        }
    }

    private void outputArtifacts(ConfigurationResolveReport report, PrintWriter out2, IvyNode dep) {
        ArtifactDownloadReport[] adr = report.getDownloadReports(dep.getResolvedId());
        out2.println("\t\t\t\t<artifacts>");
        for (int i = 0; i < adr.length; ++i) {
            ArtifactOrigin origin;
            out2.print("\t\t\t\t\t<artifact name=\"" + XMLHelper.escape(adr[i].getName()) + "\" type=\"" + XMLHelper.escape(adr[i].getType()) + "\" ext=\"" + XMLHelper.escape(adr[i].getExt()) + "\"");
            Map extraAttributes2 = adr[i].getArtifact().getExtraAttributes();
            for (String attName : extraAttributes2.keySet()) {
                out2.print(" extra-" + attName + "=\"" + XMLHelper.escape(extraAttributes2.get(attName).toString()) + "\"");
            }
            out2.print(" status=\"" + XMLHelper.escape(adr[i].getDownloadStatus().toString()) + "\"");
            out2.print(" details=\"" + XMLHelper.escape(adr[i].getDownloadDetails()) + "\"");
            out2.print(" size=\"" + adr[i].getSize() + "\"");
            out2.print(" time=\"" + adr[i].getDownloadTimeMillis() + "\"");
            if (adr[i].getLocalFile() != null) {
                out2.print(" location=\"" + XMLHelper.escape(adr[i].getLocalFile().getAbsolutePath()) + "\"");
            }
            if (adr[i].getUnpackedLocalFile() != null) {
                out2.print(" unpackedFile=\"" + XMLHelper.escape(adr[i].getUnpackedLocalFile().getAbsolutePath()) + "\"");
            }
            if ((origin = adr[i].getArtifactOrigin()) != null) {
                out2.println(">");
                out2.println("\t\t\t\t\t\t<origin-location is-local=\"" + String.valueOf(origin.isLocal()) + "\"" + " location=\"" + XMLHelper.escape(origin.getLocation()) + "\"/>");
                out2.println("\t\t\t\t\t</artifact>");
                continue;
            }
            out2.println("/>");
        }
        out2.println("\t\t\t\t</artifacts>");
    }

    private String toString(String[] strs) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < strs.length; ++i) {
            buf.append(strs[i]);
            if (i + 1 >= strs.length) continue;
            buf.append(", ");
        }
        return XMLHelper.escape(buf.toString());
    }
}

