/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.report;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.ConfigurationResolveReport;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.IvyNodeEviction;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.report.ReportOutputter;
import org.apache.ivy.util.Message;

public class LogReportOutputter
implements ReportOutputter {
    public String getName() {
        return "console";
    }

    public void output(ResolveReport report, ResolutionCacheManager cacheMgr, ResolveOptions options2) throws IOException {
        ArtifactDownloadReport[] errors2;
        IvyNode[] unresolved;
        String[] confs;
        IvyNode[] evicted;
        int i;
        IvySettings settings = IvyContext.getContext().getSettings();
        if (settings.logModulesInUse() && "default".equals(options2.getLog())) {
            Message.info("\t:: modules in use:");
            ArrayList dependencies2 = new ArrayList(report.getDependencies());
            Collections.sort(dependencies2);
            if (dependencies2.size() > 0) {
                String[] confs2 = report.getConfigurations();
                for (i = 0; i < dependencies2.size(); ++i) {
                    IvyNode node4 = (IvyNode)dependencies2.get(i);
                    if (node4.isCompletelyEvicted() || node4.hasProblem()) continue;
                    ArrayList<String> nodeConfs = new ArrayList<String>(confs2.length);
                    for (int j = 0; j < confs2.length; ++j) {
                        String conf = confs2[j];
                        if (!report.getConfigurationReport(conf).getModuleRevisionIds().contains(node4.getResolvedId())) continue;
                        nodeConfs.add(conf);
                    }
                    Message.info("\t" + node4 + " from " + node4.getModuleRevision().getResolver().getName() + " in " + nodeConfs);
                }
            }
        }
        if ((evicted = report.getEvictedNodes()).length > 0 && "default".equals(options2.getLog())) {
            Message.info("\t:: evicted modules:");
            for (int i2 = 0; i2 < evicted.length; ++i2) {
                Collection allEvictingNodes = evicted[i2].getAllEvictingNodesDetails();
                if (allEvictingNodes == null) {
                    Message.info("\t" + evicted[i2] + " transitively in " + Arrays.asList(evicted[i2].getEvictedConfs()));
                } else if (allEvictingNodes.isEmpty()) {
                    Message.info("\t" + evicted[i2] + " by [] (" + evicted[i2].getAllEvictingConflictManagers() + ") in " + Arrays.asList(evicted[i2].getEvictedConfs()));
                } else {
                    Message.info("\t" + evicted[i2] + " by " + allEvictingNodes + " in " + Arrays.asList(evicted[i2].getEvictedConfs()));
                }
                confs = evicted[i2].getEvictedConfs();
                for (int j = 0; j < confs.length; ++j) {
                    IvyNodeEviction.EvictionData evictedData = evicted[i2].getEvictedData(confs[j]);
                    if (evictedData.getParent() == null) continue;
                    Message.verbose("\t  in " + evictedData.getParent() + " with " + evictedData.getConflictManager());
                }
            }
        }
        if ("default".equals(options2.getLog())) {
            char[] sep = new char[69];
            Arrays.fill(sep, '-');
            Message.rawinfo("\t" + new String(sep));
            StringBuffer line = new StringBuffer("\t");
            this.append(line, "", 18);
            this.append(line, "modules", 31);
            line.append("|");
            this.append(line, "artifacts", 15);
            line.append("|");
            Message.rawinfo(line.toString());
            line = new StringBuffer("\t");
            this.append(line, "conf", 18);
            this.append(line, "number", 7);
            this.append(line, "search", 7);
            this.append(line, "dwnlded", 7);
            this.append(line, "evicted", 7);
            line.append("|");
            this.append(line, "number", 7);
            this.append(line, "dwnlded", 7);
            line.append("|");
            Message.rawinfo(line.toString());
            Message.rawinfo("\t" + new String(sep));
            confs = report.getConfigurations();
            for (int i3 = 0; i3 < confs.length; ++i3) {
                this.output(report.getConfigurationReport(confs[i3]));
            }
            Message.rawinfo("\t" + new String(sep));
        }
        if ((unresolved = report.getUnresolvedDependencies()).length > 0) {
            Message.warn("\t::::::::::::::::::::::::::::::::::::::::::::::");
            Message.warn("\t::          UNRESOLVED DEPENDENCIES         ::");
            Message.warn("\t::::::::::::::::::::::::::::::::::::::::::::::");
        }
        for (i = 0; i < unresolved.length; ++i) {
            Message.warn("\t:: " + unresolved[i] + ": " + unresolved[i].getProblemMessage());
        }
        if (unresolved.length > 0) {
            Message.warn("\t::::::::::::::::::::::::::::::::::::::::::::::\n");
        }
        if ((errors2 = report.getFailedArtifactsReports()).length > 0) {
            Message.warn("\t::::::::::::::::::::::::::::::::::::::::::::::");
            Message.warn("\t::              FAILED DOWNLOADS            ::");
            Message.warn("\t:: ^ see resolution messages for details  ^ ::");
            Message.warn("\t::::::::::::::::::::::::::::::::::::::::::::::");
        }
        for (int i4 = 0; i4 < errors2.length; ++i4) {
            Message.warn("\t:: " + errors2[i4].getArtifact());
        }
        if (errors2.length > 0) {
            Message.warn("\t::::::::::::::::::::::::::::::::::::::::::::::\n");
        }
    }

    public void output(ConfigurationResolveReport report) {
        StringBuffer line = new StringBuffer("\t");
        this.append(line, report.getConfiguration(), 18);
        this.append(line, String.valueOf(report.getNodesNumber()), 7);
        this.append(line, String.valueOf(report.getSearchedNodes().length), 7);
        this.append(line, String.valueOf(report.getDownloadedNodes().length), 7);
        this.append(line, String.valueOf(report.getEvictedNodes().length), 7);
        line.append("|");
        this.append(line, String.valueOf(report.getArtifactsNumber()), 7);
        this.append(line, String.valueOf(report.getDownloadedArtifactsReports().length), 7);
        line.append("|");
        Message.rawinfo(line.toString());
    }

    private void append(StringBuffer line, Object o, int limit2) {
        String v2 = String.valueOf(o);
        if (v2.length() >= limit2) {
            v2 = v2.substring(0, limit2);
        } else {
            int missing = limit2 - v2.length();
            int half = missing / 2;
            char[] c2 = new char[limit2];
            Arrays.fill(c2, ' ');
            System.arraycopy(v2.toCharArray(), 0, c2, missing - half, v2.length());
            v2 = new String(c2);
        }
        line.append("|");
        line.append(v2);
    }
}

