/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Map;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptorMediator;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.ExtendsDescriptor;
import org.apache.ivy.core.module.descriptor.ExtraInfoHolder;
import org.apache.ivy.core.module.descriptor.IncludeRule;
import org.apache.ivy.core.module.descriptor.License;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.descriptor.OverrideDependencyDescriptorMediator;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.matcher.MapMatcher;
import org.apache.ivy.util.DateUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.StringUtils;
import org.apache.ivy.util.XMLHelper;
import org.apache.ivy.util.extendable.ExtendableItem;

public final class XmlModuleDescriptorWriter {
    private XmlModuleDescriptorWriter() {
    }

    public static void write(ModuleDescriptor md, File output) throws IOException {
        XmlModuleDescriptorWriter.write(md, null, output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(ModuleDescriptor md, String licenseHeader, File output) throws IOException {
        if (output.getParentFile() != null) {
            output.getParentFile().mkdirs();
        }
        PrintWriter out2 = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(output), "UTF-8"));
        try {
            out2.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            if (licenseHeader != null) {
                out2.print(licenseHeader);
            }
            StringBuffer xmlNamespace = new StringBuffer();
            Map namespaces = md.getExtraAttributesNamespaces();
            for (Map.Entry ns : namespaces.entrySet()) {
                xmlNamespace.append(" xmlns:").append(ns.getKey()).append("=\"").append(ns.getValue()).append("\"");
            }
            String version2 = "2.0";
            if (md.getInheritedDescriptors().length > 0) {
                version2 = "2.2";
            }
            out2.println("<ivy-module version=\"" + version2 + "\"" + xmlNamespace + ">");
            XmlModuleDescriptorWriter.printInfoTag(md, out2);
            XmlModuleDescriptorWriter.printConfigurations(md, out2);
            XmlModuleDescriptorWriter.printPublications(md, out2);
            XmlModuleDescriptorWriter.printDependencies(md, out2);
            out2.println("</ivy-module>");
        }
        finally {
            out2.close();
        }
    }

    private static void printDependencies(ModuleDescriptor md, PrintWriter out2) {
        DependencyDescriptor[] dds = md.getDependencies();
        if (dds.length > 0) {
            out2.println("\t<dependencies>");
            for (int i = 0; i < dds.length; ++i) {
                DependencyDescriptor dep = dds[i];
                out2.print("\t\t");
                XmlModuleDescriptorWriter.printDependency(md, dep, out2);
            }
            XmlModuleDescriptorWriter.printAllExcludes(md, out2);
            XmlModuleDescriptorWriter.printAllMediators(md, out2);
            out2.println("\t</dependencies>");
        }
    }

    protected static void printDependency(ModuleDescriptor md, DependencyDescriptor dep, PrintWriter out2) {
        out2.print("<dependency");
        out2.print(" org=\"" + XMLHelper.escape(dep.getDependencyRevisionId().getOrganisation()) + "\"");
        out2.print(" name=\"" + XMLHelper.escape(dep.getDependencyRevisionId().getName()) + "\"");
        if (dep.getDependencyRevisionId().getBranch() != null) {
            out2.print(" branch=\"" + XMLHelper.escape(dep.getDependencyRevisionId().getBranch()) + "\"");
        }
        out2.print(" rev=\"" + XMLHelper.escape(dep.getDependencyRevisionId().getRevision()) + "\"");
        if (!dep.getDynamicConstraintDependencyRevisionId().equals(dep.getDependencyRevisionId())) {
            if (dep.getDynamicConstraintDependencyRevisionId().getBranch() != null) {
                out2.print(" branchConstraint=\"" + XMLHelper.escape(dep.getDynamicConstraintDependencyRevisionId().getBranch()) + "\"");
            }
            out2.print(" revConstraint=\"" + XMLHelper.escape(dep.getDynamicConstraintDependencyRevisionId().getRevision()) + "\"");
        }
        if (dep.isForce()) {
            out2.print(" force=\"" + dep.isForce() + "\"");
        }
        if (dep.isChanging()) {
            out2.print(" changing=\"" + dep.isChanging() + "\"");
        }
        if (!dep.isTransitive()) {
            out2.print(" transitive=\"" + dep.isTransitive() + "\"");
        }
        out2.print(" conf=\"");
        String[] modConfs = dep.getModuleConfigurations();
        for (int j = 0; j < modConfs.length; ++j) {
            String[] depConfs = dep.getDependencyConfigurations(modConfs[j]);
            out2.print(XMLHelper.escape(modConfs[j]) + "->");
            for (int k = 0; k < depConfs.length; ++k) {
                out2.print(XMLHelper.escape(depConfs[k]));
                if (k + 1 >= depConfs.length) continue;
                out2.print(",");
            }
            if (j + 1 >= modConfs.length) continue;
            out2.print(";");
        }
        out2.print("\"");
        XmlModuleDescriptorWriter.printExtraAttributes(dep, out2, " ");
        DependencyArtifactDescriptor[] depArtifacts = dep.getAllDependencyArtifacts();
        if (depArtifacts.length > 0) {
            out2.println(">");
        }
        XmlModuleDescriptorWriter.printDependencyArtefacts(md, out2, depArtifacts);
        IncludeRule[] includes = dep.getAllIncludeRules();
        if (includes.length > 0 && depArtifacts.length == 0) {
            out2.println(">");
        }
        XmlModuleDescriptorWriter.printDependencyIncludeRules(md, out2, includes);
        ExcludeRule[] excludes = dep.getAllExcludeRules();
        if (excludes.length > 0 && includes.length == 0 && depArtifacts.length == 0) {
            out2.println(">");
        }
        XmlModuleDescriptorWriter.printDependencyExcludeRules(md, out2, excludes);
        if (includes.length + excludes.length + depArtifacts.length == 0) {
            out2.println("/>");
        } else {
            out2.println("\t\t</dependency>");
        }
    }

    private static void printAllMediators(ModuleDescriptor md, PrintWriter out2) {
        Map mediators = md.getAllDependencyDescriptorMediators().getAllRules();
        for (Map.Entry mediatorRule : mediators.entrySet()) {
            MapMatcher matcher = (MapMatcher)mediatorRule.getKey();
            DependencyDescriptorMediator mediator = (DependencyDescriptorMediator)mediatorRule.getValue();
            if (mediator instanceof OverrideDependencyDescriptorMediator) {
                OverrideDependencyDescriptorMediator oddm = (OverrideDependencyDescriptorMediator)mediator;
                out2.print("\t\t<override");
                out2.print(" org=\"" + XMLHelper.escape((String)matcher.getAttributes().get("organisation")) + "\"");
                out2.print(" module=\"" + XMLHelper.escape((String)matcher.getAttributes().get("module")) + "\"");
                out2.print(" matcher=\"" + XMLHelper.escape(matcher.getPatternMatcher().getName()) + "\"");
                if (oddm.getBranch() != null) {
                    out2.print(" branch=\"" + XMLHelper.escape(oddm.getBranch()) + "\"");
                }
                if (oddm.getVersion() != null) {
                    out2.print(" rev=\"" + XMLHelper.escape(oddm.getVersion()) + "\"");
                }
                out2.println("/>");
                continue;
            }
            Message.verbose("ignoring unhandled DependencyDescriptorMediator: " + mediator.getClass());
        }
    }

    private static void printAllExcludes(ModuleDescriptor md, PrintWriter out2) {
        ExcludeRule[] excludes = md.getAllExcludeRules();
        if (excludes.length > 0) {
            for (int j = 0; j < excludes.length; ++j) {
                out2.print("\t\t<exclude");
                out2.print(" org=\"" + XMLHelper.escape(excludes[j].getId().getModuleId().getOrganisation()) + "\"");
                out2.print(" module=\"" + XMLHelper.escape(excludes[j].getId().getModuleId().getName()) + "\"");
                out2.print(" artifact=\"" + XMLHelper.escape(excludes[j].getId().getName()) + "\"");
                out2.print(" type=\"" + XMLHelper.escape(excludes[j].getId().getType()) + "\"");
                out2.print(" ext=\"" + XMLHelper.escape(excludes[j].getId().getExt()) + "\"");
                String[] ruleConfs = excludes[j].getConfigurations();
                if (!((Object)Arrays.asList(ruleConfs)).equals(Arrays.asList(md.getConfigurationsNames()))) {
                    out2.print(" conf=\"");
                    for (int k = 0; k < ruleConfs.length; ++k) {
                        out2.print(XMLHelper.escape(ruleConfs[k]));
                        if (k + 1 >= ruleConfs.length) continue;
                        out2.print(",");
                    }
                    out2.print("\"");
                }
                out2.print(" matcher=\"" + XMLHelper.escape(excludes[j].getMatcher().getName()) + "\"");
                out2.println("/>");
            }
        }
    }

    private static void printDependencyExcludeRules(ModuleDescriptor md, PrintWriter out2, ExcludeRule[] excludes) {
        if (excludes.length > 0) {
            for (int j = 0; j < excludes.length; ++j) {
                out2.print("\t\t\t<exclude");
                out2.print(" org=\"" + XMLHelper.escape(excludes[j].getId().getModuleId().getOrganisation()) + "\"");
                out2.print(" module=\"" + XMLHelper.escape(excludes[j].getId().getModuleId().getName()) + "\"");
                out2.print(" name=\"" + XMLHelper.escape(excludes[j].getId().getName()) + "\"");
                out2.print(" type=\"" + XMLHelper.escape(excludes[j].getId().getType()) + "\"");
                out2.print(" ext=\"" + XMLHelper.escape(excludes[j].getId().getExt()) + "\"");
                String[] ruleConfs = excludes[j].getConfigurations();
                if (!((Object)Arrays.asList(ruleConfs)).equals(Arrays.asList(md.getConfigurationsNames()))) {
                    out2.print(" conf=\"");
                    for (int k = 0; k < ruleConfs.length; ++k) {
                        out2.print(XMLHelper.escape(ruleConfs[k]));
                        if (k + 1 >= ruleConfs.length) continue;
                        out2.print(",");
                    }
                    out2.print("\"");
                }
                out2.print(" matcher=\"" + XMLHelper.escape(excludes[j].getMatcher().getName()) + "\"");
                out2.println("/>");
            }
        }
    }

    private static void printDependencyIncludeRules(ModuleDescriptor md, PrintWriter out2, IncludeRule[] includes) {
        if (includes.length > 0) {
            for (int j = 0; j < includes.length; ++j) {
                out2.print("\t\t\t<include");
                out2.print(" name=\"" + XMLHelper.escape(includes[j].getId().getName()) + "\"");
                out2.print(" type=\"" + XMLHelper.escape(includes[j].getId().getType()) + "\"");
                out2.print(" ext=\"" + XMLHelper.escape(includes[j].getId().getExt()) + "\"");
                String[] ruleConfs = includes[j].getConfigurations();
                if (!((Object)Arrays.asList(ruleConfs)).equals(Arrays.asList(md.getConfigurationsNames()))) {
                    out2.print(" conf=\"");
                    for (int k = 0; k < ruleConfs.length; ++k) {
                        out2.print(XMLHelper.escape(ruleConfs[k]));
                        if (k + 1 >= ruleConfs.length) continue;
                        out2.print(",");
                    }
                    out2.print("\"");
                }
                out2.print(" matcher=\"" + XMLHelper.escape(includes[j].getMatcher().getName()) + "\"");
                out2.println("/>");
            }
        }
    }

    private static void printDependencyArtefacts(ModuleDescriptor md, PrintWriter out2, DependencyArtifactDescriptor[] depArtifacts) {
        if (depArtifacts.length > 0) {
            for (int j = 0; j < depArtifacts.length; ++j) {
                out2.print("\t\t\t<artifact");
                out2.print(" name=\"" + XMLHelper.escape(depArtifacts[j].getName()) + "\"");
                out2.print(" type=\"" + XMLHelper.escape(depArtifacts[j].getType()) + "\"");
                out2.print(" ext=\"" + XMLHelper.escape(depArtifacts[j].getExt()) + "\"");
                String[] dadconfs = depArtifacts[j].getConfigurations();
                if (!((Object)Arrays.asList(dadconfs)).equals(Arrays.asList(md.getConfigurationsNames()))) {
                    out2.print(" conf=\"");
                    for (int k = 0; k < dadconfs.length; ++k) {
                        out2.print(XMLHelper.escape(dadconfs[k]));
                        if (k + 1 >= dadconfs.length) continue;
                        out2.print(",");
                    }
                    out2.print("\"");
                }
                XmlModuleDescriptorWriter.printExtraAttributes(depArtifacts[j], out2, " ");
                out2.println("/>");
            }
        }
    }

    private static void printExtraAttributes(ExtendableItem item, PrintWriter out2, String prefix) {
        XmlModuleDescriptorWriter.printExtraAttributes(item.getQualifiedExtraAttributes(), out2, prefix);
    }

    private static void printExtraAttributes(Map extra, PrintWriter out2, String prefix) {
        if (extra == null) {
            return;
        }
        String delim = prefix;
        for (Map.Entry entry : extra.entrySet()) {
            out2.print(delim + entry.getKey() + "=\"" + XMLHelper.escape(entry.getValue().toString()) + "\"");
            delim = " ";
        }
    }

    private static void printPublications(ModuleDescriptor md, PrintWriter out2) {
        out2.println("\t<publications>");
        Artifact[] artifacts2 = md.getAllArtifacts();
        for (int i = 0; i < artifacts2.length; ++i) {
            out2.print("\t\t<artifact");
            out2.print(" name=\"" + XMLHelper.escape(artifacts2[i].getName()) + "\"");
            out2.print(" type=\"" + XMLHelper.escape(artifacts2[i].getType()) + "\"");
            out2.print(" ext=\"" + XMLHelper.escape(artifacts2[i].getExt()) + "\"");
            out2.print(" conf=\"" + XMLHelper.escape(XmlModuleDescriptorWriter.getConfs(md, artifacts2[i])) + "\"");
            XmlModuleDescriptorWriter.printExtraAttributes(artifacts2[i], out2, " ");
            out2.println("/>");
        }
        out2.println("\t</publications>");
    }

    private static void printConfigurations(ModuleDescriptor md, PrintWriter out2) {
        Configuration[] confs = md.getConfigurations();
        if (confs.length > 0) {
            out2.println("\t<configurations>");
            for (int i = 0; i < confs.length; ++i) {
                Configuration conf = confs[i];
                out2.print("\t\t");
                XmlModuleDescriptorWriter.printConfiguration(conf, out2);
            }
            out2.println("\t</configurations>");
        }
    }

    protected static void printConfiguration(Configuration conf, PrintWriter out2) {
        String[] exts;
        out2.print("<conf");
        out2.print(" name=\"" + XMLHelper.escape(conf.getName()) + "\"");
        out2.print(" visibility=\"" + XMLHelper.escape(conf.getVisibility().toString()) + "\"");
        if (conf.getDescription() != null) {
            out2.print(" description=\"" + XMLHelper.escape(conf.getDescription()) + "\"");
        }
        if ((exts = conf.getExtends()).length > 0) {
            out2.print(" extends=\"");
            for (int j = 0; j < exts.length; ++j) {
                out2.print(XMLHelper.escape(exts[j]));
                if (j + 1 >= exts.length) continue;
                out2.print(",");
            }
            out2.print("\"");
        }
        if (!conf.isTransitive()) {
            out2.print(" transitive=\"false\"");
        }
        if (conf.getDeprecated() != null) {
            out2.print(" deprecated=\"" + XMLHelper.escape(conf.getDeprecated()) + "\"");
        }
        XmlModuleDescriptorWriter.printExtraAttributes(conf, out2, " ");
        out2.println("/>");
    }

    private static void printInfoTag(ModuleDescriptor md, PrintWriter out2) {
        DefaultModuleDescriptor dmd;
        String revision;
        out2.println("\t<info organisation=\"" + XMLHelper.escape(md.getModuleRevisionId().getOrganisation()) + "\"");
        out2.println("\t\tmodule=\"" + XMLHelper.escape(md.getModuleRevisionId().getName()) + "\"");
        String branch = md.getResolvedModuleRevisionId().getBranch();
        if (branch != null) {
            out2.println("\t\tbranch=\"" + XMLHelper.escape(branch) + "\"");
        }
        if ((revision = md.getResolvedModuleRevisionId().getRevision()) != null) {
            out2.println("\t\trevision=\"" + XMLHelper.escape(revision) + "\"");
        }
        out2.println("\t\tstatus=\"" + XMLHelper.escape(md.getStatus()) + "\"");
        out2.println("\t\tpublication=\"" + DateUtil.format(md.getResolvedPublicationDate()) + "\"");
        if (md.isDefault()) {
            out2.println("\t\tdefault=\"true\"");
        }
        if (md instanceof DefaultModuleDescriptor && (dmd = (DefaultModuleDescriptor)md).getNamespace() != null && !dmd.getNamespace().getName().equals("system")) {
            out2.println("\t\tnamespace=\"" + XMLHelper.escape(dmd.getNamespace().getName()) + "\"");
        }
        if (!md.getExtraAttributes().isEmpty()) {
            XmlModuleDescriptorWriter.printExtraAttributes(md, out2, "\t\t");
            out2.println();
        }
        if (XmlModuleDescriptorWriter.requireInnerInfoElement(md)) {
            out2.println("\t>");
            ExtendsDescriptor[] parents = md.getInheritedDescriptors();
            for (int i = 0; i < parents.length; ++i) {
                ExtendsDescriptor parent2 = parents[i];
                ModuleRevisionId mrid = parent2.getParentRevisionId();
                out2.print("\t\t<extends organisation=\"" + XMLHelper.escape(mrid.getOrganisation()) + "\"" + " module=\"" + XMLHelper.escape(mrid.getName()) + "\"" + " revision=\"" + XMLHelper.escape(mrid.getRevision()) + "\"");
                String location = parent2.getLocation();
                if (location != null) {
                    out2.print(" location=\"" + XMLHelper.escape(location) + "\"");
                }
                out2.print(" extendType=\"" + StringUtils.join(parent2.getExtendsTypes(), ",") + "\"");
                out2.println("/>");
            }
            License[] licenses = md.getLicenses();
            for (int i = 0; i < licenses.length; ++i) {
                License license = licenses[i];
                out2.print("\t\t<license ");
                if (license.getName() != null) {
                    out2.print("name=\"" + XMLHelper.escape(license.getName()) + "\" ");
                }
                if (license.getUrl() != null) {
                    out2.print("url=\"" + XMLHelper.escape(license.getUrl()) + "\" ");
                }
                out2.println("/>");
            }
            if (md.getHomePage() != null || md.getDescription() != null) {
                out2.print("\t\t<description");
                if (md.getHomePage() != null) {
                    out2.print(" homepage=\"" + XMLHelper.escape(md.getHomePage()) + "\"");
                }
                if (md.getDescription() != null && md.getDescription().trim().length() > 0) {
                    out2.println(">");
                    out2.println("\t\t" + XMLHelper.escape(md.getDescription()));
                    out2.println("\t\t</description>");
                } else {
                    out2.println(" />");
                }
            }
            for (ExtraInfoHolder extraInfo : md.getExtraInfos()) {
                XmlModuleDescriptorWriter.printExtraInfoElement(out2, extraInfo, 2);
            }
            out2.println("\t</info>");
        } else {
            out2.println("\t/>");
        }
    }

    private static void printExtraInfoElement(PrintWriter out2, ExtraInfoHolder extraInfo, int indent) {
        for (int i = 1; i <= indent; ++i) {
            out2.print("\t");
        }
        out2.print("<");
        out2.print(extraInfo.getName());
        for (Map.Entry<String, String> entry : extraInfo.getAttributes().entrySet()) {
            out2.print(" ");
            out2.print(entry.getKey());
            out2.print("=");
            out2.print("\"");
            out2.print(entry.getValue());
            out2.print("\"");
        }
        boolean requireClosingTag = false;
        if (extraInfo.getContent() != null && extraInfo.getContent().trim().length() > 0) {
            out2.print(">");
            out2.print(XMLHelper.escape(extraInfo.getContent()));
            requireClosingTag = true;
        }
        if (!extraInfo.getNestedExtraInfoHolder().isEmpty()) {
            out2.println(">");
            for (ExtraInfoHolder nestedElement : extraInfo.getNestedExtraInfoHolder()) {
                XmlModuleDescriptorWriter.printExtraInfoElement(out2, nestedElement, indent + 1);
            }
            requireClosingTag = true;
            for (int i = 1; i <= indent; ++i) {
                out2.print("\t");
            }
        }
        if (requireClosingTag) {
            out2.print("</");
            out2.print(extraInfo.getName());
            out2.println(">");
        } else {
            out2.println("/>");
        }
    }

    private static boolean requireInnerInfoElement(ModuleDescriptor md) {
        return md.getExtraInfo().size() > 0 || md.getExtraInfos().size() > 0 || md.getHomePage() != null || md.getDescription() != null && md.getDescription().trim().length() > 0 || md.getLicenses().length > 0 || md.getInheritedDescriptors().length > 0;
    }

    private static String getConfs(ModuleDescriptor md, Artifact artifact) {
        StringBuffer ret = new StringBuffer();
        String[] confs = md.getConfigurationsNames();
        for (int i = 0; i < confs.length; ++i) {
            if (!Arrays.asList(md.getArtifacts(confs[i])).contains(artifact)) continue;
            ret.append(confs[i]).append(",");
        }
        if (ret.length() > 0) {
            ret.setLength(ret.length() - 1);
        }
        return ret.toString();
    }
}

