/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.xml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExtendsDescriptor;
import org.apache.ivy.core.module.descriptor.InheritableItem;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.namespace.NameSpaceHelper;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.xml.UpdateOptions;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorParser;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorWriter;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.file.FileResource;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.DateUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.XMLHelper;
import org.apache.ivy.util.extendable.ExtendableItemHelper;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlModuleDescriptorUpdater {
    public static String LINE_SEPARATOR = System.getProperty("line.separator");

    private XmlModuleDescriptorUpdater() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(URL srcURL, File destFile, UpdateOptions options2) throws IOException, SAXException {
        if (destFile.getParentFile() != null) {
            destFile.getParentFile().mkdirs();
        }
        FileOutputStream destStream = new FileOutputStream(destFile);
        try {
            XmlModuleDescriptorUpdater.update(srcURL, destStream, options2);
        }
        finally {
            try {
                ((OutputStream)destStream).close();
            }
            catch (IOException e2) {
                Message.warn("failed to close a stream : " + e2.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(URL srcURL, OutputStream destFile, UpdateOptions options2) throws IOException, SAXException {
        InputStream in2 = srcURL.openStream();
        try {
            XmlModuleDescriptorUpdater.update(srcURL, in2, destFile, options2);
        }
        finally {
            try {
                in2.close();
            }
            catch (IOException e2) {
                Message.warn("failed to close a stream : " + e2.toString());
            }
            try {
                destFile.close();
            }
            catch (IOException e3) {
                Message.warn("failed to close a stream : " + e3.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(InputStream in2, Resource res, File destFile, UpdateOptions options2) throws IOException, SAXException {
        if (destFile.getParentFile() != null) {
            destFile.getParentFile().mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(destFile);
        try {
            URL inputStreamContext = null;
            if (res instanceof URLResource) {
                inputStreamContext = ((URLResource)res).getURL();
            } else if (res instanceof FileResource) {
                inputStreamContext = ((FileResource)res).getFile().toURI().toURL();
            }
            XmlModuleDescriptorUpdater.update(inputStreamContext, in2, fos, options2);
        }
        finally {
            try {
                in2.close();
            }
            catch (IOException e2) {
                Message.warn("failed to close a stream : " + e2.toString());
            }
            try {
                ((OutputStream)fos).close();
            }
            catch (IOException e3) {
                Message.warn("failed to close a stream : " + e3.toString());
            }
        }
    }

    public static void update(URL inStreamCtx, InputStream inStream, OutputStream outStream, UpdateOptions options2) throws IOException, SAXException {
        PrintWriter out2 = new PrintWriter(new OutputStreamWriter(outStream, "UTF-8"));
        out2.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out2.write(LINE_SEPARATOR);
        try {
            UpdaterHandler updaterHandler = new UpdaterHandler(inStreamCtx, out2, options2);
            InputSource inSrc = new InputSource(new BufferedInputStream(inStream));
            if (inStreamCtx != null) {
                inSrc.setSystemId(inStreamCtx.toExternalForm());
            }
            XMLHelper.parse(inSrc, null, (DefaultHandler)updaterHandler, (LexicalHandler)updaterHandler);
        }
        catch (ParserConfigurationException e2) {
            IllegalStateException ise = new IllegalStateException("impossible to update Ivy files: parser problem");
            ise.initCause(e2);
            throw ise;
        }
    }

    protected static class ConfigurationPrinter
    implements ItemPrinter {
        public static final ConfigurationPrinter INSTANCE = new ConfigurationPrinter();

        protected ConfigurationPrinter() {
        }

        public void print(ModuleDescriptor parent2, Object item, PrintWriter out2) {
            XmlModuleDescriptorWriter.printConfiguration((Configuration)item, out2);
        }
    }

    protected static class DependencyPrinter
    implements ItemPrinter {
        public static final DependencyPrinter INSTANCE = new DependencyPrinter();

        protected DependencyPrinter() {
        }

        public void print(ModuleDescriptor parent2, Object item, PrintWriter out2) {
            XmlModuleDescriptorWriter.printDependency(parent2, (DependencyDescriptor)item, out2);
        }
    }

    protected static interface ItemPrinter {
        public void print(ModuleDescriptor var1, Object var2, PrintWriter var3);
    }

    private static class ExtendedBuffer {
        private String context = null;
        private Boolean print = null;
        private boolean defaultPrint = false;
        private StringWriter buffer = new StringWriter();
        private PrintWriter writer = new PrintWriter(this.buffer);

        ExtendedBuffer(String context) {
            this.context = context;
        }

        boolean isPrint() {
            if (this.print == null) {
                return this.defaultPrint;
            }
            return this.print;
        }

        void setPrint(boolean print) {
            this.print = print;
        }

        void setDefaultPrint(boolean print) {
            this.defaultPrint = print;
        }

        PrintWriter getWriter() {
            return this.writer;
        }

        String getContext() {
            return this.context;
        }

        public String toString() {
            this.writer.flush();
            return this.buffer.toString();
        }
    }

    private static class UpdaterHandler
    extends DefaultHandler
    implements LexicalHandler {
        private static final Collection STD_ATTS = Arrays.asList("organisation", "module", "branch", "revision", "status", "publication", "namespace");
        private static final List MODULE_ELEMENTS = Arrays.asList("info", "configurations", "publications", "dependencies", "conflicts");
        private static final int CONFIGURATIONS_POSITION = MODULE_ELEMENTS.indexOf("configurations");
        private static final int DEPENDENCIES_POSITION = MODULE_ELEMENTS.indexOf("dependencies");
        private static final Collection INFO_ELEMENTS = Arrays.asList("extends", "ivyauthor", "license", "repository", "description");
        private final ParserSettings settings;
        private final PrintWriter out;
        private final Map resolvedRevisions;
        private final Map resolvedBranches;
        private final String status;
        private final String revision;
        private final Date pubdate;
        private final Namespace ns;
        private final boolean replaceInclude;
        private final boolean generateRevConstraint;
        private boolean inHeader = true;
        private final List confs;
        private final URL relativePathCtx;
        private final UpdateOptions options;
        private String organisation = null;
        private String defaultConfMapping = null;
        private Boolean confMappingOverride = null;
        private String justOpen = null;
        private boolean indenting;
        private StringBuffer currentIndent = new StringBuffer();
        private ArrayList indentLevels = new ArrayList();
        private boolean hasDescription = false;
        private boolean mergedConfigurations = false;
        private boolean mergedDependencies = false;
        private String newDefaultConf = null;
        private Stack context = new Stack();
        private Stack buffers = new Stack();
        private Stack confAttributeBuffers = new Stack();

        public UpdaterHandler(URL relativePathCtx, PrintWriter out2, UpdateOptions options2) {
            this.options = options2;
            this.settings = options2.getSettings();
            this.out = out2;
            this.resolvedRevisions = options2.getResolvedRevisions();
            this.resolvedBranches = options2.getResolvedBranches();
            this.status = options2.getStatus();
            this.revision = options2.getRevision();
            this.pubdate = options2.getPubdate();
            this.ns = options2.getNamespace();
            this.replaceInclude = options2.isReplaceInclude();
            this.generateRevConstraint = options2.isGenerateRevConstraint();
            this.relativePathCtx = relativePathCtx;
            this.confs = options2.getConfsToExclude() != null ? Arrays.asList(options2.getConfsToExclude()) : Collections.EMPTY_LIST;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.inHeader = false;
            this.endIndent();
            if (this.justOpen != null) {
                this.write(">");
            }
            this.flushMergedElementsBefore(qName);
            if (this.options.isMerge() && ("exclude".equals(localName) || "override".equals(localName) || "conflict".equals(localName)) && "ivy-module/dependencies".equals(this.getContext())) {
                ModuleDescriptor merged = this.options.getMergedDescriptor();
                this.writeInheritedDependencies(merged);
                this.out.println();
                this.out.print(this.getIndent());
            }
            this.context.push(qName);
            String path2 = this.getContext();
            if ("info".equals(qName)) {
                this.infoStarted(attributes);
            } else if (this.replaceInclude && "include".equals(qName) && this.context.contains("configurations")) {
                this.includeStarted(attributes);
            } else if ("ivy-module/info/extends".equals(path2)) {
                this.startExtends(attributes);
            } else if ("ivy-module/dependencies/dependency".equals(path2)) {
                this.startElementInDependency(attributes);
            } else if ("dependencies".equals(qName)) {
                this.startDependencies(attributes);
            } else if ("ivy-module/configurations/conf".equals(path2)) {
                this.startElementInConfigurationsConf(qName, attributes);
            } else if ("ivy-module/publications/artifact/conf".equals(path2) || "ivy-module/dependencies/dependency/conf".equals(path2) || "ivy-module/dependencies/dependency/artifact/conf".equals(path2)) {
                this.buffers.push(new ExtendedBuffer(this.getContext()));
                ((ExtendedBuffer)this.confAttributeBuffers.peek()).setDefaultPrint(false);
                String confName = this.substitute(this.settings, attributes.getValue("name"));
                if (!this.confs.contains(confName)) {
                    ((ExtendedBuffer)this.confAttributeBuffers.peek()).setPrint(true);
                    ((ExtendedBuffer)this.buffers.peek()).setPrint(true);
                    this.write("<" + qName);
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        this.write(" " + attributes.getQName(i) + "=\"" + this.substitute(this.settings, attributes.getValue(i)) + "\"");
                    }
                }
            } else if ("ivy-module/publications/artifact".equals(path2)) {
                ExtendedBuffer buffer2 = new ExtendedBuffer(this.getContext());
                this.buffers.push(buffer2);
                this.confAttributeBuffers.push(buffer2);
                this.write("<" + qName);
                buffer2.setDefaultPrint(attributes.getValue("conf") == null && (this.newDefaultConf == null || this.newDefaultConf.length() > 0));
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String attName = attributes.getQName(i);
                    if ("conf".equals(attName)) {
                        String confName = this.substitute(this.settings, attributes.getValue("conf"));
                        String newConf = this.removeConfigurationsFromList(confName, this.confs);
                        if (newConf.length() <= 0) continue;
                        this.write(" " + attributes.getQName(i) + "=\"" + newConf + "\"");
                        ((ExtendedBuffer)this.buffers.peek()).setPrint(true);
                        continue;
                    }
                    this.write(" " + attributes.getQName(i) + "=\"" + this.substitute(this.settings, attributes.getValue(i)) + "\"");
                }
            } else if ("ivy-module/dependencies/dependency/artifact".equals(path2)) {
                ExtendedBuffer buffer3 = new ExtendedBuffer(this.getContext());
                this.buffers.push(buffer3);
                this.confAttributeBuffers.push(buffer3);
                this.write("<" + qName);
                buffer3.setDefaultPrint(attributes.getValue("conf") == null);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String attName = attributes.getQName(i);
                    if ("conf".equals(attName)) {
                        String confName = this.substitute(this.settings, attributes.getValue("conf"));
                        String newConf = this.removeConfigurationsFromList(confName, this.confs);
                        if (newConf.length() <= 0) continue;
                        this.write(" " + attributes.getQName(i) + "=\"" + newConf + "\"");
                        ((ExtendedBuffer)this.buffers.peek()).setPrint(true);
                        continue;
                    }
                    this.write(" " + attributes.getQName(i) + "=\"" + this.substitute(this.settings, attributes.getValue(i)) + "\"");
                }
            } else if ("ivy-module/publications".equals(path2)) {
                this.startPublications(attributes);
            } else {
                if (this.options.isMerge() && path2.startsWith("ivy-module/info")) {
                    ModuleDescriptor merged = this.options.getMergedDescriptor();
                    if (path2.equals("ivy-module/info/description")) {
                        this.hasDescription = true;
                    } else if (!INFO_ELEMENTS.contains(qName)) {
                        this.writeInheritedDescription(merged);
                    }
                }
                this.write("<" + qName);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.write(" " + attributes.getQName(i) + "=\"" + this.substitute(this.settings, attributes.getValue(i)) + "\"");
                }
            }
            this.justOpen = qName;
        }

        private void startExtends(Attributes attributes) {
            if (this.options.isMerge()) {
                this.write("<!-- ");
            }
            this.write("<extends");
            String org = this.substitute(this.settings, attributes.getValue("organisation"));
            String module2 = this.substitute(this.settings, attributes.getValue("module"));
            ModuleId parentId = new ModuleId(org, module2);
            for (int i = 0; i < attributes.getLength(); ++i) {
                String name = attributes.getQName(i);
                String value2 = null;
                if ("revision".equals(name)) {
                    ModuleDescriptor merged = this.options.getMergedDescriptor();
                    if (merged != null) {
                        ExtendsDescriptor[] parents = merged.getInheritedDescriptors();
                        for (int j = 0; value2 == null && j < parents.length; ++j) {
                            ModuleRevisionId resolvedId = parents[j].getResolvedParentRevisionId();
                            if (!parentId.equals(resolvedId.getModuleId())) continue;
                            value2 = resolvedId.getRevision();
                        }
                    }
                    if (value2 == null) {
                        value2 = this.substitute(this.settings, attributes.getValue(i));
                    }
                } else {
                    value2 = "organisation".equals(name) ? org : ("module".equals(name) ? module2 : this.substitute(this.settings, attributes.getValue(i)));
                }
                this.write(" " + name + "=\"" + value2 + "\"");
            }
        }

        private void startElementInConfigurationsConf(String qName, Attributes attributes) {
            this.buffers.push(new ExtendedBuffer(this.getContext()));
            String confName = this.substitute(this.settings, attributes.getValue("name"));
            if (!this.confs.contains(confName)) {
                ((ExtendedBuffer)this.buffers.peek()).setPrint(true);
                String extend2 = this.substitute(this.settings, attributes.getValue("extends"));
                if (extend2 != null) {
                    StringTokenizer tok = new StringTokenizer(extend2, ", ");
                    while (tok.hasMoreTokens()) {
                        String current = tok.nextToken();
                        if (!this.confs.contains(current)) continue;
                        throw new IllegalArgumentException("Cannot exclude a configuration which is extended.");
                    }
                }
                this.write("<" + qName);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.write(" " + attributes.getQName(i) + "=\"" + this.substitute(this.settings, attributes.getValue(i)) + "\"");
                }
            }
        }

        private void startDependencies(Attributes attributes) {
            String newMapping;
            this.write("<dependencies");
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attName = attributes.getQName(i);
                if ("defaultconfmapping".equals(attName)) {
                    String newMapping2 = this.removeConfigurationsFromMapping(this.substitute(this.settings, attributes.getValue("defaultconfmapping")), this.confs);
                    if (newMapping2.length() <= 0) continue;
                    this.write(" " + attributes.getQName(i) + "=\"" + newMapping2 + "\"");
                    continue;
                }
                this.write(" " + attributes.getQName(i) + "=\"" + this.substitute(this.settings, attributes.getValue(i)) + "\"");
            }
            if (this.defaultConfMapping != null && attributes.getValue("defaultconfmapping") == null && (newMapping = this.removeConfigurationsFromMapping(this.defaultConfMapping, this.confs)).length() > 0) {
                this.write(" defaultconfmapping=\"" + newMapping + "\"");
            }
            if (this.confMappingOverride != null && attributes.getValue("confmappingoverride") == null) {
                this.write(" confmappingoverride=\"" + this.confMappingOverride.toString() + "\"");
            }
        }

        private void startPublications(Attributes attributes) {
            this.write("<publications");
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attName = attributes.getQName(i);
                if ("defaultconf".equals(attName)) {
                    this.newDefaultConf = this.removeConfigurationsFromList(this.substitute(this.settings, attributes.getValue("defaultconf")), this.confs);
                    if (this.newDefaultConf.length() <= 0) continue;
                    this.write(" " + attributes.getQName(i) + "=\"" + this.newDefaultConf + "\"");
                    continue;
                }
                this.write(" " + attributes.getQName(i) + "=\"" + this.substitute(this.settings, attributes.getValue(i)) + "\"");
            }
        }

        private void startElementInDependency(Attributes attributes) {
            ExtendedBuffer buffer2 = new ExtendedBuffer(this.getContext());
            this.buffers.push(buffer2);
            this.confAttributeBuffers.push(buffer2);
            buffer2.setDefaultPrint(attributes.getValue("conf") == null || attributes.getValue("conf").trim().length() == 0);
            this.write("<dependency");
            String org = this.substitute(this.settings, attributes.getValue("org"));
            org = org == null ? this.organisation : org;
            String module2 = this.substitute(this.settings, attributes.getValue("name"));
            String branch = this.substitute(this.settings, attributes.getValue("branch"));
            String branchConstraint = this.substitute(this.settings, attributes.getValue("branchConstraint"));
            String string2 = branchConstraint = branchConstraint == null ? branch : branchConstraint;
            if (branch == null) {
                ModuleId mid = ModuleId.newInstance(org, module2);
                if (this.ns != null) {
                    mid = NameSpaceHelper.transform(mid, this.ns.getToSystemTransformer());
                }
                for (ModuleRevisionId mrid : this.resolvedRevisions.keySet()) {
                    if (!mrid.getModuleId().equals(mid)) continue;
                    branch = mrid.getBranch();
                    break;
                }
            }
            String revision = this.substitute(this.settings, attributes.getValue("rev"));
            String revisionConstraint = this.substitute(this.settings, attributes.getValue("revConstraint"));
            Map extraAttributes2 = ExtendableItemHelper.getExtraAttributes(this.settings, attributes, XmlModuleDescriptorParser.DEPENDENCY_REGULAR_ATTRIBUTES);
            ModuleRevisionId localMrid = ModuleRevisionId.newInstance(org, module2, branch, revision, extraAttributes2);
            ModuleRevisionId systemMrid = this.ns == null ? localMrid : this.ns.getToSystemTransformer().transform(localMrid);
            String newBranch = (String)this.resolvedBranches.get(systemMrid);
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attName = attributes.getQName(i);
                if ("rev".equals(attName)) {
                    String rev = (String)this.resolvedRevisions.get(systemMrid);
                    if (rev != null) {
                        this.write(" rev=\"" + rev + "\"");
                        if (attributes.getIndex("branchConstraint") == -1 && branchConstraint != null) {
                            this.write(" branchConstraint=\"" + branchConstraint + "\"");
                        }
                        if (!this.generateRevConstraint || attributes.getIndex("revConstraint") != -1 || rev.equals(systemMrid.getRevision())) continue;
                        this.write(" revConstraint=\"" + systemMrid.getRevision() + "\"");
                        continue;
                    }
                    this.write(" rev=\"" + systemMrid.getRevision() + "\"");
                    continue;
                }
                if ("revConstraint".equals(attName)) {
                    this.write(" revConstraint=\"" + revisionConstraint + "\"");
                    continue;
                }
                if ("org".equals(attName)) {
                    this.write(" org=\"" + systemMrid.getOrganisation() + "\"");
                    continue;
                }
                if ("name".equals(attName)) {
                    this.write(" name=\"" + systemMrid.getName() + "\"");
                    continue;
                }
                if ("branch".equals(attName)) {
                    if (newBranch != null) {
                        this.write(" branch=\"" + newBranch + "\"");
                        continue;
                    }
                    if (this.resolvedBranches.containsKey(systemMrid)) continue;
                    this.write(" branch=\"" + systemMrid.getBranch() + "\"");
                    continue;
                }
                if ("branchConstraint".equals(attName)) {
                    this.write(" branchConstraint=\"" + branchConstraint + "\"");
                    continue;
                }
                if ("conf".equals(attName)) {
                    String newMapping;
                    String oldMapping = this.substitute(this.settings, attributes.getValue("conf"));
                    if (oldMapping.length() <= 0 || (newMapping = this.removeConfigurationsFromMapping(oldMapping, this.confs)).length() <= 0) continue;
                    this.write(" conf=\"" + newMapping + "\"");
                    ((ExtendedBuffer)this.buffers.peek()).setPrint(true);
                    continue;
                }
                this.write(" " + attName + "=\"" + this.substitute(this.settings, attributes.getValue(attName)) + "\"");
            }
            if (attributes.getIndex("branch") == -1) {
                if (newBranch != null) {
                    if (!newBranch.trim().equals("")) {
                        this.write(" branch=\"" + newBranch + "\"");
                    }
                } else if (this.options.isUpdateBranch() && systemMrid.getBranch() != null) {
                    this.write(" branch=\"" + systemMrid.getBranch() + "\"");
                }
            }
        }

        private void includeStarted(Attributes attributes) throws SAXException {
            final ExtendedBuffer buffer2 = new ExtendedBuffer(this.getContext());
            this.buffers.push(buffer2);
            try {
                URL url;
                if (this.settings != null) {
                    url = this.settings.getRelativeUrlResolver().getURL(this.relativePathCtx, this.settings.substitute(attributes.getValue("file")), this.settings.substitute(attributes.getValue("url")));
                } else {
                    String fileName = attributes.getValue("file");
                    if (fileName == null) {
                        String urlStr = attributes.getValue("url");
                        url = new URL(urlStr);
                    } else {
                        url = Checks.checkAbsolute(fileName, "settings.include").toURI().toURL();
                    }
                }
                XMLHelper.parse(url, null, new DefaultHandler(){
                    private boolean insideConfigurations = false;
                    private boolean doIndent = false;

                    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                        if ("configurations".equals(qName)) {
                            String mappingOverride;
                            this.insideConfigurations = true;
                            String defaultconf = UpdaterHandler.this.substitute(UpdaterHandler.this.settings, attributes.getValue("defaultconfmapping"));
                            if (defaultconf != null) {
                                UpdaterHandler.this.defaultConfMapping = defaultconf;
                            }
                            if ((mappingOverride = UpdaterHandler.this.substitute(UpdaterHandler.this.settings, attributes.getValue("confmappingoverride"))) != null) {
                                UpdaterHandler.this.confMappingOverride = Boolean.valueOf(mappingOverride);
                            }
                        } else if ("conf".equals(qName) && this.insideConfigurations) {
                            String confName = UpdaterHandler.this.substitute(UpdaterHandler.this.settings, attributes.getValue("name"));
                            if (!UpdaterHandler.this.confs.contains(confName)) {
                                String extend2;
                                buffer2.setPrint(true);
                                if (this.doIndent) {
                                    UpdaterHandler.this.write("/>\n\t\t");
                                }
                                if ((extend2 = UpdaterHandler.this.substitute(UpdaterHandler.this.settings, attributes.getValue("extends"))) != null) {
                                    StringTokenizer tok = new StringTokenizer(extend2, ", ");
                                    while (tok.hasMoreTokens()) {
                                        String current = tok.nextToken();
                                        if (!UpdaterHandler.this.confs.contains(current)) continue;
                                        throw new IllegalArgumentException("Cannot exclude a configuration which is extended.");
                                    }
                                }
                                UpdaterHandler.this.write("<" + qName);
                                for (int i = 0; i < attributes.getLength(); ++i) {
                                    UpdaterHandler.this.write(" " + attributes.getQName(i) + "=\"" + UpdaterHandler.this.substitute(UpdaterHandler.this.settings, attributes.getValue(i)) + "\"");
                                }
                                this.doIndent = true;
                            }
                        }
                    }

                    public void endElement(String uri, String localName, String name) throws SAXException {
                        if ("configurations".equals(name)) {
                            this.insideConfigurations = false;
                        }
                    }
                });
            }
            catch (Exception e2) {
                Message.warn("exception occurred while importing configurations: " + e2.getMessage());
                throw new SAXException(e2);
            }
        }

        private void infoStarted(Attributes attributes) {
            String module2 = this.substitute(this.settings, attributes.getValue("module"));
            String rev = null;
            String branch = null;
            String status = null;
            String namespace = null;
            LinkedHashMap<String, String> extraAttributes2 = null;
            if (this.options.isMerge()) {
                Namespace ns;
                ModuleDescriptor merged = this.options.getMergedDescriptor();
                ModuleRevisionId mergedMrid = merged.getModuleRevisionId();
                this.organisation = mergedMrid.getOrganisation();
                branch = mergedMrid.getBranch();
                rev = mergedMrid.getRevision();
                status = merged.getStatus();
                if (merged instanceof DefaultModuleDescriptor && (ns = ((DefaultModuleDescriptor)merged).getNamespace()) != null) {
                    namespace = ns.getName();
                }
                if (namespace == null) {
                    namespace = attributes.getValue("namespace");
                }
                extraAttributes2 = merged.getQualifiedExtraAttributes();
            } else {
                this.organisation = this.substitute(this.settings, attributes.getValue("organisation"));
                rev = this.substitute(this.settings, attributes.getValue("revision"));
                branch = this.substitute(this.settings, attributes.getValue("branch"));
                status = this.substitute(this.settings, attributes.getValue("status"));
                namespace = this.substitute(this.settings, attributes.getValue("namespace"));
                extraAttributes2 = new LinkedHashMap<String, String>(attributes.getLength());
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String qname = attributes.getQName(i);
                    if (STD_ATTS.contains(qname)) continue;
                    extraAttributes2.put(qname, this.substitute(this.settings, attributes.getValue(i)));
                }
            }
            if (this.revision != null) {
                rev = this.revision;
            }
            if (this.options.getBranch() != null) {
                branch = this.options.getBranch();
            }
            if (this.status != null) {
                status = this.status;
            }
            ModuleRevisionId localMid = ModuleRevisionId.newInstance(this.organisation, module2, branch, rev, ExtendableItemHelper.getExtraAttributes(this.settings, attributes, new String[]{"organisation", "module", "revision", "status", "publication", "namespace"}));
            ModuleRevisionId systemMid = this.ns == null ? localMid : this.ns.getToSystemTransformer().transform(localMid);
            this.write("<info");
            if (this.organisation != null) {
                this.write(" organisation=\"" + XMLHelper.escape(systemMid.getOrganisation()) + "\"");
            }
            this.write(" module=\"" + XMLHelper.escape(systemMid.getName()) + "\"");
            if (branch != null) {
                this.write(" branch=\"" + XMLHelper.escape(systemMid.getBranch()) + "\"");
            }
            if (systemMid.getRevision() != null) {
                this.write(" revision=\"" + XMLHelper.escape(systemMid.getRevision()) + "\"");
            }
            this.write(" status=\"" + XMLHelper.escape(status) + "\"");
            if (this.pubdate != null) {
                this.write(" publication=\"" + DateUtil.format(this.pubdate) + "\"");
            } else if (attributes.getValue("publication") != null) {
                this.write(" publication=\"" + this.substitute(this.settings, attributes.getValue("publication")) + "\"");
            }
            if (namespace != null) {
                this.write(" namespace=\"" + namespace + "\"");
            }
            for (Map.Entry extra : extraAttributes2.entrySet()) {
                this.write(" " + extra.getKey() + "=\"" + extra.getValue() + "\"");
            }
        }

        private void write(String content) {
            this.getWriter().print(content);
        }

        private PrintWriter getWriter() {
            return this.buffers.isEmpty() ? this.out : ((ExtendedBuffer)this.buffers.peek()).getWriter();
        }

        private String getContext() {
            StringBuffer buf = new StringBuffer();
            for (String ctx : this.context) {
                buf.append(ctx).append("/");
            }
            if (buf.length() > 0) {
                buf.setLength(buf.length() - 1);
            }
            return buf.toString();
        }

        private String substitute(ParserSettings ivy, String value2) {
            String result2 = ivy == null ? value2 : ivy.substitute(value2);
            return XMLHelper.escape(result2);
        }

        private String removeConfigurationsFromMapping(String mapping, List confsToRemove) {
            StringBuffer newMapping = new StringBuffer();
            String mappingSep = "";
            StringTokenizer tokenizer = new StringTokenizer(mapping, ";");
            while (tokenizer.hasMoreTokens()) {
                String current = tokenizer.nextToken();
                String[] ops = current.split("->");
                String[] lhs = ops[0].split(",");
                ArrayList<String> confsToWrite = new ArrayList<String>();
                for (int j = 0; j < lhs.length; ++j) {
                    if (this.confs.contains(lhs[j].trim())) continue;
                    confsToWrite.add(lhs[j]);
                }
                if (confsToWrite.isEmpty()) continue;
                newMapping.append(mappingSep);
                String sep = "";
                Iterator it = confsToWrite.iterator();
                while (it.hasNext()) {
                    newMapping.append(sep);
                    newMapping.append(it.next());
                    sep = ",";
                }
                if (ops.length == 2) {
                    newMapping.append("->");
                    newMapping.append(ops[1]);
                }
                mappingSep = ";";
            }
            return newMapping.toString();
        }

        private String removeConfigurationsFromList(String list2, List confsToRemove) {
            StringBuffer newList = new StringBuffer();
            String listSep = "";
            StringTokenizer tokenizer = new StringTokenizer(list2, ",");
            while (tokenizer.hasMoreTokens()) {
                String current = tokenizer.nextToken();
                if (confsToRemove.contains(current.trim())) continue;
                newList.append(listSep);
                newList.append(current);
                listSep = ",";
            }
            return newList.toString();
        }

        public void ignorableWhitespace(char[] ch, int start2, int length2) throws SAXException {
            this.characters(ch, start2, length2);
        }

        public void characters(char[] ch, int start2, int length2) throws SAXException {
            if (this.justOpen != null) {
                this.write(">");
                this.justOpen = null;
            }
            this.write(XMLHelper.escape(String.valueOf(ch, start2, length2)));
            int end2 = start2 + length2;
            for (int i = start2; i < end2; ++i) {
                char c2 = ch[i];
                if (c2 == '\r' || c2 == '\n') {
                    this.currentIndent.setLength(0);
                    this.indenting = true;
                    continue;
                }
                if (!this.indenting) continue;
                if (Character.isWhitespace(c2)) {
                    this.currentIndent.append(c2);
                    continue;
                }
                this.endIndent();
            }
        }

        private void endIndent() {
            if (this.indenting) {
                this.setIndent(this.context.size() - 1, this.currentIndent.toString());
                this.indenting = false;
            }
        }

        private void setIndent(int level, String indent) {
            this.fillIndents(level);
            this.indentLevels.set(level, indent);
        }

        private void fillIndents(int level) {
            if (this.indentLevels.isEmpty()) {
                this.indentLevels.add("    ");
            }
            String oneLevel = (String)this.indentLevels.get(0);
            for (int fill2 = this.indentLevels.size(); fill2 <= level; ++fill2) {
                this.indentLevels.add(this.indentLevels.get(fill2 - 1) + oneLevel);
            }
        }

        private String getIndent() {
            int level = this.context.size() - 1;
            this.fillIndents(level);
            return (String)this.indentLevels.get(level);
        }

        private void writeInheritedItems(ModuleDescriptor merged, InheritableItem[] items, ItemPrinter printer, String itemName, boolean includeContainer) {
            boolean hasItems;
            PrintWriter out2 = this.getWriter();
            Map inheritedItems = this.collateInheritedItems(merged, items);
            boolean bl = hasItems = !inheritedItems.isEmpty();
            if (hasItems && includeContainer) {
                if (this.currentIndent.length() == 0) {
                    out2.print(this.getIndent());
                }
                out2.print("<" + itemName + ">");
                this.context.push(itemName);
                this.justOpen = null;
            }
            for (Map.Entry entry : inheritedItems.entrySet()) {
                ModuleRevisionId parent2 = (ModuleRevisionId)entry.getKey();
                List list2 = (List)entry.getValue();
                if (this.justOpen != null) {
                    out2.println(">");
                    this.justOpen = null;
                }
                this.writeInheritanceComment(itemName, parent2);
                for (int c2 = 0; c2 < list2.size(); ++c2) {
                    InheritableItem item = (InheritableItem)list2.get(c2);
                    out2.print(this.getIndent());
                    printer.print(merged, item, out2);
                }
            }
            if (hasItems) {
                if (includeContainer) {
                    this.context.pop();
                    out2.println(this.getIndent() + "</" + itemName + ">");
                    out2.println();
                }
                out2.print(this.currentIndent);
            }
        }

        private void writeInheritanceComment(String itemDescription, Object parentInfo) {
            PrintWriter out2 = this.getWriter();
            out2.println();
            out2.println(this.getIndent() + "<!-- " + itemDescription + " inherited from " + parentInfo + " -->");
        }

        private Map collateInheritedItems(ModuleDescriptor merged, InheritableItem[] items) {
            LinkedHashMap<ModuleRevisionId, ArrayList<InheritableItem>> inheritedItems = new LinkedHashMap<ModuleRevisionId, ArrayList<InheritableItem>>();
            for (int i = 0; i < items.length; ++i) {
                ModuleRevisionId source = items[i].getSourceModule();
                if (source == null || source.getModuleId().equals(merged.getModuleRevisionId().getModuleId())) continue;
                ArrayList<InheritableItem> accum = (ArrayList<InheritableItem>)inheritedItems.get(source);
                if (accum == null) {
                    accum = new ArrayList<InheritableItem>();
                    inheritedItems.put(source, accum);
                }
                accum.add(items[i]);
            }
            return inheritedItems;
        }

        private void writeInheritedDescription(ModuleDescriptor merged) {
            if (!this.hasDescription) {
                this.hasDescription = true;
                String description = merged.getDescription();
                if (description != null && description.length() > 0) {
                    PrintWriter writer2 = this.getWriter();
                    if (this.justOpen != null) {
                        writer2.println(">");
                    }
                    this.writeInheritanceComment("description", "parent");
                    writer2.println(this.getIndent() + "<description>" + XMLHelper.escape(description) + "</description>");
                    writer2.print(this.currentIndent);
                    this.justOpen = null;
                }
            }
        }

        private void writeInheritedConfigurations(ModuleDescriptor merged) {
            if (!this.mergedConfigurations) {
                this.mergedConfigurations = true;
                this.writeInheritedItems(merged, merged.getConfigurations(), ConfigurationPrinter.INSTANCE, "configurations", false);
            }
        }

        private void writeInheritedDependencies(ModuleDescriptor merged) {
            if (!this.mergedDependencies) {
                this.mergedDependencies = true;
                this.writeInheritedItems(merged, merged.getDependencies(), DependencyPrinter.INSTANCE, "dependencies", false);
            }
        }

        private void flushMergedElementsBefore(String moduleElement) {
            if (this.options.isMerge() && this.context.size() == 1 && "ivy-module".equals(this.context.peek()) && (!this.mergedConfigurations || !this.mergedDependencies)) {
                int position = moduleElement == null ? MODULE_ELEMENTS.size() : MODULE_ELEMENTS.indexOf(moduleElement);
                ModuleDescriptor merged = this.options.getMergedDescriptor();
                if (!this.mergedConfigurations && position > CONFIGURATIONS_POSITION && merged.getConfigurations().length > 0) {
                    this.mergedConfigurations = true;
                    this.writeInheritedItems(merged, merged.getConfigurations(), ConfigurationPrinter.INSTANCE, "configurations", true);
                }
                if (!this.mergedDependencies && position > DEPENDENCIES_POSITION && merged.getDependencies().length > 0) {
                    this.mergedDependencies = true;
                    this.writeInheritedItems(merged, merged.getDependencies(), DependencyPrinter.INSTANCE, "dependencies", true);
                }
            }
        }

        private void flushAllMergedElements() {
            this.flushMergedElementsBefore(null);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            ExtendedBuffer buffer2;
            String path2 = this.getContext();
            if (this.options.isMerge()) {
                ModuleDescriptor merged = this.options.getMergedDescriptor();
                if ("ivy-module/info".equals(path2)) {
                    this.writeInheritedDescription(merged);
                } else if ("ivy-module/configurations".equals(path2)) {
                    this.writeInheritedConfigurations(merged);
                } else if ("ivy-module/dependencies".equals(path2)) {
                    this.writeInheritedDependencies(merged);
                } else if ("ivy-module".equals(path2)) {
                    this.flushAllMergedElements();
                }
            }
            if (qName.equals(this.justOpen)) {
                this.write("/>");
            } else {
                this.write("</" + qName + ">");
            }
            if (!this.buffers.isEmpty() && (buffer2 = (ExtendedBuffer)this.buffers.peek()).getContext().equals(path2)) {
                this.buffers.pop();
                if (buffer2.isPrint()) {
                    this.write(buffer2.toString());
                }
            }
            if (!this.confAttributeBuffers.isEmpty() && (buffer2 = (ExtendedBuffer)this.confAttributeBuffers.peek()).getContext().equals(path2)) {
                this.confAttributeBuffers.pop();
            }
            if (this.options.isMerge() && "ivy-module/info/extends".equals(path2)) {
                this.write(" -->");
            }
            this.justOpen = null;
            this.context.pop();
        }

        public void endDocument() throws SAXException {
            this.out.print(LINE_SEPARATOR);
            this.out.flush();
            this.out.close();
        }

        public void processingInstruction(String target, String data) throws SAXException {
            this.write("<?");
            this.write(target);
            this.write(" ");
            this.write(data);
            this.write("?>");
            this.write(LINE_SEPARATOR);
        }

        public void warning(SAXParseException e2) throws SAXException {
            throw e2;
        }

        public void error(SAXParseException e2) throws SAXException {
            throw e2;
        }

        public void fatalError(SAXParseException e2) throws SAXException {
            throw e2;
        }

        public void endCDATA() throws SAXException {
        }

        public void endDTD() throws SAXException {
        }

        public void startCDATA() throws SAXException {
        }

        public void comment(char[] ch, int start2, int length2) throws SAXException {
            if (this.justOpen != null) {
                this.write(">");
                this.justOpen = null;
            }
            StringBuffer comment = new StringBuffer();
            comment.append(ch, start2, length2);
            this.write("<!--");
            this.write(comment.toString());
            this.write("-->");
            if (this.inHeader) {
                this.write(LINE_SEPARATOR);
            }
        }

        public void endEntity(String name) throws SAXException {
        }

        public void startEntity(String name) throws SAXException {
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }
    }
}

