/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.m2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.core.settings.IvyVariableContainer;
import org.apache.ivy.plugins.parser.m2.PomWriterOptions;
import org.apache.ivy.util.ConfigurationUtils;

public final class PomModuleDescriptorWriter {
    private static final String SKIP_LINE = "SKIP_LINE";
    private static final PomWriterOptions.ConfigurationScopeMapping DEFAULT_MAPPING = new PomWriterOptions.ConfigurationScopeMapping(new HashMap(){
        {
            this.put("compile", "compile");
            this.put("runtime", "runtime");
            this.put("provided", "provided");
            this.put("test", "test");
            this.put("system", "system");
        }
    });

    private PomModuleDescriptorWriter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(ModuleDescriptor md, File output, PomWriterOptions options2) throws IOException {
        LineNumberReader in2 = options2.getTemplate() == null ? new LineNumberReader(new InputStreamReader(PomModuleDescriptorWriter.class.getResourceAsStream("pom.template"))) : new LineNumberReader(new InputStreamReader(new FileInputStream(options2.getTemplate())));
        if (output.getParentFile() != null) {
            output.getParentFile().mkdirs();
        }
        PrintWriter out2 = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(output), "UTF-8"));
        try {
            IvySettings settings = IvyContext.getContext().getSettings();
            IvyVariableContainerWrapper variables2 = new IvyVariableContainerWrapper(settings.getVariableContainer());
            variables2.setVariable("ivy.pom.license", SKIP_LINE, true);
            variables2.setVariable("ivy.pom.header", SKIP_LINE, true);
            variables2.setVariable("ivy.pom.groupId", SKIP_LINE, true);
            variables2.setVariable("ivy.pom.artifactId", SKIP_LINE, true);
            variables2.setVariable("ivy.pom.version", SKIP_LINE, true);
            variables2.setVariable("ivy.pom.packaging", SKIP_LINE, true);
            variables2.setVariable("ivy.pom.name", SKIP_LINE, true);
            variables2.setVariable("ivy.pom.description", SKIP_LINE, true);
            variables2.setVariable("ivy.pom.url", SKIP_LINE, true);
            if (options2.getLicenseHeader() != null) {
                variables2.setVariable("ivy.pom.license", options2.getLicenseHeader(), true);
            }
            if (options2.isPrintIvyInfo()) {
                String header = "<!--\n   Apache Maven 2 POM generated by Apache Ivy\n   " + Ivy.getIvyHomeURL() + "\n" + "   Apache Ivy version: " + Ivy.getIvyVersion() + " " + Ivy.getIvyDate() + "\n" + "-->";
                variables2.setVariable("ivy.pom.header", header, true);
            }
            PomModuleDescriptorWriter.setModuleVariables(md, variables2, options2);
            boolean dependenciesPrinted = false;
            int lastIndent = 0;
            int indent = 0;
            String line = in2.readLine();
            while (line != null) {
                if ((line = IvyPatternHelper.substituteVariables(line, variables2)).indexOf(SKIP_LINE) != -1) {
                    line = in2.readLine();
                    continue;
                }
                if (line.trim().length() == 0) {
                    out2.println(line);
                    line = in2.readLine();
                    continue;
                }
                lastIndent = indent;
                indent = line.indexOf(60);
                if (!dependenciesPrinted && line.indexOf("</dependencies>") != -1) {
                    PomModuleDescriptorWriter.printDependencies(md, out2, options2, indent, false);
                    dependenciesPrinted = true;
                }
                if (!dependenciesPrinted && line.indexOf("</project>") != -1) {
                    PomModuleDescriptorWriter.printDependencies(md, out2, options2, lastIndent, true);
                    dependenciesPrinted = true;
                }
                out2.println(line);
                line = in2.readLine();
            }
        }
        finally {
            in2.close();
            out2.close();
        }
    }

    private static void setModuleVariables(ModuleDescriptor md, IvyVariableContainer variables2, PomWriterOptions options2) {
        String packaging;
        ModuleRevisionId mrid = md.getModuleRevisionId();
        variables2.setVariable("ivy.pom.groupId", mrid.getOrganisation(), true);
        String artifactId = options2.getArtifactName();
        if (artifactId == null) {
            artifactId = mrid.getName();
        }
        if ((packaging = options2.getArtifactPackaging()) == null) {
            Artifact artifact = PomModuleDescriptorWriter.findArtifact(md, artifactId);
            packaging = artifact == null ? "pom" : artifact.getType();
        }
        variables2.setVariable("ivy.pom.artifactId", artifactId, true);
        variables2.setVariable("ivy.pom.packaging", packaging, true);
        if (mrid.getRevision() != null) {
            variables2.setVariable("ivy.pom.version", mrid.getRevision(), true);
        }
        if (options2.getDescription() != null) {
            variables2.setVariable("ivy.pom.description", options2.getDescription(), true);
        }
        if (md.getHomePage() != null) {
            variables2.setVariable("ivy.pom.url", md.getHomePage(), true);
        }
    }

    private static Artifact findArtifact(ModuleDescriptor md, String artifactName) {
        Artifact[] artifacts2 = md.getAllArtifacts();
        for (int i = 0; i < artifacts2.length; ++i) {
            if (!artifacts2[i].getName().equals(artifactName) || artifacts2[i].getAttribute("classifier") != null) continue;
            return artifacts2[i];
        }
        return null;
    }

    private static void indent(PrintWriter out2, int indent) {
        for (int i = 0; i < indent; ++i) {
            out2.print(' ');
        }
    }

    private static void printDependencies(ModuleDescriptor md, PrintWriter out2, PomWriterOptions options2, int indent, boolean printDependencies) {
        List extraDeps = options2.getExtraDependencies();
        DependencyDescriptor[] dds = PomModuleDescriptorWriter.getDependencies(md, options2);
        if (!extraDeps.isEmpty() || dds.length > 0) {
            if (printDependencies) {
                PomModuleDescriptorWriter.indent(out2, indent);
                out2.println("<dependencies>");
            }
            for (PomWriterOptions.ExtraDependency dep : extraDeps) {
                String version2;
                String groupId = dep.getGroup();
                if (groupId == null) {
                    groupId = md.getModuleRevisionId().getOrganisation();
                }
                if ((version2 = dep.getVersion()) == null) {
                    version2 = md.getModuleRevisionId().getRevision();
                }
                PomModuleDescriptorWriter.printDependency(out2, indent, groupId, dep.getArtifact(), version2, dep.getType(), dep.getClassifier(), dep.getScope(), dep.isOptional(), null);
            }
            PomWriterOptions.ConfigurationScopeMapping mapping = options2.getMapping();
            if (mapping == null) {
                mapping = DEFAULT_MAPPING;
            }
            for (int i = 0; i < dds.length; ++i) {
                DependencyArtifactDescriptor[] dads;
                ModuleRevisionId mrid = dds[i].getDependencyRevisionId();
                ExcludeRule[] excludes = null;
                if (dds[i].canExclude()) {
                    excludes = dds[i].getAllExcludeRules();
                }
                if ((dads = dds[i].getAllDependencyArtifacts()).length > 0) {
                    for (int j = 0; j < dads.length; ++j) {
                        String type = dads[j].getType();
                        String classifier = dads[j].getExtraAttribute("classifier");
                        String scope2 = mapping.getScope(dds[i].getModuleConfigurations());
                        boolean optional2 = mapping.isOptional(dds[i].getModuleConfigurations());
                        PomModuleDescriptorWriter.printDependency(out2, indent, mrid.getOrganisation(), mrid.getName(), mrid.getRevision(), type, classifier, scope2, optional2, excludes);
                    }
                    continue;
                }
                String scope3 = mapping.getScope(dds[i].getModuleConfigurations());
                boolean optional3 = mapping.isOptional(dds[i].getModuleConfigurations());
                PomModuleDescriptorWriter.printDependency(out2, indent, mrid.getOrganisation(), mrid.getName(), mrid.getRevision(), null, null, scope3, optional3, excludes);
            }
            if (printDependencies) {
                PomModuleDescriptorWriter.indent(out2, indent);
                out2.println("</dependencies>");
            }
        }
    }

    private static void printDependency(PrintWriter out2, int indent, String groupId, String artifactId, String version2, String type, String classifier, String scope2, boolean isOptional, ExcludeRule[] excludes) {
        PomModuleDescriptorWriter.indent(out2, indent * 2);
        out2.println("<dependency>");
        PomModuleDescriptorWriter.indent(out2, indent * 3);
        out2.println("<groupId>" + groupId + "</groupId>");
        PomModuleDescriptorWriter.indent(out2, indent * 3);
        out2.println("<artifactId>" + artifactId + "</artifactId>");
        PomModuleDescriptorWriter.indent(out2, indent * 3);
        out2.println("<version>" + version2 + "</version>");
        if (type != null && !"jar".equals(type)) {
            PomModuleDescriptorWriter.indent(out2, indent * 3);
            out2.println("<type>" + type + "</type>");
        }
        if (classifier != null) {
            PomModuleDescriptorWriter.indent(out2, indent * 3);
            out2.println("<classifier>" + classifier + "</classifier>");
        }
        if (scope2 != null) {
            PomModuleDescriptorWriter.indent(out2, indent * 3);
            out2.println("<scope>" + scope2 + "</scope>");
        }
        if (isOptional) {
            PomModuleDescriptorWriter.indent(out2, indent * 3);
            out2.println("<optional>true</optional>");
        }
        if (excludes != null) {
            PomModuleDescriptorWriter.printExclusions(excludes, out2, indent);
        }
        PomModuleDescriptorWriter.indent(out2, indent * 2);
        out2.println("</dependency>");
    }

    private static void printExclusions(ExcludeRule[] exclusions, PrintWriter out2, int indent) {
        PomModuleDescriptorWriter.indent(out2, indent * 3);
        out2.println("<exclusions>");
        for (int i = 0; i < exclusions.length; ++i) {
            PomModuleDescriptorWriter.indent(out2, indent * 4);
            out2.println("<exclusion>");
            ExcludeRule rule = exclusions[i];
            PomModuleDescriptorWriter.indent(out2, indent * 5);
            out2.println("<groupId>" + rule.getId().getModuleId().getOrganisation() + "</groupId>");
            PomModuleDescriptorWriter.indent(out2, indent * 5);
            out2.println("<artifactId>" + rule.getId().getModuleId().getName() + "</artifactId>");
            PomModuleDescriptorWriter.indent(out2, indent * 4);
            out2.println("</exclusion>");
        }
        PomModuleDescriptorWriter.indent(out2, indent * 3);
        out2.println("</exclusions>");
    }

    private static DependencyDescriptor[] getDependencies(ModuleDescriptor md, PomWriterOptions options2) {
        String[] confs = ConfigurationUtils.replaceWildcards(options2.getConfs(), md);
        ArrayList<DependencyDescriptor> result2 = new ArrayList<DependencyDescriptor>();
        DependencyDescriptor[] dds = md.getDependencies();
        for (int i = 0; i < dds.length; ++i) {
            String[] depConfs = dds[i].getDependencyConfigurations(confs);
            if (depConfs == null || depConfs.length <= 0) continue;
            result2.add(dds[i]);
        }
        return result2.toArray(new DependencyDescriptor[result2.size()]);
    }

    private static final class IvyVariableContainerWrapper
    implements IvyVariableContainer {
        private final IvyVariableContainer variables;
        private Map localVariables = new HashMap();

        private IvyVariableContainerWrapper(IvyVariableContainer variables2) {
            this.variables = variables2;
        }

        public void setVariable(String varName, String value2, boolean overwrite) {
            this.localVariables.put(varName, value2);
        }

        public void setEnvironmentPrefix(String prefix) {
            this.variables.setEnvironmentPrefix(prefix);
        }

        public String getVariable(String name) {
            String result2 = this.variables.getVariable(name);
            if (result2 == null) {
                result2 = (String)this.localVariables.get(name);
            }
            return result2;
        }

        public Object clone() {
            throw new UnsupportedOperationException();
        }
    }
}

