/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.conflict;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Stack;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.IvyNodeBlacklist;
import org.apache.ivy.core.resolve.IvyNodeCallers;
import org.apache.ivy.core.resolve.IvyNodeEviction;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.RestartResolveProcess;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.conflict.LatestConflictManager;
import org.apache.ivy.plugins.conflict.StrictConflictException;
import org.apache.ivy.plugins.latest.LatestStrategy;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.Message;

public class LatestCompatibleConflictManager
extends LatestConflictManager {
    public LatestCompatibleConflictManager() {
    }

    public LatestCompatibleConflictManager(String name, LatestStrategy strategy) {
        super(name, strategy);
    }

    public Collection resolveConflicts(IvyNode parent2, Collection conflicts) {
        Iterator iter;
        IvyNode node4;
        ModuleRevisionId mrid;
        if (conflicts.size() < 2) {
            return conflicts;
        }
        VersionMatcher versionMatcher = this.getSettings().getVersionMatcher();
        if (versionMatcher.isDynamic(mrid = (node4 = (IvyNode)(iter = conflicts.iterator()).next()).getResolvedId())) {
            while (iter.hasNext()) {
                IvyNode other = (IvyNode)iter.next();
                if (versionMatcher.isDynamic(other.getResolvedId())) {
                    return null;
                }
                if (versionMatcher.accept(mrid, other.getResolvedId()) || this.handleIncompatibleConflict(parent2, conflicts, node4, other)) continue;
                return null;
            }
            if (conflicts.size() == 2) {
                Iterator it = conflicts.iterator();
                it.next();
                return Collections.singleton(it.next());
            }
            LinkedHashSet newConflicts = new LinkedHashSet(conflicts);
            newConflicts.remove(node4);
            return super.resolveConflicts(parent2, newConflicts);
        }
        while (iter.hasNext()) {
            IvyNode other = (IvyNode)iter.next();
            if (versionMatcher.accept(other.getResolvedId(), mrid) || this.handleIncompatibleConflict(parent2, conflicts, node4, other)) continue;
            return null;
        }
        return Collections.singleton(node4);
    }

    private boolean handleIncompatibleConflict(IvyNode parent2, Collection conflicts, IvyNode node4, IvyNode other) {
        try {
            LatestConflictManager.IvyNodeArtifactInfo latest = (LatestConflictManager.IvyNodeArtifactInfo)this.getStrategy().findLatest(this.toArtifactInfo(Arrays.asList(node4, other)), null);
            if (latest != null) {
                IvyNode latestNode = latest.getNode();
                IvyNode oldestNode = latestNode == node4 ? other : node4;
                this.blackListIncompatibleCallerAndRestartResolveIfPossible(this.getSettings(), parent2, oldestNode, latestNode);
                this.blackListIncompatibleCallerAndRestartResolveIfPossible(this.getSettings(), parent2, latestNode, oldestNode);
                this.handleUnsolvableConflict(parent2, conflicts, node4, other);
                return true;
            }
            return false;
        }
        catch (LatestConflictManager.NoConflictResolvedYetException ex) {
            return false;
        }
    }

    private void blackListIncompatibleCallerAndRestartResolveIfPossible(IvySettings settings, IvyNode parent2, IvyNode selected, IvyNode evicted) {
        Stack<IvyNode> callerStack = new Stack<IvyNode>();
        callerStack.push(evicted);
        Collection toBlacklist = this.blackListIncompatibleCaller(settings.getVersionMatcher(), parent2, selected, evicted, callerStack);
        if (toBlacklist != null) {
            StringBuffer blacklisted = new StringBuffer();
            Iterator iterator2 = toBlacklist.iterator();
            while (iterator2.hasNext()) {
                IvyNodeBlacklist blacklist = (IvyNodeBlacklist)iterator2.next();
                blacklist.getBlacklistedNode().blacklist(blacklist);
                blacklisted.append(blacklist.getBlacklistedNode());
                if (!iterator2.hasNext()) continue;
                blacklisted.append(" ");
            }
            String rootModuleConf = parent2.getData().getReport().getConfiguration();
            evicted.markEvicted(new IvyNodeEviction.EvictionData(rootModuleConf, parent2, this, Collections.singleton(selected), "with blacklisting of " + blacklisted));
            if (settings.debugConflictResolution()) {
                Message.debug("evicting " + evicted + " by " + evicted.getEvictedData(rootModuleConf));
            }
            throw new RestartResolveProcess("trying to handle incompatibilities between " + selected + " and " + evicted);
        }
    }

    private boolean handleIncompatibleCaller(Stack callerStack, IvyNode node4, IvyNode callerNode, IvyNode conflictParent, IvyNode selectedNode, IvyNode evictedNode, Collection blacklisted, VersionMatcher versionMatcher) {
        if (callerStack.subList(0, callerStack.size() - 1).contains(node4)) {
            return true;
        }
        callerStack.push(callerNode);
        Collection sub2 = this.blackListIncompatibleCaller(versionMatcher, conflictParent, selectedNode, evictedNode, callerStack);
        callerStack.pop();
        if (sub2 == null) {
            return false;
        }
        blacklisted.addAll(sub2);
        return true;
    }

    private Collection blackListIncompatibleCaller(VersionMatcher versionMatcher, IvyNode conflictParent, IvyNode selectedNode, IvyNode evictedNode, Stack callerStack) {
        ArrayList<IvyNodeBlacklist> blacklisted = new ArrayList<IvyNodeBlacklist>();
        IvyNode node4 = (IvyNode)callerStack.peek();
        String rootModuleConf = conflictParent.getData().getReport().getConfiguration();
        IvyNodeCallers.Caller[] callers = node4.getCallers(rootModuleConf);
        for (int i = 0; i < callers.length; ++i) {
            IvyNode callerNode = node4.findNode(callers[i].getModuleRevisionId());
            if (callerNode.isBlacklisted(rootModuleConf)) continue;
            if (versionMatcher.isDynamic(callers[i].getAskedDependencyId(node4.getData()))) {
                blacklisted.add(new IvyNodeBlacklist(conflictParent, selectedNode, evictedNode, node4, rootModuleConf));
                if (!node4.isEvicted(rootModuleConf) || this.handleIncompatibleCaller(callerStack, node4, callerNode, conflictParent, selectedNode, evictedNode, blacklisted, versionMatcher)) continue;
                return null;
            }
            if (this.handleIncompatibleCaller(callerStack, node4, callerNode, conflictParent, selectedNode, evictedNode, blacklisted, versionMatcher)) continue;
            return null;
        }
        if (blacklisted.isEmpty() && !callerStack.subList(0, callerStack.size() - 1).contains(node4)) {
            return null;
        }
        return blacklisted;
    }

    protected void handleUnsolvableConflict(IvyNode parent2, Collection conflicts, IvyNode node1, IvyNode node22) {
        throw new StrictConflictException(node1, node22);
    }

    public void handleAllBlacklistedRevisions(DependencyDescriptor dd, Collection foundBlacklisted) {
        ResolveData resolveData = IvyContext.getContext().getResolveData();
        HashSet<IvyNode> blacklisted = new HashSet<IvyNode>();
        for (ModuleRevisionId mrid : foundBlacklisted) {
            blacklisted.add(resolveData.getNode(mrid));
        }
        for (IvyNode node4 : blacklisted) {
            IvyNodeBlacklist bdata = node4.getBlacklistData(resolveData.getReport().getConfiguration());
            this.handleUnsolvableConflict(bdata.getConflictParent(), Arrays.asList(bdata.getEvictedNode(), bdata.getSelectedNode()), bdata.getEvictedNode(), bdata.getSelectedNode());
        }
    }

    public String toString() {
        return this.getName();
    }
}

