/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.util;

import java.text.ParseException;
import org.apache.ivy.osgi.util.Version;

public class VersionRange {
    private boolean startExclusive;
    private Version startVersion;
    private boolean endExclusive;
    private Version endVersion;

    public VersionRange(String versionStr) throws ParseException {
        if (versionStr == null || versionStr.length() == 0) {
            this.startExclusive = false;
            this.startVersion = new Version(0, 0, 0, null);
            this.endExclusive = true;
            this.endVersion = null;
        } else {
            new VersionRangeParser(versionStr).parse();
        }
    }

    public VersionRange(boolean startExclusive, Version startVersion, boolean endExclusive, Version endVersion) {
        this.startExclusive = startExclusive;
        this.startVersion = startVersion;
        this.endExclusive = endExclusive;
        this.endVersion = endVersion;
    }

    public VersionRange(Version startVersion) {
        this.startExclusive = false;
        this.startVersion = startVersion;
        this.endExclusive = true;
        this.endVersion = null;
    }

    public String toString() {
        return (this.startExclusive ? "(" : "[") + this.startVersion + "," + (this.endVersion == null ? "" : this.endVersion.toString()) + (this.endExclusive ? ")" : "]");
    }

    public String toIvyRevision() {
        StringBuffer buffer2 = new StringBuffer();
        buffer2.append(this.startExclusive ? "(" : "[");
        buffer2.append(this.startVersion);
        if (this.endVersion == null) {
            buffer2.append(",)");
        } else if (!this.endExclusive || this.startVersion.equals(this.endVersion)) {
            buffer2.append(",");
            buffer2.append(this.endVersion.withNudgedPatch());
            buffer2.append(")");
        } else {
            buffer2.append(",");
            buffer2.append(this.endVersion);
            buffer2.append(")");
        }
        return buffer2.toString();
    }

    public boolean isEndExclusive() {
        return this.endExclusive;
    }

    public Version getEndVersion() {
        return this.endVersion;
    }

    public boolean isStartExclusive() {
        return this.startExclusive;
    }

    public Version getStartVersion() {
        return this.startVersion;
    }

    public boolean isClosedRange() {
        return this.startVersion.equals(this.endVersion);
    }

    public boolean contains(String versionStr) throws ParseException {
        return this.contains(new Version(versionStr));
    }

    public boolean contains(Version version2) {
        if (this.startExclusive ? version2.compareUnqualified(this.startVersion) <= 0 : version2.compareUnqualified(this.startVersion) < 0) {
            return false;
        }
        if (this.endVersion == null) {
            return true;
        }
        return !(this.endExclusive ? version2.compareUnqualified(this.endVersion) >= 0 : version2.compareUnqualified(this.endVersion) > 0);
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.endExclusive ? 1231 : 1237);
        result2 = 31 * result2 + (this.endVersion == null ? 0 : this.endVersion.hashCode());
        result2 = 31 * result2 + (this.startExclusive ? 1231 : 1237);
        result2 = 31 * result2 + (this.startVersion == null ? 0 : this.startVersion.hashCode());
        return result2;
    }

    public boolean equals(Object obj2) {
        if (this == obj2) {
            return true;
        }
        if (obj2 == null) {
            return false;
        }
        if (!(obj2 instanceof VersionRange)) {
            return false;
        }
        VersionRange other = (VersionRange)obj2;
        if (this.endExclusive != other.endExclusive) {
            return false;
        }
        if (this.endVersion == null ? other.endVersion != null : !this.endVersion.equals(other.endVersion)) {
            return false;
        }
        if (this.startExclusive != other.startExclusive) {
            return false;
        }
        return !(this.startVersion == null ? other.startVersion != null : !this.startVersion.equals(other.startVersion));
    }

    class VersionRangeParser {
        private final String version;
        private int length;
        private int pos = 0;
        private char c;

        VersionRangeParser(String version2) {
            this.version = version2;
            this.length = version2.length();
        }

        void parse() throws ParseException {
            boolean range2 = this.parseStart();
            VersionRange.this.startVersion = this.parseVersion();
            if (VersionRange.this.startVersion == null) {
                throw new ParseException("Expecting a number", this.pos);
            }
            if (this.parseVersionSeparator()) {
                VersionRange.this.endVersion = this.parseVersion();
                this.parseEnd();
            } else {
                if (range2) {
                    throw new ParseException("Expecting ,", this.pos);
                }
                VersionRange.this.endVersion = null;
                VersionRange.this.startExclusive = false;
                VersionRange.this.endExclusive = false;
            }
        }

        private char readNext() {
            this.c = this.pos == this.length ? (char)'\u0000' : this.version.charAt(this.pos++);
            return this.c;
        }

        private void unread() {
            if (this.pos > 0) {
                --this.pos;
            }
        }

        private boolean parseStart() {
            this.skipWhiteSpace();
            switch (this.readNext()) {
                case '[': {
                    VersionRange.this.startExclusive = false;
                    return true;
                }
                case '(': {
                    VersionRange.this.startExclusive = true;
                    return true;
                }
            }
            this.unread();
            return false;
        }

        private void skipWhiteSpace() {
            do {
                switch (this.readNext()) {
                    case ' ': {
                        break;
                    }
                    default: {
                        this.unread();
                        return;
                    }
                }
            } while (this.pos < this.length);
        }

        private Version parseVersion() {
            Integer major = this.parseNumber();
            if (major == null) {
                return null;
            }
            Integer minor = new Integer(0);
            Integer patch = new Integer(0);
            String qualififer = null;
            if (this.parseNumberSeparator()) {
                minor = this.parseNumber();
                if (minor == null) {
                    minor = new Integer(0);
                } else if (this.parseNumberSeparator()) {
                    patch = this.parseNumber();
                    if (patch == null) {
                        patch = new Integer(0);
                    } else if (this.parseNumberSeparator()) {
                        qualififer = this.parseQualifier();
                    }
                }
            }
            return new Version(major, minor, patch, qualififer);
        }

        private Integer parseNumber() {
            this.skipWhiteSpace();
            Integer n = null;
            do {
                switch (this.readNext()) {
                    case '\u0000': {
                        return n;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        n = new Integer((n == null ? 0 : n * 10) + this.c - 48);
                        break;
                    }
                    default: {
                        this.unread();
                        return n;
                    }
                }
            } while (this.pos < this.length);
            return n;
        }

        private boolean parseNumberSeparator() {
            switch (this.readNext()) {
                case '.': {
                    return true;
                }
            }
            this.unread();
            return false;
        }

        private boolean parseVersionSeparator() {
            this.skipWhiteSpace();
            switch (this.readNext()) {
                case ',': {
                    return true;
                }
            }
            this.unread();
            return false;
        }

        private String parseQualifier() {
            StringBuffer q = new StringBuffer();
            do {
                this.readNext();
                if (!(this.c >= 'a' && this.c <= 'z' || this.c >= 'A' && this.c <= 'Z' || this.c >= '0' && this.c <= '9' || this.c == '-' || this.c == '_')) {
                    this.unread();
                    break;
                }
                q.append(this.c);
            } while (this.pos < this.length);
            if (q.length() == 0) {
                return null;
            }
            return q.toString();
        }

        private void parseEnd() throws ParseException {
            this.skipWhiteSpace();
            switch (this.readNext()) {
                case ']': {
                    VersionRange.this.endExclusive = false;
                    break;
                }
                case ')': {
                    VersionRange.this.endExclusive = true;
                    break;
                }
                default: {
                    this.unread();
                    throw new ParseException("Expexting ] or )", this.pos);
                }
            }
        }
    }
}

