/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.ivy.util.Message;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingHandler
extends DefaultHandler
implements DTDHandler,
ContentHandler,
ErrorHandler {
    private DelegatingHandler delegate = null;
    DelegatingHandler parent;
    private final Map<String, DelegatingHandler> saxHandlerMapping = new HashMap<String, DelegatingHandler>();
    private final Map<String, ChildElementHandler<?>> childHandlerMapping = new HashMap();
    private final String tagName;
    private boolean started = false;
    private boolean skip = false;
    private boolean skipOnError = false;
    private StringBuffer charBuffer = new StringBuffer();
    private boolean bufferingChar = false;
    private Locator locator;
    static final String TRUE = Boolean.TRUE.toString().toLowerCase(Locale.US);
    static final String FALSE = Boolean.FALSE.toString().toLowerCase(Locale.US);

    public DelegatingHandler(String name) {
        this.tagName = name;
        this.charBuffer.setLength(0);
    }

    protected <DH extends DelegatingHandler> void addChild(DH saxHandler, ChildElementHandler<DH> elementHandler) {
        this.saxHandlerMapping.put(saxHandler.getName(), saxHandler);
        this.childHandlerMapping.put(saxHandler.getName(), elementHandler);
        saxHandler.parent = this;
    }

    public String getName() {
        return this.tagName;
    }

    public DelegatingHandler getParent() {
        return this.parent;
    }

    public void setBufferingChar(boolean bufferingChar) {
        this.bufferingChar = bufferingChar;
    }

    public void setSkipOnError(boolean skipOnError) {
        this.skipOnError = skipOnError;
    }

    public boolean isBufferingChar() {
        return this.bufferingChar;
    }

    public String getBufferedChars() {
        return this.charBuffer.toString();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        for (DelegatingHandler subHandler : this.saxHandlerMapping.values()) {
            subHandler.setDocumentLocator(locator);
        }
    }

    public Locator getLocator() {
        return this.locator;
    }

    protected String getCurrentElementIdentifier() {
        return "";
    }

    public void skip() {
        this.skip = true;
        for (DelegatingHandler subHandler : this.saxHandlerMapping.values()) {
            subHandler.stopDelegating();
        }
    }

    protected void stopDelegating() {
        this.parent.delegate = null;
        this.skip = false;
        this.started = false;
        for (DelegatingHandler subHandler : this.saxHandlerMapping.values()) {
            subHandler.stopDelegating();
        }
    }

    private void skipOnError(SkipOnErrorCallback callback) throws SAXException {
        try {
            callback.call();
        }
        catch (SAXException e2) {
            if (this.skipOnError) {
                this.skip();
                this.log(0, e2.getMessage(), e2);
            }
            throw e2;
        }
    }

    @Override
    public final void startDocument() throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.startDocument();
        } else {
            this.doStartDocument();
        }
    }

    protected void doStartDocument() throws SAXException {
    }

    @Override
    public final void endDocument() throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.endDocument();
        } else {
            this.doEndDocument();
        }
    }

    protected void doEndDocument() throws SAXException {
    }

    @Override
    public final void startElement(final String uri, final String localName, final String n, final Attributes atts) throws SAXException {
        this.charBuffer.setLength(0);
        if (this.delegate != null) {
            this.skipOnError(new SkipOnErrorCallback(){

                public void call() throws SAXException {
                    DelegatingHandler.this.delegate.startElement(uri, localName, n, atts);
                }
            });
        } else if (!this.started) {
            if (this.parent == null && !localName.equals(this.tagName)) {
                throw new SAXException("The root element of the parsed document '" + localName + "' didn't matched the expected one: '" + this.tagName + "'");
            }
            this.skipOnError(new SkipOnErrorCallback(){

                public void call() throws SAXException {
                    DelegatingHandler.this.handleAttributes(atts);
                }
            });
            this.started = true;
        } else {
            if (this.skip) {
                return;
            }
            this.delegate = this.saxHandlerMapping.get(localName);
            if (this.delegate != null) {
                this.skipOnError(new SkipOnErrorCallback(){

                    public void call() throws SAXException {
                        DelegatingHandler.this.delegate.startElement(uri, localName, n, atts);
                    }
                });
            }
        }
    }

    protected void handleAttributes(Attributes atts) throws SAXException {
    }

    protected void doStartElement(String uri, String localName, String name, Attributes atts) throws SAXException {
    }

    @Override
    public final void endElement(final String uri, final String localName, final String n) throws SAXException {
        if (this.delegate != null) {
            ChildElementHandler<?> childHandler;
            final DelegatingHandler savedDelegate = this.delegate;
            this.skipOnError(new SkipOnErrorCallback(){

                public void call() throws SAXException {
                    DelegatingHandler.this.delegate.endElement(uri, localName, n);
                }
            });
            if (this.delegate == null && (childHandler = this.childHandlerMapping.get(localName)) != null) {
                this.skipOnError(new SkipOnErrorCallback(){

                    public void call() throws SAXException {
                        childHandler._childHanlded(savedDelegate);
                    }
                });
            }
        } else {
            if (!this.skip) {
                this.doEndElement(uri, localName, n);
            }
            if (this.parent != null && this.tagName.equals(localName)) {
                this.stopDelegating();
            }
        }
    }

    protected void doEndElement(String uri, String localName, String name) throws SAXException {
    }

    @Override
    public final void characters(char[] ch, int start2, int length2) throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.characters(ch, start2, length2);
        } else {
            this.doCharacters(ch, start2, length2);
        }
    }

    protected void doCharacters(char[] ch, int start2, int length2) throws SAXException {
        if (this.bufferingChar) {
            this.charBuffer.append(ch, start2, length2);
        }
    }

    @Override
    public final void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.startPrefixMapping(prefix, uri);
        } else {
            this.doStartPrefixMapping(prefix, uri);
        }
    }

    protected void doStartPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public final void endPrefixMapping(String prefix) throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.endPrefixMapping(prefix);
        } else {
            this.doEndPrefixMapping(prefix);
        }
    }

    protected void doEndPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public final void ignorableWhitespace(char[] ch, int start2, int length2) throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.ignorableWhitespace(ch, start2, length2);
        } else {
            this.doIgnorableWhitespace(ch, start2, length2);
        }
    }

    protected void doIgnorableWhitespace(char[] ch, int start2, int length2) throws SAXException {
    }

    @Override
    public final void notationDecl(String name, String publicId, String systemId) throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.notationDecl(name, publicId, systemId);
        } else {
            this.doNotationDecl(name, publicId, systemId);
        }
    }

    protected void doNotationDecl(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public final void processingInstruction(String target, String data) throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.processingInstruction(target, data);
        } else {
            this.doProcessingInstruction(target, data);
        }
    }

    protected void doProcessingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public final void skippedEntity(String name) throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.skippedEntity(name);
        } else {
            this.doSkippedEntity(name);
        }
    }

    protected void doSkippedEntity(String name) throws SAXException {
    }

    @Override
    public final void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.unparsedEntityDecl(name, publicId, systemId, notationName);
        } else {
            this.doUnparsedEntityDecl(name, publicId, systemId, notationName);
        }
    }

    protected void doUnparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
    }

    @Override
    public final void warning(SAXParseException exception) throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.warning(exception);
        } else {
            this.doWarning(exception);
        }
    }

    protected void doWarning(SAXParseException exception) throws SAXException {
    }

    @Override
    public final void error(SAXParseException exception) throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.error(exception);
        } else {
            this.doError(exception);
        }
    }

    protected void doError(SAXParseException exception) throws SAXException {
    }

    @Override
    public final void fatalError(SAXParseException exception) throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.fatalError(exception);
        } else {
            this.doFatalError(exception);
        }
    }

    protected void doFatalError(SAXParseException exception) throws SAXException {
    }

    protected void log(int logLevel, String message, Throwable t) {
        Message.debug(t);
        this.log(logLevel, message);
    }

    protected void log(int logLevel, String message) {
        Message.log(logLevel, DelegatingHandler.getLocation(this.getLocator()) + message);
    }

    protected static String getLocation(Locator locator) {
        if (locator == null) {
            return "";
        }
        return "[line " + locator.getLineNumber() + " col. " + locator.getColumnNumber() + "] ";
    }

    private void skipOnError(DelegatingHandler currentHandler, Class<? extends DelegatingHandler> handlerClassToSkip, String message) {
        DelegatingHandler handlerToSkip = currentHandler;
        while (!handlerClassToSkip.isAssignableFrom(handlerToSkip.getClass())) {
            handlerToSkip = handlerToSkip.getParent();
        }
        this.log(0, message + ". The '" + handlerToSkip.getName() + "' element " + this.getCurrentElementIdentifier() + " is then ignored.");
        handlerToSkip.skip();
    }

    protected String getRequiredAttribute(Attributes atts, String name) throws SAXParseException {
        String value2 = atts.getValue(name);
        if (value2 == null) {
            throw new SAXParseException("Required attribute '" + name + "' not found", this.getLocator());
        }
        return value2;
    }

    protected String getOptionalAttribute(Attributes atts, String name, String defaultValue) {
        String value2 = atts.getValue(name);
        if (value2 == null) {
            return defaultValue;
        }
        return value2;
    }

    protected int getRequiredIntAttribute(Attributes atts, String name, Integer logLevel) throws SAXParseException {
        return this.parseInt(name, this.getRequiredAttribute(atts, name));
    }

    protected Integer getOptionalIntAttribute(Attributes atts, String name, Integer defaultValue) throws SAXParseException {
        String value2 = atts.getValue(name);
        if (value2 == null) {
            return defaultValue;
        }
        return new Integer(this.parseInt(name, value2));
    }

    private int parseInt(String name, String value2) throws SAXParseException {
        try {
            return Integer.parseInt(value2);
        }
        catch (NumberFormatException e2) {
            throw new SAXParseException("Attribute '" + name + "' is expected to be an integer but was '" + value2 + "' (" + e2.getMessage() + ")", this.getLocator());
        }
    }

    protected long getRequiredLongAttribute(Attributes atts, String name) throws SAXParseException {
        return this.parseLong(name, this.getRequiredAttribute(atts, name));
    }

    protected Long getOptionalLongAttribute(Attributes atts, String name, Long defaultValue) throws SAXParseException {
        String value2 = atts.getValue(name);
        if (value2 == null) {
            return defaultValue;
        }
        return new Long(this.parseLong(name, value2));
    }

    private long parseLong(String name, String value2) throws SAXParseException {
        try {
            return Long.parseLong(value2);
        }
        catch (NumberFormatException e2) {
            throw new SAXParseException("Attribute '" + name + "' is expected to be an long but was '" + value2 + "' (" + e2.getMessage() + ")", this.getLocator());
        }
    }

    protected boolean getRequiredBooleanAttribute(Attributes atts, String name) throws SAXParseException {
        return this.parseBoolean(name, this.getRequiredAttribute(atts, name));
    }

    protected Boolean getOptionalBooleanAttribute(Attributes atts, String name, Boolean defaultValue) throws SAXParseException {
        String value2 = atts.getValue(name);
        if (value2 == null) {
            return defaultValue;
        }
        return this.parseBoolean(name, value2);
    }

    private boolean parseBoolean(String name, String value2) throws SAXParseException {
        String lowerValue = value2.toLowerCase(Locale.US);
        if (lowerValue.equals(TRUE)) {
            return true;
        }
        if (lowerValue.equals(FALSE)) {
            return false;
        }
        throw new SAXParseException("Attribute '" + name + "' is expected to be a boolean but was '" + value2 + "'", this.getLocator());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ChildElementHandler<DH extends DelegatingHandler> {
        public abstract void childHanlded(DH var1) throws SAXParseException;

        private void _childHanlded(DelegatingHandler delegate) throws SAXParseException {
            this.childHanlded(delegate);
        }
    }

    private static interface SkipOnErrorCallback {
        public void call() throws SAXException;
    }
}

