/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.updatesite;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.ivy.core.cache.CacheResourceOptions;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.osgi.core.ExecutionEnvironmentProfileProvider;
import org.apache.ivy.osgi.p2.P2ArtifactParser;
import org.apache.ivy.osgi.p2.P2CompositeParser;
import org.apache.ivy.osgi.p2.P2Descriptor;
import org.apache.ivy.osgi.p2.P2MetadataParser;
import org.apache.ivy.osgi.p2.XMLInputParser;
import org.apache.ivy.osgi.repo.EditableRepoDescriptor;
import org.apache.ivy.osgi.repo.RepoDescriptor;
import org.apache.ivy.osgi.updatesite.UpdateSiteDescriptor;
import org.apache.ivy.osgi.updatesite.xml.EclipseFeature;
import org.apache.ivy.osgi.updatesite.xml.EclipseUpdateSiteParser;
import org.apache.ivy.osgi.updatesite.xml.FeatureParser;
import org.apache.ivy.osgi.updatesite.xml.UpdateSite;
import org.apache.ivy.osgi.updatesite.xml.UpdateSiteDigestParser;
import org.apache.ivy.plugins.repository.url.URLRepository;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.util.Message;
import org.xml.sax.SAXException;

public class UpdateSiteLoader {
    private final RepositoryCacheManager repositoryCacheManager;
    private final URLRepository urlRepository = new URLRepository();
    private final CacheResourceOptions options;
    private int logLevel = 2;

    public UpdateSiteLoader(RepositoryCacheManager repositoryCacheManager, EventManager eventManager, CacheResourceOptions options2) {
        this.repositoryCacheManager = repositoryCacheManager;
        this.options = options2;
        if (eventManager != null) {
            this.urlRepository.addTransferListener(eventManager);
        }
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public RepoDescriptor load(URI repoUri) throws IOException, ParseException, SAXException {
        if (!repoUri.toString().endsWith("/")) {
            try {
                repoUri = new URI(repoUri.toString() + "/");
            }
            catch (URISyntaxException e2) {
                throw new RuntimeException("Cannot make an uri for the repo");
            }
        }
        Message.info("Loading the update site " + repoUri);
        EditableRepoDescriptor repo = this.loadP2(repoUri);
        if (repo != null) {
            return repo;
        }
        Message.verbose("\tNo P2 artifacts, falling back on the old fashioned updatesite");
        UpdateSite site = this.loadSite(repoUri);
        if (site == null) {
            return null;
        }
        repo = this.loadFromDigest(site);
        if (repo != null) {
            return repo;
        }
        return this.loadFromSite(site);
    }

    private P2Descriptor loadP2(URI repoUri) throws IOException, ParseException, SAXException {
        P2Descriptor p2Descriptor = new P2Descriptor(repoUri, ExecutionEnvironmentProfileProvider.getInstance());
        p2Descriptor.setLogLevel(this.logLevel);
        if (!this.populateP2Descriptor(repoUri, p2Descriptor)) {
            return null;
        }
        p2Descriptor.finish();
        return p2Descriptor;
    }

    private boolean populateP2Descriptor(URI repoUri, P2Descriptor p2Descriptor) throws IOException, ParseException, SAXException {
        Message.verbose("Loading P2 repository " + repoUri);
        boolean contentExists = this.readContent(repoUri, p2Descriptor);
        boolean artifactExists = this.readArtifacts(repoUri, p2Descriptor);
        return artifactExists || contentExists;
    }

    private boolean readContent(URI repoUri, P2Descriptor p2Descriptor) throws IOException, ParseException, SAXException {
        boolean contentExists = this.readCompositeContent(repoUri, "compositeContent", p2Descriptor);
        if (!contentExists) {
            P2MetadataParser metadataParser = new P2MetadataParser(p2Descriptor);
            metadataParser.setLogLevel(this.logLevel);
            contentExists = this.readJarOrXml(repoUri, "content", metadataParser);
        }
        return contentExists;
    }

    private boolean readArtifacts(URI repoUri, P2Descriptor p2Descriptor) throws IOException, ParseException, SAXException {
        boolean artifactExists = this.readCompositeArtifact(repoUri, "compositeArtifacts", p2Descriptor);
        if (!artifactExists) {
            artifactExists = this.readJarOrXml(repoUri, "artifacts", new P2ArtifactParser(p2Descriptor, repoUri.toURL().toExternalForm()));
        }
        return artifactExists;
    }

    private boolean readCompositeContent(URI repoUri, String name, P2Descriptor p2Descriptor) throws IOException, ParseException, SAXException {
        P2CompositeParser p2CompositeParser = new P2CompositeParser();
        boolean exist = this.readJarOrXml(repoUri, name, p2CompositeParser);
        if (exist) {
            for (String childLocation : p2CompositeParser.getChildLocations()) {
                if (!childLocation.endsWith("/")) {
                    childLocation = childLocation + "/";
                }
                URI childUri = repoUri.resolve(childLocation);
                this.readContent(childUri, p2Descriptor);
            }
        }
        return exist;
    }

    private boolean readCompositeArtifact(URI repoUri, String name, P2Descriptor p2Descriptor) throws IOException, ParseException, SAXException {
        P2CompositeParser p2CompositeParser = new P2CompositeParser();
        boolean exist = this.readJarOrXml(repoUri, name, p2CompositeParser);
        if (exist) {
            for (String childLocation : p2CompositeParser.getChildLocations()) {
                if (!childLocation.endsWith("/")) {
                    childLocation = childLocation + "/";
                }
                URI childUri = repoUri.resolve(childLocation);
                this.readArtifacts(childUri, p2Descriptor);
            }
        }
        return exist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readJarOrXml(URI repoUri, String baseName, XMLInputParser reader2) throws IOException, ParseException, SAXException {
        InputStream readIn = null;
        URL contentUrl = repoUri.resolve(baseName + ".jar").toURL();
        URLResource res = new URLResource(contentUrl);
        ArtifactDownloadReport report = this.repositoryCacheManager.downloadRepositoryResource(res, baseName, baseName, "jar", this.options, this.urlRepository);
        if (report.getDownloadStatus() == DownloadStatus.FAILED) {
            contentUrl = repoUri.resolve(baseName + ".xml").toURL();
            res = new URLResource(contentUrl);
            report = this.repositoryCacheManager.downloadRepositoryResource(res, baseName, baseName, "xml", this.options, this.urlRepository);
            if (report.getDownloadStatus() == DownloadStatus.FAILED) {
                return false;
            }
            readIn = new FileInputStream(report.getLocalFile());
        } else {
            FileInputStream in2 = new FileInputStream(report.getLocalFile());
            try {
                readIn = this.findEntry(in2, baseName + ".xml");
                if (readIn == null) {
                    ((InputStream)in2).close();
                    return false;
                }
            }
            catch (IOException e2) {
                ((InputStream)in2).close();
                throw e2;
            }
        }
        try {
            reader2.parse(readIn);
        }
        finally {
            ((InputStream)readIn).close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateSite loadSite(URI repoUri) throws IOException, ParseException, SAXException {
        URI siteUri = this.normalizeSiteUri(repoUri, null);
        URL u = siteUri.resolve("site.xml").toURL();
        URLResource res = new URLResource(u);
        ArtifactDownloadReport report = this.repositoryCacheManager.downloadRepositoryResource(res, "site", "updatesite", "xml", this.options, this.urlRepository);
        if (report.getDownloadStatus() == DownloadStatus.FAILED) {
            return null;
        }
        FileInputStream in2 = new FileInputStream(report.getLocalFile());
        try {
            UpdateSite site = EclipseUpdateSiteParser.parse(in2);
            site.setUri(this.normalizeSiteUri(site.getUri(), siteUri));
            UpdateSite updateSite = site;
            return updateSite;
        }
        finally {
            ((InputStream)in2).close();
        }
    }

    private URI normalizeSiteUri(URI uri, URI defaultValue) {
        if (uri == null) {
            return defaultValue;
        }
        String uriString = uri.toString();
        if (uriString.endsWith("site.xml")) {
            try {
                return new URI(uriString.substring(0, uriString.length() - 8));
            }
            catch (URISyntaxException e2) {
                throw new RuntimeException("Illegal uri", e2);
            }
        }
        if (!uriString.endsWith("/")) {
            try {
                return new URI(uriString + "/");
            }
            catch (URISyntaxException e3) {
                throw new RuntimeException("Illegal uri", e3);
            }
        }
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateSiteDescriptor loadFromDigest(UpdateSite site) throws IOException, ParseException, SAXException {
        URI digestBaseUri = site.getDigestUri();
        if (digestBaseUri == null) {
            digestBaseUri = site.getUri();
        } else if (!digestBaseUri.isAbsolute()) {
            digestBaseUri = site.getUri().resolve(digestBaseUri);
        }
        URL digest2 = digestBaseUri.resolve("digest.zip").toURL();
        Message.verbose("\tReading " + digest2);
        URLResource res = new URLResource(digest2);
        ArtifactDownloadReport report = this.repositoryCacheManager.downloadRepositoryResource(res, "digest", "digest", "zip", this.options, this.urlRepository);
        if (report.getDownloadStatus() == DownloadStatus.FAILED) {
            return null;
        }
        FileInputStream in2 = new FileInputStream(report.getLocalFile());
        try {
            ZipInputStream zipped = this.findEntry(in2, "digest.xml");
            if (zipped == null) {
                UpdateSiteDescriptor updateSiteDescriptor = null;
                return updateSiteDescriptor;
            }
            UpdateSiteDescriptor updateSiteDescriptor = UpdateSiteDigestParser.parse(zipped, site);
            return updateSiteDescriptor;
        }
        finally {
            ((InputStream)in2).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateSiteDescriptor loadFromSite(UpdateSite site) throws IOException, ParseException, SAXException {
        UpdateSiteDescriptor repoDescriptor = new UpdateSiteDescriptor(site.getUri(), ExecutionEnvironmentProfileProvider.getInstance());
        for (EclipseFeature feature : site.getFeatures()) {
            URL url = site.getUri().resolve(feature.getUrl()).toURL();
            URLResource res = new URLResource(url);
            ArtifactDownloadReport report = this.repositoryCacheManager.downloadRepositoryResource(res, feature.getId(), "feature", "jar", this.options, this.urlRepository);
            if (report.getDownloadStatus() == DownloadStatus.FAILED) {
                return null;
            }
            FileInputStream in2 = new FileInputStream(report.getLocalFile());
            try {
                ZipInputStream zipped = this.findEntry(in2, "feature.xml");
                if (zipped == null) {
                    UpdateSiteDescriptor updateSiteDescriptor = null;
                    return updateSiteDescriptor;
                }
                EclipseFeature f2 = FeatureParser.parse(zipped);
                f2.setURL(feature.getUrl());
                repoDescriptor.addFeature(f2);
            }
            finally {
                ((InputStream)in2).close();
            }
        }
        return repoDescriptor;
    }

    private ZipInputStream findEntry(InputStream in2, String entryName) throws IOException {
        ZipInputStream zipped = new ZipInputStream(in2);
        ZipEntry zipEntry = zipped.getNextEntry();
        while (zipEntry != null && !zipEntry.getName().equals(entryName)) {
            zipEntry = zipped.getNextEntry();
        }
        if (zipEntry == null) {
            return null;
        }
        return zipped;
    }
}

