/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.repo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.ivy.osgi.repo.AbstractFSManifestIterable;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.resolver.util.ResolverHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryManifestIterable
extends AbstractFSManifestIterable<String> {
    private final Repository repo;

    public RepositoryManifestIterable(Repository repo) {
        super("");
        this.repo = repo;
    }

    @Override
    protected URI buildBundleURI(String location) throws IOException {
        Resource resource = this.repo.getResource(location);
        try {
            return new URI(resource.getName());
        }
        catch (URISyntaxException e2) {
            return new File(resource.getName()).toURI();
        }
    }

    @Override
    protected InputStream getInputStream(String f2) throws IOException {
        return this.repo.getResource(f2).openStream();
    }

    @Override
    protected List<String> listBundleFiles(String dir) throws IOException {
        return this.asList(ResolverHelper.listAll(this.repo, dir));
    }

    @Override
    protected List<String> listDirs(String dir) throws IOException {
        return this.asList(ResolverHelper.listAll(this.repo, dir));
    }

    private List<String> asList(String[] array) {
        return array == null ? Collections.emptyList() : Arrays.asList(array);
    }
}

