/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.repo;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ivy.osgi.repo.AbstractFSManifestIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSManifestIterable
extends AbstractFSManifestIterable<File> {
    public static final Set<String> NON_BUNDLE_DIRS = new HashSet<String>(Arrays.asList("source", "sources", "javadoc", "javadocs", "doc", "docs"));
    public static final FilenameFilter DEFAULT_DIR_FILTER = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return !name.equals(".svn") && !NON_BUNDLE_DIRS.contains(name);
        }
    };
    public static final FilenameFilter DEFAULT_BUNLDE_FILTER = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    };
    private FilenameFilter dirFilter = DEFAULT_DIR_FILTER;
    private FilenameFilter bundleFilter = DEFAULT_BUNLDE_FILTER;

    public FSManifestIterable(File root) {
        super(root);
    }

    public FilenameFilter getDirFilter() {
        return this.dirFilter;
    }

    public void setDirFilter(FilenameFilter dirFilter) {
        this.dirFilter = dirFilter;
    }

    public FilenameFilter getBundleFilter() {
        return this.bundleFilter;
    }

    public void setBundleFilter(FilenameFilter bundleFilter) {
        this.bundleFilter = bundleFilter;
    }

    @Override
    protected URI buildBundleURI(File location) {
        try {
            return new URI(location.toURI().toURL().toExternalForm());
        }
        catch (MalformedURLException e2) {
            throw new RuntimeException("Unexpected file to url conversion error", e2);
        }
        catch (URISyntaxException e3) {
            throw new RuntimeException("Unexpected url to uri conversion error", e3);
        }
    }

    @Override
    protected InputStream getInputStream(File f2) throws FileNotFoundException {
        return new FileInputStream(f2);
    }

    @Override
    protected List<File> listBundleFiles(File dir) {
        return Arrays.asList(dir.listFiles(new FileFilter(){

            public boolean accept(File f2) {
                if (!f2.isFile()) {
                    return false;
                }
                return FSManifestIterable.this.bundleFilter.accept(f2.getParentFile(), f2.getName());
            }
        }));
    }

    @Override
    protected List<File> listDirs(File dir) {
        return Arrays.asList(dir.listFiles(new FileFilter(){

            public boolean accept(File f2) {
                if (!f2.isDirectory()) {
                    return false;
                }
                return FSManifestIterable.this.dirFilter == null || FSManifestIterable.this.dirFilter.accept(f2.getParentFile(), f2.getName());
            }
        }));
    }
}

