/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.repo;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipInputStream;
import org.apache.ivy.osgi.repo.ManifestAndLocation;
import org.apache.ivy.util.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFSManifestIterable<T>
implements Iterable<ManifestAndLocation> {
    private final T root;

    public AbstractFSManifestIterable(T root) {
        this.root = root;
    }

    @Override
    public Iterator<ManifestAndLocation> iterator() {
        return new FSManifestIterator();
    }

    protected abstract List<T> listBundleFiles(T var1) throws IOException;

    protected abstract List<T> listDirs(T var1) throws IOException;

    protected abstract InputStream getInputStream(T var1) throws IOException;

    protected abstract URI buildBundleURI(T var1) throws IOException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FSManifestIterator
    implements Iterator<ManifestAndLocation> {
        private ManifestAndLocation next = null;
        private Stack<Iterator<T>> dirs = new Stack();
        private Iterator<T> bundleCandidates = null;
        private T currentDir = null;

        FSManifestIterator() {
            this.dirs.add(Collections.singleton(AbstractFSManifestIterable.this.root).iterator());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            while (this.next == null) {
                if (this.currentDir == null) {
                    if (this.dirs.peek().hasNext()) {
                        this.currentDir = this.dirs.peek().next();
                        try {
                            this.bundleCandidates = AbstractFSManifestIterable.this.listBundleFiles(this.currentDir).iterator();
                        }
                        catch (IOException e2) {
                            Message.warn("Unlistable dir: " + this.currentDir, e2);
                            this.currentDir = null;
                        }
                        continue;
                    }
                    if (this.dirs.size() <= 1) {
                        return false;
                    }
                    this.dirs.pop();
                    continue;
                }
                if (this.bundleCandidates.hasNext()) {
                    Object bundleCandidate = this.bundleCandidates.next();
                    ZipInputStream in2 = null;
                    try {
                        in2 = new JarInputStream(AbstractFSManifestIterable.this.getInputStream(bundleCandidate));
                        Manifest manifest = ((JarInputStream)in2).getManifest();
                        if (manifest != null) {
                            this.next = new ManifestAndLocation(manifest, AbstractFSManifestIterable.this.buildBundleURI(bundleCandidate), null);
                            continue;
                        }
                        Message.debug("No manifest in jar: " + bundleCandidate);
                        continue;
                    }
                    catch (FileNotFoundException e3) {
                        Message.debug("Jar file just removed: " + bundleCandidate, e3);
                        continue;
                    }
                    catch (IOException e4) {
                        Message.warn("Unreadable jar: " + bundleCandidate, e4);
                        continue;
                    }
                    finally {
                        if (in2 == null) continue;
                        try {
                            in2.close();
                        }
                        catch (IOException e5) {}
                        continue;
                    }
                }
                try {
                    this.dirs.add(AbstractFSManifestIterable.this.listDirs(this.currentDir).iterator());
                }
                catch (IOException e6) {
                    Message.warn("Unlistable dir: " + this.currentDir + " (" + e6 + ")");
                    this.dirs.add(Collections.emptyList().iterator());
                }
                this.currentDir = null;
            }
            return true;
        }

        @Override
        public ManifestAndLocation next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ManifestAndLocation manifest = this.next;
            this.next = null;
            return manifest;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

