/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.obr.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.osgi.core.BundleArtifact;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.ExecutionEnvironmentProfileProvider;
import org.apache.ivy.osgi.filter.OSGiFilter;
import org.apache.ivy.osgi.filter.OSGiFilterParser;
import org.apache.ivy.osgi.obr.xml.Capability;
import org.apache.ivy.osgi.obr.xml.CapabilityAdapter;
import org.apache.ivy.osgi.obr.xml.Requirement;
import org.apache.ivy.osgi.obr.xml.RequirementAdapter;
import org.apache.ivy.osgi.obr.xml.UnsupportedFilterException;
import org.apache.ivy.osgi.repo.BundleRepoDescriptor;
import org.apache.ivy.osgi.util.DelegatingHandler;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.util.XMLHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class OBRXMLParser {
    public static BundleRepoDescriptor parse(URI baseUri, InputStream in2) throws ParseException, IOException, SAXException {
        RepositoryHandler handler = new RepositoryHandler(baseUri);
        try {
            XMLHelper.parse(in2, null, (DefaultHandler)handler, null);
        }
        catch (ParserConfigurationException e2) {
            throw new SAXException(e2);
        }
        return handler.repo;
    }

    static class ExtendHandler
    extends AbstractRequirementHandler {
        static final String EXTEND = "extend";

        public ExtendHandler() {
            super(EXTEND);
        }
    }

    static class RequireHandler
    extends AbstractRequirementHandler {
        static final String REQUIRE = "require";

        public RequireHandler() {
            super(REQUIRE);
        }
    }

    static class AbstractRequirementHandler
    extends DelegatingHandler {
        static final String NAME = "name";
        static final String OPTIONAL = "optional";
        static final String MULTIPLE = "multiple";
        static final String FILTER = "filter";
        Requirement requirement;
        OSGiFilter filter;

        public AbstractRequirementHandler(String name) {
            super(name);
        }

        protected void handleAttributes(Attributes atts) throws SAXException {
            String name = this.getRequiredAttribute(atts, NAME);
            String filterText = atts.getValue(FILTER);
            this.filter = null;
            if (filterText != null) {
                try {
                    this.filter = OSGiFilterParser.parse(filterText);
                }
                catch (ParseException e2) {
                    throw new SAXParseException("Requirement with illformed filter: " + filterText, this.getLocator());
                }
            }
            Boolean optional2 = this.getOptionalBooleanAttribute(atts, OPTIONAL, null);
            Boolean multiple = this.getOptionalBooleanAttribute(atts, MULTIPLE, null);
            this.requirement = new Requirement(name, this.filter);
            if (optional2 != null) {
                this.requirement.setOptional(optional2);
            }
            if (multiple != null) {
                this.requirement.setMultiple(multiple);
            }
        }
    }

    static class CapabilityPropertyHandler
    extends DelegatingHandler {
        static final String CAPABILITY_PROPERTY = "p";
        static final String NAME = "n";
        static final String VALUE = "v";
        static final String TYPE = "t";
        String name;
        String value;
        String type;

        public CapabilityPropertyHandler() {
            super(CAPABILITY_PROPERTY);
        }

        protected void handleAttributes(Attributes atts) throws SAXException {
            this.name = this.getRequiredAttribute(atts, NAME);
            this.value = this.getRequiredAttribute(atts, VALUE);
            this.type = atts.getValue(TYPE);
        }
    }

    static class CapabilityHandler
    extends DelegatingHandler {
        static final String CAPABILITY = "capability";
        static final String NAME = "name";
        Capability capability;

        public CapabilityHandler() {
            super(CAPABILITY);
            this.addChild(new CapabilityPropertyHandler(), new DelegatingHandler.ChildElementHandler<CapabilityPropertyHandler>(){

                @Override
                public void childHanlded(CapabilityPropertyHandler child) {
                    String name = child.name;
                    String value2 = child.value;
                    String type = child.type;
                    CapabilityHandler.this.capability.addProperty(name, value2, type);
                }
            });
        }

        protected void handleAttributes(Attributes atts) throws SAXException {
            String name = this.getRequiredAttribute(atts, NAME);
            this.capability = new Capability(name);
        }
    }

    static class ResourceSizeHandler
    extends DelegatingHandler {
        static final String SIZE = "size";

        public ResourceSizeHandler() {
            super(SIZE);
            this.setBufferingChar(true);
        }
    }

    static class ResourceLicenseHandler
    extends DelegatingHandler {
        static final String LICENSE = "license";

        public ResourceLicenseHandler() {
            super(LICENSE);
            this.setBufferingChar(true);
        }
    }

    static class ResourceDocumentationHandler
    extends DelegatingHandler {
        static final String DOCUMENTATION = "documentation";

        public ResourceDocumentationHandler() {
            super(DOCUMENTATION);
            this.setBufferingChar(true);
        }
    }

    static class ResourceDescriptionHandler
    extends DelegatingHandler {
        static final String DESCRIPTION = "description";

        public ResourceDescriptionHandler() {
            super(DESCRIPTION);
            this.setBufferingChar(true);
        }
    }

    static class ResourceSourceHandler
    extends DelegatingHandler {
        static final String SOURCE = "source";

        public ResourceSourceHandler() {
            super(SOURCE);
            this.setBufferingChar(true);
        }
    }

    static class ResourceHandler
    extends DelegatingHandler {
        private static final String DEFAULT_VERSION = "1.0.0";
        static final String RESOURCE = "resource";
        static final String ID = "id";
        static final String PRESENTATION_NAME = "presentationname";
        static final String SYMBOLIC_NAME = "symbolicname";
        static final String URI = "uri";
        static final String VERSION = "version";
        BundleInfo bundleInfo;

        public ResourceHandler() {
            super(RESOURCE);
            this.setSkipOnError(true);
            this.addChild(new ResourceSourceHandler(), new DelegatingHandler.ChildElementHandler<ResourceSourceHandler>(){

                @Override
                public void childHanlded(ResourceSourceHandler child) {
                    String uri = child.getBufferedChars().trim();
                    if (!uri.endsWith(".jar")) {
                        ResourceHandler.this.log(1, "A source uri is suspect, it is not ending with .jar, it is probably a pointer to a download page. Ignoring it.");
                        return;
                    }
                    try {
                        ResourceHandler.this.bundleInfo.addArtifact(new BundleArtifact(true, new URI(uri), null));
                    }
                    catch (URISyntaxException e2) {
                        ResourceHandler.this.log(1, "Incorrect uri " + uri + ". The source of " + ResourceHandler.this.bundleInfo.getSymbolicName() + " is then ignored.");
                        return;
                    }
                }
            });
            this.addChild(new ResourceDescriptionHandler(), new DelegatingHandler.ChildElementHandler<ResourceDescriptionHandler>(){

                @Override
                public void childHanlded(ResourceDescriptionHandler child) {
                    ResourceHandler.this.bundleInfo.setDescription(child.getBufferedChars().trim());
                }
            });
            this.addChild(new ResourceDocumentationHandler(), new DelegatingHandler.ChildElementHandler<ResourceDocumentationHandler>(){

                @Override
                public void childHanlded(ResourceDocumentationHandler child) {
                    ResourceHandler.this.bundleInfo.setDocumentation(child.getBufferedChars().trim());
                }
            });
            this.addChild(new ResourceLicenseHandler(), new DelegatingHandler.ChildElementHandler<ResourceLicenseHandler>(){

                @Override
                public void childHanlded(ResourceLicenseHandler child) {
                    ResourceHandler.this.bundleInfo.setLicense(child.getBufferedChars().trim());
                }
            });
            this.addChild(new ResourceSizeHandler(), new DelegatingHandler.ChildElementHandler<ResourceSizeHandler>(){

                @Override
                public void childHanlded(ResourceSizeHandler child) {
                    String size2 = child.getBufferedChars().trim();
                    try {
                        ResourceHandler.this.bundleInfo.setSize(Integer.valueOf(size2));
                    }
                    catch (NumberFormatException e2) {
                        ResourceHandler.this.log(1, "Invalid size for the bundle " + ResourceHandler.this.bundleInfo.getSymbolicName() + ": " + size2 + ". This size is then ignored.");
                    }
                }
            });
            this.addChild(new CapabilityHandler(), new DelegatingHandler.ChildElementHandler<CapabilityHandler>(){

                @Override
                public void childHanlded(CapabilityHandler child) throws SAXParseException {
                    try {
                        CapabilityAdapter.adapt(ResourceHandler.this.bundleInfo, child.capability);
                    }
                    catch (ParseException e2) {
                        throw new SAXParseException("Invalid capability: " + e2.getMessage(), child.getLocator());
                    }
                }
            });
            this.addChild(new RequireHandler(), new DelegatingHandler.ChildElementHandler<RequireHandler>(){

                @Override
                public void childHanlded(RequireHandler child) throws SAXParseException {
                    try {
                        RequirementAdapter.adapt(ResourceHandler.this.bundleInfo, child.requirement);
                    }
                    catch (UnsupportedFilterException e2) {
                        throw new SAXParseException("Unsupported requirement filter: " + child.filter + " (" + e2.getMessage() + ")", ResourceHandler.this.getLocator());
                    }
                    catch (ParseException e3) {
                        throw new SAXParseException("Error in the requirement filter on the bundle: " + e3.getMessage(), ResourceHandler.this.getLocator());
                    }
                }
            });
            this.addChild(new ExtendHandler(), new DelegatingHandler.ChildElementHandler<ExtendHandler>(){

                @Override
                public void childHanlded(ExtendHandler child) throws SAXParseException {
                }
            });
        }

        protected void handleAttributes(Attributes atts) throws SAXException {
            Version version2;
            String symbolicname = atts.getValue(SYMBOLIC_NAME);
            if (symbolicname == null) {
                this.log(0, "Resource with no symobilc name, skipping it.");
                this.skip();
                return;
            }
            String v2 = this.getOptionalAttribute(atts, VERSION, DEFAULT_VERSION);
            try {
                version2 = new Version(v2);
            }
            catch (ParseException e2) {
                this.log(0, "Incorrect resource version: " + v2 + ". The resource " + symbolicname + " is then ignored.");
                this.skip();
                return;
            }
            this.bundleInfo = new BundleInfo(symbolicname, version2);
            this.bundleInfo.setPresentationName(atts.getValue(PRESENTATION_NAME));
            String uri = atts.getValue(URI);
            if (uri != null) {
                try {
                    this.bundleInfo.addArtifact(new BundleArtifact(false, new URI(uri), null));
                }
                catch (URISyntaxException e3) {
                    this.log(0, "Incorrect uri " + uri + ". The resource " + symbolicname + " is then ignored.");
                    this.skip();
                    return;
                }
            }
            this.bundleInfo.setId(atts.getValue(ID));
        }

        protected String getCurrentElementIdentifier() {
            return this.bundleInfo.getSymbolicName() + "/" + this.bundleInfo.getVersion();
        }
    }

    static class RepositoryHandler
    extends DelegatingHandler {
        static final String REPOSITORY = "repository";
        static final String LASTMODIFIED = "lastmodified";
        static final String NAME = "name";
        BundleRepoDescriptor repo;
        private final URI baseUri;

        public RepositoryHandler(URI baseUri) {
            super(REPOSITORY);
            this.baseUri = baseUri;
            this.addChild(new ResourceHandler(), new DelegatingHandler.ChildElementHandler<ResourceHandler>(){

                @Override
                public void childHanlded(ResourceHandler child) {
                    RepositoryHandler.this.repo.addBundle(child.bundleInfo);
                }
            });
        }

        protected void handleAttributes(Attributes atts) {
            this.repo = new BundleRepoDescriptor(this.baseUri, ExecutionEnvironmentProfileProvider.getInstance());
            this.repo.setName(atts.getValue(NAME));
            this.repo.setLastModified(atts.getValue(LASTMODIFIED));
        }
    }
}

