/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.obr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import org.apache.ivy.core.cache.CacheResourceOptions;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.osgi.obr.xml.OBRXMLParser;
import org.apache.ivy.osgi.repo.AbstractOSGiResolver;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.xml.sax.SAXException;

public class OBRResolver
extends AbstractOSGiResolver {
    private String repoXmlURL;
    private String repoXmlFile;
    private Long metadataTtl;
    private Boolean forceMetadataUpdate;

    public void setRepoXmlFile(String repositoryXmlFile) {
        this.repoXmlFile = repositoryXmlFile;
    }

    public void setRepoXmlURL(String repositoryXmlURL) {
        this.repoXmlURL = repositoryXmlURL;
    }

    public void setMetadataTtl(Long metadataTtl) {
        this.metadataTtl = metadataTtl;
    }

    public void setForceMetadataUpdate(Boolean forceMetadataUpdate) {
        this.forceMetadataUpdate = forceMetadataUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        if (this.repoXmlFile != null && this.repoXmlURL != null) {
            throw new RuntimeException("The OBR repository resolver " + this.getName() + " couldn't be configured: repoXmlFile and repoXmlUrl cannot be set both");
        }
        if (this.repoXmlFile != null) {
            File f2 = new File(this.repoXmlFile);
            this.loadRepoFromFile(f2.getParentFile().toURI(), f2, this.repoXmlFile);
        } else if (this.repoXmlURL != null) {
            URI baseURI;
            ArtifactDownloadReport report;
            URL url;
            try {
                url = new URL(this.repoXmlURL);
            }
            catch (MalformedURLException e2) {
                throw new RuntimeException("The OBR repository resolver " + this.getName() + " couldn't be configured: repoXmlURL '" + this.repoXmlURL + "' is not an URL");
            }
            EventManager eventManager = this.getEventManager();
            try {
                if (eventManager != null) {
                    this.getRepository().addTransferListener(eventManager);
                }
                URLResource obrResource = new URLResource(url);
                CacheResourceOptions options2 = new CacheResourceOptions();
                if (this.metadataTtl != null) {
                    options2.setTtl(this.metadataTtl);
                }
                if (this.forceMetadataUpdate != null) {
                    options2.setForce(this.forceMetadataUpdate);
                }
                report = this.getRepositoryCacheManager().downloadRepositoryResource(obrResource, "obr", "obr", "xml", options2, this.getRepository());
            }
            finally {
                if (eventManager != null) {
                    this.getRepository().removeTransferListener(eventManager);
                }
            }
            try {
                baseURI = new URI(this.repoXmlURL);
            }
            catch (URISyntaxException e3) {
                throw new RuntimeException("illegal uri");
            }
            this.loadRepoFromFile(baseURI, report.getLocalFile(), this.repoXmlURL);
        } else {
            throw new RuntimeException("The OBR repository resolver " + this.getName() + " couldn't be configured: repoXmlFile or repoXmlUrl is missing");
        }
    }

    private void loadRepoFromFile(URI baseUri, File repoFile, String sourceLocation) {
        FileInputStream in2;
        try {
            in2 = new FileInputStream(repoFile);
        }
        catch (FileNotFoundException e2) {
            throw new RuntimeException("The OBR repository resolver " + this.getName() + " couldn't be configured: the file " + sourceLocation + " was not found");
        }
        try {
            this.setRepoDescriptor(OBRXMLParser.parse(baseUri, in2));
        }
        catch (ParseException e3) {
            throw new RuntimeException("The OBR repository resolver " + this.getName() + " couldn't be configured: the file " + sourceLocation + " is incorrectly formed (" + e3.getMessage() + ")", e3);
        }
        catch (IOException e4) {
            throw new RuntimeException("The OBR repository resolver " + this.getName() + " couldn't be configured: the file " + sourceLocation + " could not be read (" + e4.getMessage() + ")", e4);
        }
        catch (SAXException e5) {
            throw new RuntimeException("The OBR repository resolver " + this.getName() + " couldn't be configured: the file " + sourceLocation + " has incorrect XML (" + e5.getMessage() + ")", e5);
        }
        try {
            in2.close();
        }
        catch (IOException e6) {
            // empty catch block
        }
    }
}

